/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.uritemplate.impl;

import io.netty.util.collection.CharObjectHashMap;
import io.netty.util.collection.CharObjectMap;
import io.vertx.uritemplate.ExpandOptions;
import io.vertx.uritemplate.UriTemplate;
import io.vertx.uritemplate.Variables;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UriTemplateImpl
implements UriTemplate {
    private static final String HEX_ALPHABET = "0123456789ABCDEF";
    private static final CharObjectMap<Operator> mapping;
    private final List<Term> terms = new ArrayList<Term>();
    private static final ThreadLocal<PctEncoder> PCT_ENCODER;

    @Override
    public String expandToString(Variables variables, ExpandOptions options) {
        return this.expandToString(variables, options.getAllowVariableMiss());
    }

    @Override
    public String expandToString(Variables variables) {
        return this.expandToString(variables, true);
    }

    private String expandToString(Variables variables, boolean allowVariableMiss) {
        StringBuilder sb = new StringBuilder();
        for (Term term : this.terms) {
            if (term instanceof Literals) {
                sb.append(((Literals)term).value);
                continue;
            }
            Expression expression = (Expression)term;
            expression.operator.expand(expression.value, variables, allowVariableMiss, sb);
        }
        return sb.toString();
    }

    private static void encodeString(String s, CharSet allowedSet, boolean allowPctEncoded, StringBuilder buff) {
        int i = 0;
        while (i < s.length()) {
            char ch;
            if (Character.isSurrogate(ch = s.charAt(i++))) {
                PCT_ENCODER.get().encodeChars(ch, s.charAt(i++), buff);
                continue;
            }
            if (allowPctEncoded && ch == '%' && i + 1 < s.length() && Parser.isHEXDIG(s.charAt(i)) && Parser.isHEXDIG(s.charAt(i + 1))) {
                buff.append(s, i - 1, i + 2);
                i += 2;
                continue;
            }
            UriTemplateImpl.encodeChar(ch, allowedSet, buff);
        }
    }

    private static void encodeChar(char ch, CharSet allowedSet, StringBuilder buff) {
        if (allowedSet.contains(ch)) {
            buff.append(ch);
        } else {
            PCT_ENCODER.get().encodeChar(ch, buff);
        }
    }

    private static void pctEncode(String s, StringBuilder buff) {
        byte[] bytes;
        for (byte b : bytes = s.getBytes(StandardCharsets.UTF_8)) {
            UriTemplateImpl.pctEncode(b, buff);
        }
    }

    private static void pctEncode(byte b, StringBuilder buff) {
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buff.append('%');
        buff.append(HEX_ALPHABET, high, high + 1);
        buff.append(HEX_ALPHABET, low, low + 1);
    }

    static {
        CharObjectHashMap m = new CharObjectHashMap();
        for (Operator op : Operator.values()) {
            for (char ch : ((Operator)op).so.chars) {
                m.put(ch, (Object)op);
            }
        }
        mapping = m;
        PCT_ENCODER = ThreadLocal.withInitial(() -> new PctEncoder());
    }

    private static class PctEncoder {
        private final CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        private final ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        private final CharBuffer charBuffer = CharBuffer.allocate(2);

        private PctEncoder() {
        }

        void encodeChar(char ch, StringBuilder buff) {
            try {
                this.charBuffer.put(ch);
                this.charBuffer.flip();
                this.encode(buff);
            }
            finally {
                this.encoder.reset();
                this.byteBuffer.clear();
                this.charBuffer.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void encodeChars(char ch1, char ch2, StringBuilder buff) {
            try {
                this.charBuffer.put(ch1);
                this.charBuffer.put(ch2);
                this.charBuffer.flip();
                this.encode(buff);
            }
            finally {
                this.encoder.reset();
                this.byteBuffer.clear();
                this.charBuffer.clear();
            }
        }

        private void encode(StringBuilder buff) {
            CoderResult res = this.encoder.encode(this.charBuffer, this.byteBuffer, true);
            if (res.isUnderflow()) {
                int pos = this.byteBuffer.position();
                this.byteBuffer.flip();
                for (int i = 0; i < pos; ++i) {
                    byte b = this.byteBuffer.get(i);
                    UriTemplateImpl.pctEncode(b, buff);
                }
            }
        }
    }

    public static class Parser {
        private UriTemplateImpl template;
        private Expression expression;
        private int digit;
        private char pctEncoded;
        public StringBuilder literals;
        public Varspec varspec;
        private StringBuilder sb;
        private boolean exploded;
        private int maxLength;

        public UriTemplateImpl parseURITemplate(String s) {
            this.template = new UriTemplateImpl();
            if (this.parseURITemplate(s, 0) != s.length()) {
                throw new IllegalArgumentException();
            }
            for (Term term : this.template.terms) {
                if (!(term instanceof Expression) || ((Expression)term).operator != Operator.FUTURE) continue;
                throw new IllegalArgumentException("Invalid reserved operator");
            }
            return this.template;
        }

        public int parseURITemplate(String s, int pos) {
            while (true) {
                int idx;
                if ((idx = this.parseLiterals(s, pos)) > pos) {
                    this.template.terms.add(new Literals(this.literals.toString()));
                    pos = idx;
                    continue;
                }
                idx = this.parseExpression(s, pos);
                if (idx <= pos) break;
                pos = idx;
            }
            return pos;
        }

        public int parseExpression(String s, int pos) {
            if (pos < s.length() && s.charAt(pos) == '{') {
                Operator operator;
                int idx = pos + 1;
                if (idx < s.length() && Parser.isOperator(s.charAt(idx))) {
                    operator = (Operator)((Object)mapping.get(s.charAt(idx)));
                    ++idx;
                } else {
                    operator = Operator.SIMPLE_STRING_EXPANSION;
                }
                this.expression = new Expression(operator);
                idx = this.parseVariableList(s, idx);
                if (idx < s.length() && s.charAt(idx) == '}') {
                    pos = idx + 1;
                }
                if (this.template != null) {
                    this.template.terms.add(this.expression);
                }
                this.expression = null;
            }
            return pos;
        }

        private static boolean isALPHA(char ch) {
            return 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z';
        }

        public int parseDIGIT(String s, int pos) {
            char c;
            if (pos < s.length() && Parser.isDIGIT(c = s.charAt(pos))) {
                this.digit = c - 48;
                ++pos;
            }
            return pos;
        }

        private static boolean isDIGIT(char ch) {
            return '0' <= ch && ch <= '9';
        }

        static boolean isHEXDIG(char ch) {
            return Parser.isDIGIT(ch) || 'A' <= ch && ch <= 'F' || 'a' <= ch && ch <= 'f';
        }

        private int parsePctEncoded(String s, int pos) {
            byte[] buffer = new byte[]{};
            while (pos + 2 < s.length() && s.charAt(pos) == '%' && Parser.isHEXDIG(s.charAt(pos + 1)) && Parser.isHEXDIG(s.charAt(pos + 2))) {
                CharBuffer chars;
                buffer = Arrays.copyOf(buffer, buffer.length + 1);
                buffer[buffer.length - 1] = (byte)Integer.parseInt(s.substring(pos + 1, pos + 3), 16);
                pos += 3;
                ByteBuffer bb = ByteBuffer.wrap(buffer);
                CharsetDecoder dec = StandardCharsets.UTF_8.newDecoder();
                CoderResult result = dec.decode(bb, chars = CharBuffer.allocate(1), true);
                if (!result.isUnderflow()) continue;
                dec.flush(chars);
                chars.flip();
                this.pctEncoded = chars.charAt(0);
                break;
            }
            return pos;
        }

        private static boolean isUnreserved(char ch) {
            return Parser.isALPHA(ch) || Parser.isDIGIT(ch) || ch == '-' || ch == '.' || ch == '_' || ch == '~';
        }

        private static boolean isReserved(char ch) {
            return Parser.isGenDelims(ch) || Parser.isSubDelims(ch);
        }

        private static boolean isGenDelims(char ch) {
            return ch == ':' || ch == '/' || ch == '?' || ch == '#' || ch == '[' || ch == ']' || ch == '@';
        }

        private static boolean isSubDelims(char ch) {
            return ch == '!' || ch == '$' || ch == '&' || ch == '\'' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == ',' || ch == ';' || ch == '=';
        }

        private static boolean isIprivate(int cp) {
            return 57344 <= cp && cp <= 63743 || 983040 <= cp && cp <= 1048573 || 0x100000 <= cp && cp <= 1114109;
        }

        private static boolean isUcschar(int cp) {
            return 160 <= cp && cp <= 55295 || 63744 <= cp && cp <= 64975 || 65008 <= cp && cp <= 65519 || 65536 <= cp && cp <= 131069 || 131072 <= cp && cp <= 196605 || 196608 <= cp && cp <= 262141 || 262144 <= cp && cp <= 327677 || 327680 <= cp && cp <= 393213 || 393216 <= cp && cp <= 458749 || 458752 <= cp && cp <= 524285 || 524288 <= cp && cp <= 589821 || 589824 <= cp && cp <= 655357 || 655360 <= cp && cp <= 720893 || 720896 <= cp && cp <= 786429 || 786432 <= cp && cp <= 851965 || 851968 <= cp && cp <= 917501 || 921600 <= cp && cp <= 983037;
        }

        public int parseLiterals(String s, int pos) {
            this.literals = new StringBuilder();
            while (pos < s.length()) {
                char ch = s.charAt(pos);
                if (ch == '!' || '#' <= ch && ch <= '$' || ch == '&' || '(' <= ch && ch <= ';' || ch == '=' || '?' <= ch && ch <= '[' || ch == ']' || ch == '_' || 'a' <= ch && ch <= 'z' || ch == '~') {
                    ++pos;
                    UriTemplateImpl.encodeChar(ch, CharSet.LITERALS, this.literals);
                    continue;
                }
                if (Character.isSurrogate(ch)) {
                    if (pos + 1 >= s.length()) {
                        throw new IllegalArgumentException();
                    }
                    int cp = s.codePointAt(pos);
                    if (!Parser.isUcschar(cp) && !Parser.isIprivate(cp)) break;
                    UriTemplateImpl.pctEncode(s.substring(pos, pos + 2), this.literals);
                    pos += 2;
                    continue;
                }
                int idx = this.parsePctEncoded(s, pos);
                if (idx == pos) break;
                this.literals.append(s, pos, idx);
                pos = idx;
            }
            return pos;
        }

        private static boolean isOperator(char ch) {
            return Parser.isOpLevel2(ch) || Parser.isOpLevel3(ch) || Parser.isOpReserve(ch);
        }

        private static boolean isOpLevel2(char ch) {
            return ch == '+' || ch == '#';
        }

        private static boolean isOpLevel3(char ch) {
            return ch == '.' || ch == '/' || ch == ';' || ch == '?' || ch == '&';
        }

        private static boolean isOpReserve(char ch) {
            return ch == '=' || ch == ',' || ch == '!' || ch == '@' || ch == '|';
        }

        public int parseVariableList(String s, int pos) {
            int idx = this.parseVarspec(s, pos);
            if (this.expression != null) {
                this.expression.value.add(this.varspec);
            }
            if (idx > pos) {
                pos = idx;
                while (pos < s.length() && s.charAt(pos) == ',' && (idx = this.parseVarspec(s, pos + 1)) > pos + 1) {
                    if (this.expression != null) {
                        this.expression.value.add(this.varspec);
                    }
                    pos = idx;
                }
            }
            return pos;
        }

        public int parseVarspec(String s, int pos) {
            this.varspec = null;
            int idx = this.parseVarname(s, pos);
            if (idx > pos) {
                String varname = s.substring(pos, idx);
                pos = this.parseModifierLevel4(s, idx);
                this.varspec = new Varspec(varname, this.sb.toString(), this.maxLength, this.exploded);
            }
            return pos;
        }

        public int parseVarname(String s, int pos) {
            this.sb = new StringBuilder();
            int idx = this.parseVarchar(s, pos);
            while (idx > pos) {
                pos = idx;
                if (pos < s.length() && s.charAt(pos) == '.') {
                    this.sb.append('.');
                    int j = this.parseVarchar(s, pos + 1);
                    if (j <= pos + 1) continue;
                    idx = j;
                    continue;
                }
                idx = this.parseVarchar(s, pos);
            }
            return idx;
        }

        private int parseVarchar(String s, int pos) {
            if (pos < s.length()) {
                char ch = s.charAt(pos);
                if (Parser.isALPHA(ch) || Parser.isDIGIT(ch) || ch == '_') {
                    this.sb.append(ch);
                    ++pos;
                } else {
                    int idx = this.parsePctEncoded(s, pos);
                    if (idx > pos) {
                        this.sb.append(this.pctEncoded);
                        pos = idx;
                    }
                }
            }
            return pos;
        }

        public int parseModifierLevel4(String s, int pos) {
            this.exploded = false;
            this.maxLength = -1;
            int idx = this.parsePrefixModifier(s, pos);
            if (idx > pos) {
                pos = idx;
            } else if (pos < s.length() && Parser.isExplode(s.charAt(pos))) {
                this.exploded = true;
                ++pos;
            }
            return pos;
        }

        public int parsePrefixModifier(String s, int pos) {
            int idx;
            if (pos < s.length() && s.charAt(pos) == ':' && (idx = this.parseMaxLength(s, pos + 1)) > pos + 1) {
                pos = idx;
            }
            return pos;
        }

        public int parseMaxLength(String s, int pos) {
            char ch;
            if (pos < s.length() && '1' <= (ch = s.charAt(pos)) && ch <= '9') {
                ++pos;
                this.maxLength = ch - 48;
                for (int i = 0; i < 3; ++i) {
                    if (this.parseDIGIT(s, pos) <= pos) continue;
                    this.maxLength = this.maxLength * 10 + this.digit;
                    ++pos;
                }
            }
            return pos;
        }

        private static boolean isExplode(char ch) {
            return ch == '*';
        }
    }

    public static final class Varspec {
        public final String varname;
        public final String decoded;
        public final int maxLength;
        public final boolean exploded;

        private Varspec(String varname, String decoded, int maxLength, boolean exploded) {
            this.varname = varname;
            this.decoded = decoded;
            this.maxLength = maxLength;
            this.exploded = exploded;
        }
    }

    public static final class Expression
    extends Term {
        private final Operator operator;
        private final List<Varspec> value = new ArrayList<Varspec>();

        public Expression(Operator operator) {
            this.operator = operator;
        }
    }

    public static final class Literals
    extends Term {
        private final String value;

        private Literals(String value) {
            this.value = value;
        }
    }

    public static enum Operator {
        SIMPLE_STRING_EXPANSION(new SimpleStringExpansion()),
        RESERVED_EXPANSION(new ReservedExpansion()),
        LABEL_EXPANSION_WITH_DOT_PREFIX(new LabelExpansionWithDotPrefix()),
        PATH_SEGMENT_EXPANSION(new PathSegmentExpansion()),
        PATH_STYLE_PARAMETER_EXPANSION(new PathStyleParameterExpansion()),
        FORM_STYLE_QUERY_EXPANSION(new FormStyleQueryExpansion()),
        FORM_STYLE_QUERY_CONTINUATION(new FormStyleQueryContinuation()),
        FRAGMENT_EXPANSION(new FragmentExpansion()),
        FUTURE(new Future());

        private final SOperator so;

        private Operator(SOperator s) {
            this.so = s;
        }

        void expand(List<Varspec> variableList, Variables variables, boolean allowVariableMiss, StringBuilder sb) {
            ArrayList<String> l = new ArrayList<String>();
            for (Varspec variable : variableList) {
                List<String> values;
                Object o = variables.get(variable.varname);
                if (o == null) {
                    if (allowVariableMiss) continue;
                    throw new NoSuchElementException("Variable " + variable.varname + " is missing");
                }
                if (o instanceof String) {
                    String s = (String)o;
                    if (variable.maxLength > 0 && variable.maxLength < s.length()) {
                        s = s.substring(0, variable.maxLength);
                    }
                    values = Collections.singletonList(this.format(variable, s));
                } else if (o instanceof List) {
                    if (variable.maxLength > 0) {
                        throw new IllegalArgumentException();
                    }
                    List list = (List)o;
                    if (list.isEmpty()) continue;
                    values = this.format(variable, list);
                } else if (o instanceof Map) {
                    if (variable.maxLength > 0) {
                        throw new IllegalArgumentException();
                    }
                    Map map = (Map)o;
                    if (map.isEmpty()) continue;
                    values = this.format(variable, map);
                } else {
                    throw new UnsupportedOperationException();
                }
                l.addAll(values);
            }
            if (l.size() > 0) {
                sb.append(this.format(l));
            }
        }

        String format(Varspec variable, String value) {
            return this.so.join(false, this.so.encodeName(variable.decoded), this.so.encodeValue(value));
        }

        List<String> format(Varspec variable, List<String> value) {
            if (variable.exploded) {
                return value.stream().map(v -> this.format(variable, (String)v)).collect(Collectors.toList());
            }
            return Collections.singletonList(this.so.join(false, this.so.encodeName(variable.decoded), value.stream().map(this.so::encodeValue).collect(Collectors.joining(","))));
        }

        List<String> format(Varspec variable, Map<String, String> value) {
            if (variable.exploded) {
                return value.entrySet().stream().map(entry -> this.so.join(true, this.so.encodeName((String)entry.getKey()), this.so.encodeValue((String)entry.getValue()))).collect(Collectors.toList());
            }
            return Collections.singletonList(this.so.join(false, this.so.encodeName(variable.varname), value.entrySet().stream().flatMap(entry -> Stream.of(this.so.encodeValue((String)entry.getKey()), this.so.encodeValue((String)entry.getValue()))).collect(Collectors.joining(","))));
        }

        String format(List<String> l) {
            return l.stream().collect(Collectors.joining(this.so.delimiter, this.so.prefix, ""));
        }
    }

    private static class Future
    extends SOperator {
        public Future() {
            super(CharSet.UNRESERVED, "", "", '=', ',', '!', '@', '|');
        }
    }

    private static class FormStyleQueryContinuation
    extends Cat2 {
        public FormStyleQueryContinuation() {
            super(CharSet.UNRESERVED, "&", "&", '&');
        }
    }

    private static class FormStyleQueryExpansion
    extends Cat2 {
        public FormStyleQueryExpansion() {
            super(CharSet.UNRESERVED, "?", "&", '?');
        }
    }

    private static class PathStyleParameterExpansion
    extends Cat2 {
        public PathStyleParameterExpansion() {
            super(CharSet.UNRESERVED, ";", ";", ';');
        }

        @Override
        String join(boolean entry, String name, String value) {
            if (!entry && value.isEmpty()) {
                return name;
            }
            return super.join(entry, name, value);
        }
    }

    private static class PathSegmentExpansion
    extends Cat1 {
        public PathSegmentExpansion() {
            super(CharSet.UNRESERVED, "/", "/", '/');
        }
    }

    private static class LabelExpansionWithDotPrefix
    extends Cat1 {
        public LabelExpansionWithDotPrefix() {
            super(CharSet.UNRESERVED, ".", ".", '.');
        }
    }

    private static class FragmentExpansion
    extends Cat1 {
        public FragmentExpansion() {
            super(cp -> Parser.isReserved(cp) || Parser.isUnreserved(cp), "#", ",", '#');
        }

        @Override
        String encodeValue(String s) {
            return super.encode(s, true);
        }
    }

    private static class ReservedExpansion
    extends Cat1 {
        public ReservedExpansion() {
            super(cp -> Parser.isReserved(cp) || Parser.isUnreserved(cp), "", ",", '+');
        }

        @Override
        String encodeValue(String s) {
            return super.encode(s, true);
        }
    }

    private static class SimpleStringExpansion
    extends Cat1 {
        public SimpleStringExpansion() {
            super(CharSet.UNRESERVED, "", ",", new char[0]);
        }
    }

    private static class Cat2
    extends SOperator {
        public Cat2(CharSet allowedSet, String prefix, String delimiter, char ... chars) {
            super(allowedSet, prefix, delimiter, chars);
        }

        @Override
        String join(boolean entry, String name, String value) {
            return name + "=" + value;
        }
    }

    private static class Cat1
    extends SOperator {
        public Cat1(CharSet allowedSet, String prefix, String delimiter, char ... chars) {
            super(allowedSet, prefix, delimiter, chars);
        }

        @Override
        String join(boolean entry, String name, String value) {
            return entry ? name + "=" + value : value;
        }
    }

    public static abstract class SOperator {
        private final CharSet allowedSet;
        private final String prefix;
        private final String delimiter;
        final char[] chars;

        SOperator(CharSet allowedSet, String prefix, String delimiter, char ... chars) {
            this.allowedSet = allowedSet;
            this.prefix = prefix;
            this.delimiter = delimiter;
            this.chars = chars;
        }

        String join(boolean entry, String name, String value) {
            throw new UnsupportedOperationException();
        }

        String encodeName(String s) {
            return this.encode(s, false);
        }

        String encodeValue(String s) {
            return this.encode(s, false);
        }

        String encode(String s, boolean allowPctEncoded) {
            StringBuilder sb = new StringBuilder();
            UriTemplateImpl.encodeString(s, this.allowedSet, allowPctEncoded, sb);
            return sb.toString();
        }
    }

    public static abstract class Term {
    }

    static interface CharSet {
        public static final CharSet UNRESERVED = x$0 -> Parser.access$000(x$0);
        public static final CharSet LITERALS = ch -> Parser.isUnreserved(ch) || Parser.isReserved(ch);

        public boolean contains(char var1);
    }
}

