/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApiClient {
    private WebClient client;
    private int port;
    private String host;
    private MultiMap cookieParams;

    ApiClient(Vertx vertx, String host, int port) {
        this.client = WebClient.create((Vertx)vertx, (WebClientOptions)new WebClientOptions().setDefaultHost(host).setDefaultPort(port));
        this.port = port;
        this.host = host;
        this.cookieParams = MultiMap.caseInsensitiveMultiMap();
    }

    ApiClient(WebClient client) {
        this.client = client;
        this.cookieParams = MultiMap.caseInsensitiveMultiMap();
    }

    public void pathMatrixNoexplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/matrix/noexplode/string/{;color}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathMatrix("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathMatrixNoexplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/matrix/noexplode/array/{;color}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathArrayMatrix("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathMatrixNoexplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/matrix/noexplode/object/{;color}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathObjectMatrix("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathMatrixExplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/matrix/explode/string/{;color*}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathMatrix("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathMatrixExplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/matrix/explode/array/{;color*}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathArrayMatrixExplode("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathMatrixExplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/matrix/explode/object/{;color*}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathObjectMatrixExplode("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathLabelNoexplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/label/noexplode/string/{.color}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathLabel("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathLabelNoexplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/label/noexplode/array/{.color}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathArrayLabel("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathLabelNoexplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/label/noexplode/object/{.color}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathObjectLabel("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathLabelExplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/label/explode/string/{.color*}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathLabel("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathLabelExplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/label/explode/array/{.color*}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathArrayLabelExplode("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathLabelExplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/label/explode/object/{.color*}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathObjectLabelExplode("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathSimpleNoexplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/simple/noexplode/string/{color}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathParam("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathSimpleNoexplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/simple/noexplode/array/{color}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathArraySimple("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathSimpleNoexplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/simple/noexplode/object/{color}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathObjectSimple("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathSimpleExplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/simple/explode/string/{color*}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathParam("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathSimpleExplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/simple/explode/array/{color*}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathArraySimpleExplode("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathSimpleExplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color in path");
        }
        String uri = "/path/simple/explode/object/{color*}";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color}", this.renderPathObjectSimpleExplode("color", color));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathMultiSimpleLabel(String colorSimple, List<Object> colorLabel, Handler<AsyncResult<HttpResponse>> handler) {
        if (colorSimple == null) {
            throw new RuntimeException("Missing parameter colorSimple in path");
        }
        if (colorLabel == null) {
            throw new RuntimeException("Missing parameter colorLabel in path");
        }
        String uri = "/path/multi/{color_simple}{.color_label}/test";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color_simple}", this.renderPathParam("color_simple", colorSimple));
        uri = uri.replace("{color_label}", this.renderPathArrayLabel("color_label", colorLabel));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathMultiSimpleMatrix(String colorSimple, List<Object> colorMatrix, Handler<AsyncResult<HttpResponse>> handler) {
        if (colorSimple == null) {
            throw new RuntimeException("Missing parameter colorSimple in path");
        }
        if (colorMatrix == null) {
            throw new RuntimeException("Missing parameter colorMatrix in path");
        }
        String uri = "/path/multi/{color_simple}{;color_matrix}/test";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color_simple}", this.renderPathParam("color_simple", colorSimple));
        uri = uri.replace("{color_matrix}", this.renderPathArrayMatrix("color_matrix", colorMatrix));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void pathMultiLabelMatrix(List<Object> colorLabel, Map<String, Object> colorMatrix, Handler<AsyncResult<HttpResponse>> handler) {
        if (colorLabel == null) {
            throw new RuntimeException("Missing parameter colorLabel in path");
        }
        if (colorMatrix == null) {
            throw new RuntimeException("Missing parameter colorMatrix in path");
        }
        String uri = "/path/multi/{.color_label}{;color_matrix*}/test";
        uri = uri.replaceAll("\\{{1}([.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*)\\}{1}", "{$2}");
        uri = uri.replace("{color_label}", this.renderPathArrayLabel("color_label", colorLabel));
        uri = uri.replace("{color_matrix}", this.renderPathObjectMatrixExplode("color_matrix", colorMatrix));
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryFormNoexplodeEmpty(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/form/noexplode/empty";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryParam("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryFormNoexplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/form/noexplode/string";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryParam("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryFormNoexplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/form/noexplode/array";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryArrayForm("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryFormNoexplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/form/noexplode/object";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryObjectForm("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryFormExplodeEmpty(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/form/explode/empty";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryParam("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryFormExplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/form/explode/string";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryParam("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryFormExplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/form/explode/array";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryArrayFormExplode("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryFormExplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/form/explode/object";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryObjectFormExplode("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void querySpaceDelimitedNoexplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/spaceDelimited/noexplode/array";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryArraySpaceDelimited("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void querySpaceDelimitedNoexplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/spaceDelimited/noexplode/object";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryObjectSpaceDelimited("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryPipeDelimitedNoexplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/pipeDelimited/noexplode/array";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryArrayPipeDelimited("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryPipeDelimitedNoexplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/pipeDelimited/noexplode/object";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryObjectPipeDelimited("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void queryDeepObjectExplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/query/deepObject/explode/object";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addQueryObjectDeepObjectExplode("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void cookieFormNoexplodeEmpty(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/cookie/form/noexplode/empty";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.renderCookieParam("color", color, requestCookies);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void cookieFormNoexplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/cookie/form/noexplode/string";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.renderCookieParam("color", color, requestCookies);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void cookieFormNoexplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/cookie/form/noexplode/array";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.renderCookieArrayForm("color", color, requestCookies);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void cookieFormNoexplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/cookie/form/noexplode/object";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.renderCookieObjectForm("color", color, requestCookies);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void cookieFormExplodeEmpty(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/cookie/form/explode/empty";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.renderCookieParam("color", color, requestCookies);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void cookieFormExplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/cookie/form/explode/string";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.renderCookieParam("color", color, requestCookies);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void cookieFormExplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/cookie/form/explode/array";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.renderCookieArrayFormExplode("color", color, requestCookies);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void cookieFormExplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/cookie/form/explode/object";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.renderCookieObjectFormExplode("color", color, requestCookies);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void headerSimpleNoexplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/header/simple/noexplode/string";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addHeaderParam("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void headerSimpleNoexplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/header/simple/noexplode/array";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addHeaderArraySimple("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void headerSimpleNoexplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/header/simple/noexplode/object";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addHeaderObjectSimple("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void headerSimpleExplodeString(String color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/header/simple/explode/string";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addHeaderParam("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void headerSimpleExplodeArray(List<Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/header/simple/explode/array";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addHeaderArraySimpleExplode("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void headerSimpleExplodeObject(Map<String, Object> color, Handler<AsyncResult<HttpResponse>> handler) {
        if (color == null) {
            throw new RuntimeException("Missing parameter color");
        }
        String uri = "/header/simple/explode/object";
        HttpRequest request = this.client.get(uri);
        MultiMap requestCookies = MultiMap.caseInsensitiveMultiMap();
        if (color != null) {
            this.addHeaderObjectSimpleExplode("color", color, request);
        }
        this.renderAndAttachCookieHeader(request, requestCookies);
        request.send(handler);
    }

    public void removeCookie(String paramName) {
        this.cookieParams.remove(paramName);
    }

    private void addQueryParam(String paramName, Object value, HttpRequest request) {
        request.addQueryParam(paramName, String.valueOf(value));
    }

    public void addCookieParam(String paramName, Object value) {
        this.renderCookieParam(paramName, value, this.cookieParams);
    }

    private void addHeaderParam(String headerName, Object value, HttpRequest request) {
        request.putHeader(headerName, String.valueOf(value));
    }

    private String renderPathParam(String paramName, Object value) {
        return String.valueOf(value);
    }

    private void renderCookieParam(String paramName, Object value, MultiMap map) {
        map.remove(paramName);
        map.add(paramName, String.valueOf(value));
    }

    private String renderPathMatrix(String paramName, Object value) {
        return ";" + paramName + "=" + String.valueOf(value);
    }

    private String renderPathArrayMatrix(String paramName, List<Object> values) {
        String serialized = String.join((CharSequence)",", values.stream().map(object -> this.encode(String.valueOf(object))).collect(Collectors.toList()));
        return ";" + paramName + "=" + serialized;
    }

    private String renderPathObjectMatrix(String paramName, Map<String, Object> values) {
        ArrayList<String> listToSerialize = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            listToSerialize.add(entry.getKey());
            listToSerialize.add(this.encode(String.valueOf(entry.getValue())));
        }
        String serialized = String.join((CharSequence)",", listToSerialize);
        return ";" + paramName + "=" + serialized;
    }

    private String renderPathArrayMatrixExplode(String paramName, List<Object> values) {
        return String.join((CharSequence)"", values.stream().map(object -> ";" + paramName + "=" + this.encode(String.valueOf(object))).collect(Collectors.toList()));
    }

    private String renderPathObjectMatrixExplode(String paramName, Map<String, Object> values) {
        return String.join((CharSequence)"", values.entrySet().stream().map(entry -> ";" + (String)entry.getKey() + "=" + this.encode(String.valueOf(entry.getValue()))).collect(Collectors.toList()));
    }

    private String renderPathLabel(String paramName, Object value) {
        return "." + String.valueOf(value);
    }

    private String renderPathArrayLabel(String paramName, List<Object> values) {
        return "." + String.join((CharSequence)".", values.stream().map(object -> this.encode(String.valueOf(object))).collect(Collectors.toList()));
    }

    private String renderPathObjectLabel(String paramName, Map<String, Object> values) {
        ArrayList<String> listToSerialize = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            listToSerialize.add(entry.getKey());
            listToSerialize.add(this.encode(String.valueOf(entry.getValue())));
        }
        return "." + String.join((CharSequence)".", listToSerialize);
    }

    private String renderPathArrayLabelExplode(String paramName, List<Object> values) {
        return this.renderPathArrayLabel(paramName, values);
    }

    private String renderPathObjectLabelExplode(String paramName, Map<String, Object> values) {
        String result = "";
        for (Map.Entry<String, Object> value : values.entrySet()) {
            result = result.concat("." + value.getKey() + "=" + this.encode(String.valueOf(value.getValue())));
        }
        return result;
    }

    private String renderPathArraySimple(String paramName, List<Object> values) {
        return String.join((CharSequence)",", values.stream().map(object -> this.encode(String.valueOf(object))).collect(Collectors.toList()));
    }

    private String renderPathObjectSimple(String paramName, Map<String, Object> values) {
        ArrayList<String> listToSerialize = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            listToSerialize.add(entry.getKey());
            listToSerialize.add(this.encode(String.valueOf(entry.getValue())));
        }
        return String.join((CharSequence)",", listToSerialize);
    }

    private String renderPathArraySimpleExplode(String paramName, List<Object> values) {
        return this.renderPathArraySimple(paramName, values);
    }

    private String renderPathObjectSimpleExplode(String paramName, Map<String, Object> values) {
        return String.join((CharSequence)",", values.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + this.encode(String.valueOf(entry.getValue()))).collect(Collectors.toList()));
    }

    private void addQueryArrayForm(String paramName, List<Object> values, HttpRequest request) {
        String serialized = String.join((CharSequence)",", values.stream().map(String::valueOf).collect(Collectors.toList()));
        this.addQueryParam(paramName, serialized, request);
    }

    private void addQueryObjectForm(String paramName, Map<String, Object> values, HttpRequest request) {
        ArrayList<String> listToSerialize = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            listToSerialize.add(entry.getKey());
            listToSerialize.add(String.valueOf(entry.getValue()));
        }
        String serialized = String.join((CharSequence)",", listToSerialize);
        this.addQueryParam(paramName, serialized, request);
    }

    private void renderCookieArrayForm(String paramName, List<Object> values, MultiMap map) {
        String value = String.join((CharSequence)",", values.stream().map(String::valueOf).collect(Collectors.toList()));
        map.remove(paramName);
        map.add(paramName, value);
    }

    public void addCookieArrayForm(String paramName, List<Object> values) {
        this.renderCookieArrayForm(paramName, values, this.cookieParams);
    }

    private void renderCookieObjectForm(String paramName, Map<String, Object> values, MultiMap map) {
        ArrayList<String> listToSerialize = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            listToSerialize.add(entry.getKey());
            listToSerialize.add(String.valueOf(entry.getValue()));
        }
        String value = String.join((CharSequence)",", listToSerialize);
        map.remove(paramName);
        map.add(paramName, value);
    }

    public void addCookieObjectForm(String paramName, Map<String, Object> values) {
        this.renderCookieObjectForm(paramName, values, this.cookieParams);
    }

    private void addQueryArrayFormExplode(String paramName, List<Object> values, HttpRequest request) {
        for (Object value : values) {
            this.addQueryParam(paramName, String.valueOf(value), request);
        }
    }

    private void addQueryObjectFormExplode(String paramName, Map<String, Object> values, HttpRequest request) {
        for (Map.Entry<String, Object> value : values.entrySet()) {
            this.addQueryParam(value.getKey(), String.valueOf(value.getValue()), request);
        }
    }

    private void renderCookieArrayFormExplode(String paramName, List<Object> values, MultiMap map) {
        map.remove(paramName);
        for (Object value : values) {
            map.add(paramName, String.valueOf(value));
        }
    }

    public void addCookieArrayFormExplode(String paramName, List<Object> values) {
        this.renderCookieArrayFormExplode(paramName, values, this.cookieParams);
    }

    private void renderCookieObjectFormExplode(String paramName, Map<String, Object> values, MultiMap map) {
        for (Map.Entry<String, Object> value : values.entrySet()) {
            map.remove(value.getKey());
            map.add(value.getKey(), String.valueOf(value.getValue()));
        }
    }

    public void addCookieObjectFormExplode(String paramName, Map<String, Object> values) {
        this.renderCookieObjectFormExplode(paramName, values, this.cookieParams);
    }

    private void addHeaderArraySimple(String headerName, List<Object> values, HttpRequest request) {
        String serialized = String.join((CharSequence)",", values.stream().map(String::valueOf).collect(Collectors.toList()));
        this.addHeaderParam(headerName, serialized, request);
    }

    private void addHeaderObjectSimple(String headerName, Map<String, Object> values, HttpRequest request) {
        ArrayList<String> listToSerialize = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            listToSerialize.add(entry.getKey());
            listToSerialize.add(String.valueOf(entry.getValue()));
        }
        String serialized = String.join((CharSequence)",", listToSerialize);
        this.addHeaderParam(headerName, serialized, request);
    }

    private void addHeaderArraySimpleExplode(String headerName, List<Object> values, HttpRequest request) {
        this.addHeaderArraySimple(headerName, values, request);
    }

    private void addHeaderObjectSimpleExplode(String headerName, Map<String, Object> values, HttpRequest request) {
        ArrayList<String> listToSerialize = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            listToSerialize.add(entry.getKey() + "=" + String.valueOf(entry.getValue()));
        }
        String serialized = String.join((CharSequence)",", listToSerialize);
        this.addHeaderParam(headerName, serialized, request);
    }

    private void addQueryArraySpaceDelimited(String paramName, List<Object> values, HttpRequest request) {
        String serialized = String.join((CharSequence)" ", values.stream().map(String::valueOf).collect(Collectors.toList()));
        this.addQueryParam(paramName, serialized, request);
    }

    private void addQueryObjectSpaceDelimited(String paramName, Map<String, Object> values, HttpRequest request) {
        ArrayList<String> listToSerialize = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            listToSerialize.add(entry.getKey());
            listToSerialize.add(String.valueOf(entry.getValue()));
        }
        String serialized = String.join((CharSequence)" ", listToSerialize);
        this.addQueryParam(paramName, serialized, request);
    }

    private void addQueryArrayPipeDelimited(String paramName, List<Object> values, HttpRequest request) {
        String serialized = String.join((CharSequence)"|", values.stream().map(String::valueOf).collect(Collectors.toList()));
        this.addQueryParam(paramName, serialized, request);
    }

    private void addQueryObjectPipeDelimited(String paramName, Map<String, Object> values, HttpRequest request) {
        ArrayList<String> listToSerialize = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            listToSerialize.add(entry.getKey());
            listToSerialize.add(String.valueOf(entry.getValue()));
        }
        String serialized = String.join((CharSequence)"|", listToSerialize);
        this.addQueryParam(paramName, serialized, request);
    }

    private void addQueryObjectDeepObjectExplode(String paramName, Map<String, Object> values, HttpRequest request) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.addQueryParam(paramName + "[" + entry.getKey() + "]", String.valueOf(entry.getValue()), request);
        }
    }

    private void renderAndAttachCookieHeader(HttpRequest request, MultiMap otherCookies) {
        if ((otherCookies == null || otherCookies.isEmpty()) && this.cookieParams.isEmpty()) {
            return;
        }
        ArrayList<String> listToSerialize = new ArrayList<String>();
        for (Map.Entry e : this.cookieParams.entries()) {
            if (otherCookies == null || otherCookies.contains((String)e.getKey())) continue;
            try {
                listToSerialize.add(URLEncoder.encode((String)e.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)e.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (otherCookies != null) {
            for (Map.Entry e : otherCookies.entries()) {
                try {
                    listToSerialize.add(URLEncoder.encode((String)e.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)e.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        request.putHeader("Cookie", String.join((CharSequence)"; ", listToSerialize));
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public void close() {
        this.client.close();
    }
}

