/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.RequestParameters;
import io.vertx.ext.web.api.contract.RouterFactoryOptions;
import io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.WebTestValidationBase;
import io.vertx.ext.web.handler.StaticHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import org.junit.Ignore;
import org.junit.Test;

public class OpenAPI3SchemasTest
extends WebTestValidationBase {
    final String OAS_PATH = "./src/test/resources/swaggers/schemas_test_spec.yaml";
    OpenAPI3RouterFactory routerFactory;
    HttpServer schemaServer;
    final Handler<RoutingContext> handler = routingContext -> {
        RequestParameter body = ((RequestParameters)routingContext.get("parsedParameters")).body();
        if (body.isJsonObject()) {
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("Content-Type", "application/json").end(body.getJsonObject().encode());
        } else {
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("Content-Type", "application/json").end(body.getJsonArray().encode());
        }
    };
    final Handler<RoutingContext> FAILURE_HANDLER = routingContext -> {
        if (routingContext.failure() instanceof ValidationException) {
            routingContext.response().setStatusCode(400).setStatusMessage("ValidationException").end();
        } else {
            routingContext.response().setStatusCode(500).setStatusMessage("Error").end();
        }
    };

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.stopServer();
        this.startSchemaServer();
        CountDownLatch latch = new CountDownLatch(1);
        OpenAPI3RouterFactory.create((Vertx)this.vertx, (String)"./src/test/resources/swaggers/schemas_test_spec.yaml", openAPI3RouterFactoryAsyncResult -> {
            this.assertTrue(openAPI3RouterFactoryAsyncResult.succeeded());
            this.assertNull(openAPI3RouterFactoryAsyncResult.cause());
            this.routerFactory = (OpenAPI3RouterFactory)openAPI3RouterFactoryAsyncResult.result();
            this.routerFactory.setOptions(new RouterFactoryOptions().setRequireSecurityHandlers(false).setMountValidationFailureHandler(true).setMountNotImplementedHandler(false));
            this.routerFactory.setValidationFailureHandler(this.FAILURE_HANDLER);
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setDefaultPort(8080));
    }

    @Override
    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        this.stopSchemaServer();
        this.stopServer();
        super.tearDown();
    }

    private void startServer() throws Exception {
        this.router = this.routerFactory.getRouter();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost"));
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(arg_0 -> ((Router)this.router).accept(arg_0)).listen(this.onSuccess(res -> latch.countDown()));
        this.awaitLatch(latch);
    }

    private void stopServer() throws Exception {
        if (this.server != null) {
            CountDownLatch latch = new CountDownLatch(1);
            try {
                this.server.close(asyncResult -> latch.countDown());
            }
            catch (IllegalStateException e) {
                latch.countDown();
            }
            this.awaitLatch(latch);
        }
    }

    private void startSchemaServer() throws Exception {
        Router r = Router.router((Vertx)this.vertx);
        r.route().handler((Handler)StaticHandler.create((String)"./src/test/resources/swaggers/schemas"));
        CountDownLatch latch = new CountDownLatch(1);
        this.schemaServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(8081)).requestHandler(arg_0 -> ((Router)r).accept(arg_0)).listen(this.onSuccess(res -> latch.countDown()));
        this.awaitLatch(latch);
    }

    private void stopSchemaServer() throws Exception {
        if (this.schemaServer != null) {
            CountDownLatch latch = new CountDownLatch(1);
            try {
                this.schemaServer.close(asyncResult -> latch.countDown());
            }
            catch (IllegalStateException e) {
                latch.countDown();
            }
            this.awaitLatch(latch);
        }
    }

    private void assertRequestOk(String uri, String jsonName) throws Exception {
        String jsonString = String.join((CharSequence)"", Files.readAllLines(Paths.get("./src/test/resources/swaggers/test_json", "schemas_test", jsonName), StandardCharsets.UTF_8));
        if ((jsonString = jsonString.trim()).startsWith("[")) {
            JsonArray array = new JsonArray(jsonString);
            this.testRequestWithJSON(HttpMethod.POST, uri, array.toBuffer(), 200, "OK", array.toBuffer());
        } else {
            JsonObject obj = new JsonObject(jsonString);
            this.testRequestWithJSON(HttpMethod.POST, uri, obj.toBuffer(), 200, "OK", obj.toBuffer());
        }
    }

    private void assertRequestOk(String uri, String jsonNameRequest, String jsonNameResponse) throws Exception {
        String jsonStringRequest = String.join((CharSequence)"", Files.readAllLines(Paths.get("./src/test/resources/swaggers/test_json", "schemas_test", jsonNameRequest), StandardCharsets.UTF_8));
        JsonObject objRequest = new JsonObject(jsonStringRequest);
        String jsonStringResponse = String.join((CharSequence)"", Files.readAllLines(Paths.get("./src/test/resources/swaggers/test_json", "schemas_test", jsonNameResponse), StandardCharsets.UTF_8));
        JsonObject objResponse = new JsonObject(jsonStringResponse);
        this.testRequestWithJSON(HttpMethod.POST, uri, objRequest.toBuffer(), 200, "OK", objResponse.toBuffer());
    }

    private void assertRequestFail(String uri, String jsonName) throws Exception {
        String jsonString = String.join((CharSequence)"", Files.readAllLines(Paths.get("./src/test/resources/swaggers/test_json", "schemas_test", jsonName), StandardCharsets.UTF_8));
        if ((jsonString = jsonString.trim()).startsWith("[")) {
            this.testRequestWithJSON(HttpMethod.POST, uri, new JsonArray(jsonString).toBuffer(), 400, "ValidationException");
        } else {
            this.testRequestWithJSON(HttpMethod.POST, uri, new JsonObject(jsonString).toBuffer(), 400, "ValidationException");
        }
    }

    @Test
    public void test1() throws Exception {
        this.routerFactory.addHandlerByOperationId("test1", this.handler);
        this.startServer();
        this.assertRequestOk("/test1", "test1_ok.json");
        this.assertRequestFail("/test1", "test1_fail_1.json");
        this.assertRequestFail("/test1", "test1_fail_2.json");
    }

    @Test
    public void test2() throws Exception {
        this.routerFactory.addHandlerByOperationId("test2", this.handler);
        this.startServer();
        this.assertRequestOk("/test2", "test2_ok.json");
        this.assertRequestFail("/test2", "test2_fail_1.json");
        this.assertRequestFail("/test2", "test2_fail_2.json");
        this.assertRequestFail("/test2", "test2_fail_3.json");
    }

    @Test
    public void test3() throws Exception {
        this.routerFactory.addHandlerByOperationId("test3", this.handler);
        this.startServer();
        this.assertRequestOk("/test3", "test2_ok.json");
        this.assertRequestFail("/test3", "test2_fail_1.json");
        this.assertRequestFail("/test3", "test2_fail_2.json");
        this.assertRequestFail("/test3", "test2_fail_3.json");
    }

    @Test
    @Ignore
    public void test4() throws Exception {
        this.routerFactory.addHandlerByOperationId("test4", this.handler);
        this.startServer();
        this.assertRequestOk("/test4", "test2_ok.json");
        this.assertRequestFail("/test4", "test2_fail_1.json");
        this.assertRequestFail("/test4", "test2_fail_2.json");
        this.assertRequestFail("/test4", "test2_fail_3.json");
    }

    @Test
    public void test5() throws Exception {
        this.routerFactory.addHandlerByOperationId("test5", this.handler);
        this.startServer();
        this.assertRequestOk("/test5", "test5_ok_1.json");
        this.assertRequestOk("/test5", "test5_ok_2.json");
        this.assertRequestFail("/test5", "test5_fail.json");
    }

    @Test
    public void test6() throws Exception {
        this.routerFactory.addHandlerByOperationId("test6", this.handler);
        this.startServer();
        this.assertRequestOk("/test6", "test6_ok.json");
        this.assertRequestFail("/test6", "test6_fail.json");
    }

    @Test
    @Ignore
    public void test7() throws Exception {
        this.routerFactory.addHandlerByOperationId("test7", this.handler);
        this.startServer();
        this.assertRequestOk("/test7", "test2_ok.json");
        this.assertRequestOk("/test7", "test7_ok_1.json");
        this.assertRequestOk("/test7", "test7_ok_2.json");
        this.assertRequestFail("/test7", "test7_fail_1.json");
        this.assertRequestFail("/test7", "test7_fail_2.json");
    }

    @Test
    @Ignore
    public void test8() throws Exception {
        this.routerFactory.addHandlerByOperationId("test8", this.handler);
        this.startServer();
        this.assertRequestOk("/test8", "test8_ok.json");
        this.assertRequestFail("/test8", "test8_fail_1.json");
        this.assertRequestFail("/test8", "test8_fail_2.json");
    }

    @Test
    @Ignore
    public void test9() throws Exception {
        this.routerFactory.addHandlerByOperationId("test9", this.handler);
        this.startServer();
        this.assertRequestOk("/test9", "test6_ok.json");
        this.assertRequestOk("/test9", "test9_ok.json");
        this.assertRequestFail("/test8", "test9_fail.json");
    }

    @Test
    @Ignore
    public void test10() throws Exception {
        this.routerFactory.addHandlerByOperationId("test10", this.handler);
        this.startServer();
        this.assertRequestOk("/test10", "test10_ok.json");
        this.assertRequestFail("/test10", "test10_fail.json");
    }

    @Test
    @Ignore
    public void test11() throws Exception {
        this.routerFactory.addHandlerByOperationId("test11", this.handler);
        this.startServer();
        this.assertRequestOk("/test11", "test10_ok.json");
        this.assertRequestFail("/test11", "test10_fail.json");
    }

    @Test
    @Ignore
    public void test12() throws Exception {
        this.routerFactory.addHandlerByOperationId("test12", this.handler);
        this.startServer();
        this.assertRequestOk("/test12", "test12_ok.json");
        this.assertRequestFail("/test12", "test12_fail.json");
    }

    @Test
    @Ignore
    public void test13() throws Exception {
        this.routerFactory.addHandlerByOperationId("test13", this.handler);
        this.startServer();
        this.assertRequestOk("/test13", "test13_ok_request.json", "test13_ok_response.json");
    }

    @Test
    public void test14() throws Exception {
        this.routerFactory.addHandlerByOperationId("test14", this.handler);
        this.startServer();
        this.assertRequestOk("/test14", "test14_ok.json");
        this.assertRequestFail("/test14", "test14_fail.json");
    }

    @Test
    public void test15() throws Exception {
        this.routerFactory.addHandlerByOperationId("test15", this.handler);
        this.startServer();
        this.assertRequestOk("/test15", "test15_ok_1.json");
        this.assertRequestOk("/test15", "test15_ok_2.json");
        this.assertRequestFail("/test15", "test15_fail.json");
    }

    @Test
    public void test16() throws Exception {
        this.routerFactory.addHandlerByOperationId("test16", this.handler);
        this.startServer();
        this.assertRequestOk("/test16", "test16_ok.json");
        this.assertRequestFail("/test16", "test16_fail.json");
    }
}

