/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.validation.impl.XMLTypeValidator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class XMLTypeValidatorTest {
    @Test
    public void isValidPattern() throws IOException {
        block15: {
            File tempFile = File.createTempFile("xml-", "-xxe");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                ((OutputStream)out).write("<appinfo>you should not see me!!!</appinfo>".getBytes(StandardCharsets.UTF_8));
            }
            try {
                XMLTypeValidator.XMLTypeValidatorFactory.createXMLTypeValidator((String)("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE foo [ <!ELEMENT foo ANY >\n<!ENTITY xxe SYSTEM \"file://" + tempFile.getCanonicalPath() + "\" >]>\n<creds>\n    <user>&xxe;</user>\n    <pass>mypass</pass>\n</creds>"));
            }
            catch (Throwable e) {
                SAXParseException xxe;
                if (!(e.getCause() instanceof SAXParseException) || (xxe = (SAXParseException)e.getCause()).getSystemId() == null && xxe.getMessage().contains("Failed to read external document")) break block15;
                Assert.fail((String)("XML got access to FS: " + xxe.getMessage()));
            }
        }
    }
}

