/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.BooleanTypeValidator;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class BooleanTypeValidatorTest {
    @Test
    public void isValidTrue() {
        BooleanTypeValidator validator = new BooleanTypeValidator(Boolean.valueOf(false));
        Assert.assertEquals((Object)RequestParameter.create((Object)true), (Object)validator.isValid("true"));
        Assert.assertEquals((Object)RequestParameter.create((Object)true), (Object)validator.isValid("t"));
        Assert.assertEquals((Object)RequestParameter.create((Object)true), (Object)validator.isValid("1"));
    }

    @Test
    public void isValidFalse() {
        BooleanTypeValidator validator = new BooleanTypeValidator(Boolean.valueOf(true));
        Assert.assertEquals((Object)RequestParameter.create((Object)false), (Object)validator.isValid("false"));
        Assert.assertEquals((Object)RequestParameter.create((Object)false), (Object)validator.isValid("f"));
        Assert.assertEquals((Object)RequestParameter.create((Object)false), (Object)validator.isValid("0"));
    }

    @Test(expected=ValidationException.class)
    public void isNotValid() {
        BooleanTypeValidator validator = new BooleanTypeValidator(Boolean.valueOf(false));
        validator.isValid("2");
    }

    @Test
    public void isValidDefault() {
        BooleanTypeValidator validator = new BooleanTypeValidator(Boolean.valueOf(true));
        Assert.assertEquals((Object)RequestParameter.create((Object)true), (Object)validator.isValid(null));
    }

    @Test
    public void isValidCollection() {
        BooleanTypeValidator validator = new BooleanTypeValidator(null);
        Assert.assertEquals((Object)RequestParameter.create((Object)true), (Object)validator.isValidCollection(Arrays.asList("true")));
    }

    @Test(expected=ValidationException.class)
    public void isValidCollectionFailure() {
        BooleanTypeValidator validator = new BooleanTypeValidator(null);
        validator.isValidCollection(Arrays.asList("true", "false", "true"));
    }
}

