/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ParameterType;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.ArrayTypeValidator;
import io.vertx.ext.web.api.validation.impl.BooleanTypeValidator;
import io.vertx.ext.web.api.validation.impl.EnumTypeValidator;
import io.vertx.ext.web.api.validation.impl.NumericTypeValidator;
import io.vertx.ext.web.api.validation.impl.ObjectTypeValidator;
import io.vertx.ext.web.api.validation.impl.StringTypeValidator;
import java.util.List;

@VertxGen
@FunctionalInterface
public interface ParameterTypeValidator {
    public RequestParameter isValid(String var1) throws ValidationException;

    default public RequestParameter isValidCollection(List<String> value) throws ValidationException {
        if (value.size() > 1 && !(this instanceof ArrayTypeValidator) && !(this instanceof ObjectTypeValidator)) {
            throw ValidationException.ValidationExceptionFactory.generateUnexpectedArrayValidationException();
        }
        return this.isValid(value.get(0));
    }

    default public Object getDefault() {
        return null;
    }

    default public boolean hasDefault() {
        return this.getDefault() != null;
    }

    public static ParameterTypeValidator createIntegerTypeValidator(Integer defaultValue) {
        return ParameterTypeValidator.createIntegerTypeValidator(null, null, null, defaultValue);
    }

    public static ParameterTypeValidator createIntegerTypeValidator(Double maximum, Double minimum, Double multipleOf, Integer defaultValue) {
        return ParameterTypeValidator.createIntegerTypeValidator(false, maximum, false, minimum, multipleOf, defaultValue);
    }

    public static ParameterTypeValidator createIntegerTypeValidator(Boolean exclusiveMaximum, Double maximum, Boolean exclusiveMinimum, Double minimum, Double multipleOf, Object defaultValue) {
        return new NumericTypeValidator(Integer.class, exclusiveMaximum, maximum, exclusiveMinimum, minimum, multipleOf, defaultValue);
    }

    public static ParameterTypeValidator createLongTypeValidator(Long defaultValue) {
        return ParameterTypeValidator.createLongTypeValidator(null, null, null, defaultValue);
    }

    public static ParameterTypeValidator createLongTypeValidator(Double maximum, Double minimum, Double multipleOf, Long defaultValue) {
        return ParameterTypeValidator.createLongTypeValidator(false, maximum, false, minimum, multipleOf, defaultValue);
    }

    public static ParameterTypeValidator createLongTypeValidator(Boolean exclusiveMaximum, Double maximum, Boolean exclusiveMinimum, Double minimum, Double multipleOf, Object defaultValue) {
        return new NumericTypeValidator(Long.class, exclusiveMaximum, maximum, exclusiveMinimum, minimum, multipleOf, defaultValue);
    }

    public static ParameterTypeValidator createFloatTypeValidator(Float defaultValue) {
        return ParameterTypeValidator.createFloatTypeValidator(null, null, null, defaultValue);
    }

    public static ParameterTypeValidator createFloatTypeValidator(Double maximum, Double minimum, Double multipleOf, Float defaultValue) {
        return ParameterTypeValidator.createFloatTypeValidator(false, maximum, false, minimum, multipleOf, defaultValue);
    }

    public static ParameterTypeValidator createFloatTypeValidator(Boolean exclusiveMaximum, Double maximum, Boolean exclusiveMinimum, Double minimum, Double multipleOf, Object defaultValue) {
        return new NumericTypeValidator(Float.class, exclusiveMaximum, maximum, exclusiveMinimum, minimum, multipleOf, defaultValue);
    }

    public static ParameterTypeValidator createDoubleTypeValidator(Double defaultValue) {
        return ParameterTypeValidator.createDoubleTypeValidator(null, null, null, defaultValue);
    }

    public static ParameterTypeValidator createDoubleTypeValidator(Double maximum, Double minimum, Double multipleOf, Double defaultValue) {
        return ParameterTypeValidator.createDoubleTypeValidator(false, maximum, false, minimum, multipleOf, defaultValue);
    }

    public static ParameterTypeValidator createDoubleTypeValidator(Boolean exclusiveMaximum, Double maximum, Boolean exclusiveMinimum, Double minimum, Double multipleOf, Object defaultValue) {
        return new NumericTypeValidator(Double.class, exclusiveMaximum, maximum, exclusiveMinimum, minimum, multipleOf, defaultValue);
    }

    public static ParameterTypeValidator createStringTypeValidator(Object defaultValue) {
        return ParameterTypeValidator.createStringTypeValidator(null, null, null, defaultValue);
    }

    public static ParameterTypeValidator createStringTypeValidator(String pattern, Object defaultValue) {
        return ParameterTypeValidator.createStringTypeValidator(pattern, null, null, defaultValue);
    }

    public static ParameterTypeValidator createStringTypeValidator(String pattern, Integer minLength, Integer maxLength, Object defaultValue) {
        return new StringTypeValidator(pattern, minLength, maxLength, (String)defaultValue);
    }

    public static ParameterTypeValidator createBooleanTypeValidator(Object defaultValue) {
        if (defaultValue != null) {
            if (defaultValue instanceof String) {
                return new BooleanTypeValidator(Boolean.valueOf((String)defaultValue));
            }
            return new BooleanTypeValidator((Boolean)defaultValue);
        }
        return new BooleanTypeValidator(null);
    }

    public static ParameterTypeValidator createStringEnumTypeValidator(List<String> allowedValues) {
        return new EnumTypeValidator<String>(allowedValues, ParameterType.GENERIC_STRING.validationMethod());
    }

    public static ParameterTypeValidator createEnumTypeValidatorWithInnerValidator(List<Object> allowedValues, ParameterTypeValidator innerValidator) {
        return new EnumTypeValidator<Object>(allowedValues, innerValidator);
    }

    public static ParameterTypeValidator createArrayTypeValidator(ParameterTypeValidator arrayMembersValidator) {
        return ArrayTypeValidator.ArrayTypeValidatorFactory.createArrayTypeValidator(arrayMembersValidator);
    }

    public static ParameterTypeValidator createArrayTypeValidator(ParameterTypeValidator arrayMembersValidator, String collectionFormat, Integer maxItems, Integer minItems) {
        return ArrayTypeValidator.ArrayTypeValidatorFactory.createArrayTypeValidator(arrayMembersValidator, collectionFormat, maxItems, minItems);
    }
}

