/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Schema;
import io.vertx.ext.web.api.io.swagger.v3.parser.ResolverCache;
import io.vertx.ext.web.api.io.swagger.v3.parser.extensions.JsonSchemaParserExtension;
import io.vertx.ext.web.api.io.swagger.v3.parser.models.RefFormat;
import io.vertx.ext.web.api.io.swagger.v3.parser.models.RefType;
import io.vertx.ext.web.api.io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.vertx.ext.web.api.io.swagger.v3.parser.util.OpenAPIDeserializer;
import io.vertx.ext.web.api.io.swagger.v3.parser.util.RefUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchemaProcessor {
    private final ExternalRefProcessor externalRefProcessor;
    private boolean openapi31;
    private final ResolverCache cache;
    private OpenAPI openAPI;

    public SchemaProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, false);
    }

    public SchemaProcessor(ResolverCache cache, OpenAPI openAPI, boolean openapi31) {
        this.openapi31 = openapi31;
        this.cache = cache;
        this.openAPI = openAPI;
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processSchema(Schema schema) {
        if (schema == null) {
            return;
        }
        if (this.openapi31) {
            List<JsonSchemaParserExtension> jsonschemaExtensions = OpenAPIDeserializer.getJsonSchemaParserExtensions();
            for (JsonSchemaParserExtension jsonschemaExtension : jsonschemaExtensions) {
                if (!jsonschemaExtension.resolveSchema(schema, this.cache, this.openAPI, this.openapi31)) continue;
                return;
            }
        }
        if (schema.get$ref() != null) {
            this.processReferenceSchema(schema);
        } else {
            this.processSchemaType(schema);
        }
    }

    public void processSchemaType(Schema schema) {
        if (schema instanceof ArraySchema) {
            this.processArraySchema((ArraySchema)schema);
        }
        if (schema instanceof ComposedSchema) {
            this.processComposedSchema((ComposedSchema)schema);
        }
        if (schema.getProperties() != null && schema.getProperties().size() > 0) {
            this.processPropertySchema(schema);
        }
        if (schema.getNot() != null) {
            this.processNotSchema(schema);
        }
        if (schema.getAdditionalProperties() != null) {
            this.processAdditionalProperties(schema);
        }
        if (schema.getDiscriminator() != null) {
            this.processDiscriminatorSchema(schema);
        }
    }

    private void processDiscriminatorSchema(Schema schema) {
        if (schema.getDiscriminator() != null && schema.getDiscriminator().getMapping() != null) {
            Map mapping = schema.getDiscriminator().getMapping();
            for (String ref : mapping.values()) {
                this.processReferenceSchema(new Schema().$ref(ref));
            }
        }
    }

    private void processAdditionalProperties(Object additionalProperties) {
        Schema schema;
        if (additionalProperties instanceof Schema && (schema = (Schema)additionalProperties).getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
            Schema additionalPropertiesSchema = (Schema)schema.getAdditionalProperties();
            if (additionalPropertiesSchema.get$ref() != null) {
                this.processReferenceSchema(additionalPropertiesSchema);
            } else {
                this.processSchemaType(additionalPropertiesSchema);
            }
        }
    }

    private void processNotSchema(Schema schema) {
        if (schema.getNot() != null) {
            if (schema.getNot().get$ref() != null) {
                this.processReferenceSchema(schema.getNot());
            } else {
                this.processSchemaType(schema.getNot());
            }
        }
    }

    public void processPropertySchema(Schema schema) {
        Map properties;
        if (schema.get$ref() != null) {
            this.processReferenceSchema(schema);
        }
        if ((properties = schema.getProperties()) != null) {
            for (Map.Entry propertyEntry : properties.entrySet()) {
                Schema property = (Schema)propertyEntry.getValue();
                if (property.get$ref() != null) {
                    this.processReferenceSchema(property);
                    continue;
                }
                this.processSchemaType(property);
            }
        }
    }

    public void processComposedSchema(ComposedSchema composedSchema) {
        List schemas;
        if (composedSchema.getAllOf() != null && (schemas = composedSchema.getAllOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.get$ref() != null) {
                    this.processReferenceSchema(schema);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
        if (composedSchema.getOneOf() != null && (schemas = composedSchema.getOneOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.get$ref() != null) {
                    String oldRef = schema.get$ref();
                    this.processReferenceSchema(schema);
                    String newRef = schema.get$ref();
                    this.changeDiscriminatorMapping(composedSchema, oldRef, newRef);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
        if (composedSchema.getAnyOf() != null && (schemas = composedSchema.getAnyOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.get$ref() != null) {
                    this.processReferenceSchema(schema);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
    }

    private void changeDiscriminatorMapping(ComposedSchema composedSchema, String oldRef, String newRef) {
        Discriminator discriminator = composedSchema.getDiscriminator();
        if (!oldRef.equals(newRef) && discriminator != null) {
            String oldName = RefUtils.computeDefinitionName(oldRef);
            String newName = RefUtils.computeDefinitionName(newRef);
            String mappingName = null;
            if (discriminator.getMapping() != null) {
                for (String name : discriminator.getMapping().keySet()) {
                    if (!oldRef.equals(discriminator.getMapping().get(name))) continue;
                    mappingName = name;
                    break;
                }
                if (mappingName != null) {
                    discriminator.getMapping().put(mappingName, newRef);
                }
            }
            if (mappingName == null && !oldName.equals(newName)) {
                if (discriminator.getMapping() == null) {
                    discriminator.setMapping(new HashMap());
                }
                discriminator.getMapping().put(oldName, newRef);
            }
        }
    }

    public void processArraySchema(ArraySchema arraySchema) {
        Schema items = arraySchema.getItems();
        if (items.get$ref() != null) {
            this.processReferenceSchema(items);
        } else {
            this.processSchemaType(items);
        }
    }

    private void processReferenceSchema(Schema schema) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(schema.get$ref());
        String $ref = schema.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalSchema($ref, refFormat)) != null) {
            schema.set$ref(RefType.SCHEMAS.getInternalPrefix() + newRef);
        }
    }
}

