/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.io.swagger.v3.parser.reference;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.vertx.ext.web.api.io.swagger.v3.parser.reference.DereferencerContext;
import io.vertx.ext.web.api.io.swagger.v3.parser.reference.ReferenceUtils;
import io.vertx.ext.web.api.io.swagger.v3.parser.reference.ReferenceVisitor;
import io.vertx.ext.web.api.io.swagger.v3.parser.reference.Traverser;
import io.vertx.ext.web.api.io.swagger.v3.parser.reference.Visitor;
import io.vertx.ext.web.api.io.swagger.v3.parser.util.DeserializationUtils;
import io.vertx.ext.web.api.io.swagger.v3.parser.util.OpenAPIDeserializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;

public class OpenAPI31Traverser
implements Traverser {
    private DereferencerContext context;
    public Set<Object> visiting = new HashSet<Object>();
    protected HashMap<Object, Object> visitedMap = new HashMap();
    private OpenAPIDeserializer deserializer = new OpenAPIDeserializer();

    public OpenAPI31Traverser(DereferencerContext context) {
        this.context = context;
    }

    public DereferencerContext getContext() {
        return this.context;
    }

    public void setContext(DereferencerContext context) {
        this.context = context;
    }

    public OpenAPI31Traverser context(DereferencerContext context) {
        this.context = context;
        return this;
    }

    @Override
    public OpenAPI traverse(OpenAPI openAPI, Visitor visitor) throws Exception {
        if (!(visitor instanceof ReferenceVisitor)) {
            return openAPI;
        }
        return this.traverseOpenApi(openAPI, (ReferenceVisitor)visitor);
    }

    public <T> T deserializeFragment(JsonNode node, Class<T> expectedType, String uri, String fragment, Set<String> validationMessages) {
        String sanitizedFragment = fragment == null ? "" : fragment;
        OpenAPIDeserializer.ParseResult parseResult = new OpenAPIDeserializer.ParseResult().openapi31(true);
        Schema result = null;
        if (expectedType.equals(Schema.class)) {
            result = this.deserializer.getSchema((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType.equals(RequestBody.class)) {
            result = this.deserializer.getRequestBody((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType.equals(ApiResponse.class)) {
            result = this.deserializer.getResponse((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType.equals(Callback.class)) {
            result = this.deserializer.getCallback((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType.equals(Example.class)) {
            result = this.deserializer.getExample((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType.equals(Header.class)) {
            result = this.deserializer.getHeader((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType.equals(Link.class)) {
            result = this.deserializer.getLink((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType.equals(Parameter.class)) {
            result = this.deserializer.getParameter((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType.equals(SecurityScheme.class)) {
            result = this.deserializer.getSecurityScheme((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType.equals(PathItem.class)) {
            result = this.deserializer.getPathItem((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        }
        parseResult.getMessages().forEach(m -> validationMessages.add(m + " (" + uri + ")"));
        if (result != null) {
            return (T)result;
        }
        return DeserializationUtils.deserialize(node, uri, expectedType);
    }

    public OpenAPI traverseOpenApi(OpenAPI openAPI, ReferenceVisitor visitor) {
        Components components;
        Paths paths;
        if (openAPI == null) {
            return null;
        }
        if (this.visiting.contains(openAPI)) {
            return openAPI;
        }
        if (this.visitedMap.containsKey(openAPI)) {
            return (OpenAPI)this.visitedMap.get(openAPI);
        }
        this.visiting.add(openAPI);
        OpenAPI resolved = visitor.visitOpenApi(openAPI);
        if (resolved == null) {
            resolved = openAPI;
        }
        if ((paths = this.traversePaths(resolved.getPaths(), visitor)) != null) {
            resolved.paths(paths);
        }
        if ((components = this.traverseComponents(resolved.getComponents(), visitor)) != null) {
            resolved.components(components);
        }
        this.traverseMap(resolved.getWebhooks(), visitor, this::traversePathItem);
        this.visitedMap.put(openAPI, resolved);
        this.visiting.remove(openAPI);
        return resolved;
    }

    public Components traverseComponents(Components components, ReferenceVisitor visitor) {
        if (components == null) {
            return null;
        }
        if (this.visiting.contains(components)) {
            return components;
        }
        if (this.visitedMap.containsKey(components)) {
            return (Components)this.visitedMap.get(components);
        }
        this.visiting.add(components);
        Components resolved = visitor.visitComponents(components);
        if (resolved == null) {
            resolved = components;
        }
        this.traverseMap(resolved.getPathItems(), visitor, this::traversePathItem);
        this.traverseMap(resolved.getParameters(), visitor, this::traverseParameter);
        this.traverseMap(resolved.getCallbacks(), visitor, this::traverseCallback);
        this.traverseMap(resolved.getRequestBodies(), visitor, this::traverseRequestBody);
        this.traverseMap(resolved.getSecuritySchemes(), visitor, this::traverseSecurityScheme);
        this.traverseSchemaMap(resolved.getSchemas(), visitor, new ArrayList<String>());
        this.traverseMap(resolved.getHeaders(), visitor, this::traverseHeader);
        this.traverseMap(resolved.getLinks(), visitor, this::traverseLink);
        this.traverseMap(resolved.getResponses(), visitor, this::traverseResponse);
        this.traverseMap(resolved.getExamples(), visitor, this::traverseExample);
        this.visitedMap.put(components, resolved);
        this.visiting.remove(components);
        return resolved;
    }

    public Paths traversePaths(Paths paths, ReferenceVisitor visitor) {
        if (paths == null) {
            return null;
        }
        if (this.visiting.contains(paths)) {
            return paths;
        }
        if (this.visitedMap.containsKey(paths)) {
            return (Paths)this.visitedMap.get(paths);
        }
        this.visiting.add(paths);
        Paths resolved = visitor.visitPaths(paths);
        if (resolved == null) {
            resolved = paths;
        }
        this.traverseMap((Map)resolved, visitor, (BiFunction)this::traversePathItem);
        this.visitedMap.put(paths, resolved);
        this.visiting.remove(paths);
        return resolved;
    }

    public Operation traverseOperation(Operation operation, ReferenceVisitor visitor) {
        ApiResponses resolvedResponses;
        RequestBody resolvedRequestBody;
        if (operation == null) {
            return null;
        }
        if (this.visiting.contains(operation)) {
            return operation;
        }
        if (this.visitedMap.containsKey(operation)) {
            return (Operation)this.visitedMap.get(operation);
        }
        this.visiting.add(operation);
        Operation resolved = visitor.visitOperation(operation);
        if (resolved == null) {
            resolved = operation;
        }
        if (resolved.getParameters() != null) {
            for (int i = 0; i < resolved.getParameters().size(); ++i) {
                Parameter resolvedParameter = this.traverseParameter((Parameter)resolved.getParameters().get(i), visitor);
                if (resolvedParameter == null) continue;
                resolved.getParameters().set(i, resolvedParameter);
            }
        }
        if (resolved.getRequestBody() != null && (resolvedRequestBody = this.traverseRequestBody(resolved.getRequestBody(), visitor)) != null) {
            resolved.setRequestBody(resolvedRequestBody);
        }
        if (resolved.getResponses() != null && (resolvedResponses = this.traverseResponses(resolved.getResponses(), visitor)) != null) {
            resolved.setResponses(resolvedResponses);
        }
        this.traverseMap(resolved.getCallbacks(), visitor, this::traverseCallback);
        this.visitedMap.put(operation, resolved);
        this.visiting.remove(operation);
        return resolved;
    }

    public ApiResponses traverseResponses(ApiResponses responses, ReferenceVisitor visitor) {
        if (responses == null) {
            return null;
        }
        if (this.visiting.contains(responses)) {
            return responses;
        }
        if (this.visitedMap.containsKey(responses)) {
            return (ApiResponses)this.visitedMap.get(responses);
        }
        this.visiting.add(responses);
        ApiResponses resolved = visitor.visitResponses(responses);
        if (resolved == null) {
            resolved = responses;
        }
        this.traverseMap((Map)resolved, visitor, (BiFunction)this::traverseResponse);
        this.visitedMap.put(responses, resolved);
        this.visiting.remove(responses);
        return resolved;
    }

    public ApiResponse traverseResponse(ApiResponse response, ReferenceVisitor visitor) {
        if (response == null) {
            return null;
        }
        if (this.visiting.contains(response)) {
            return response;
        }
        if (this.visitedMap.containsKey(response)) {
            return (ApiResponse)this.visitedMap.get(response);
        }
        this.visiting.add(response);
        ApiResponse resolved = visitor.visitResponse(response);
        boolean resolvedNotNull = false;
        if (resolved == null) {
            resolved = response;
        } else {
            resolvedNotNull = true;
        }
        this.traverseMap((Map)resolved.getContent(), visitor, (BiFunction)this::traverseMediaType);
        this.traverseMap(resolved.getHeaders(), visitor, this::traverseHeader);
        this.traverseMap(resolved.getLinks(), visitor, this::traverseLink);
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, response.get$ref(), visitor)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getResponses() == null) {
                this.context.getOpenApi().getComponents().responses(new LinkedHashMap());
            }
            this.visitedMap.put(response, this.deepcopy(response, ApiResponse.class));
            this.visiting.remove(response);
            return this.handleRootLocalRefs(response.get$ref(), resolved, this.context.getOpenApi().getComponents().getResponses());
        }
        if (response.getDescription() != null) {
            resolved.description(response.getDescription());
        }
        this.visitedMap.put(response, this.deepcopy(resolved, ApiResponse.class));
        this.visiting.remove(response);
        return resolved;
    }

    public RequestBody traverseRequestBody(RequestBody requestBody, ReferenceVisitor visitor) {
        if (requestBody == null) {
            return null;
        }
        if (this.visiting.contains(requestBody)) {
            return requestBody;
        }
        if (this.visitedMap.containsKey(requestBody)) {
            return (RequestBody)this.visitedMap.get(requestBody);
        }
        this.visiting.add(requestBody);
        RequestBody resolved = visitor.visitRequestBody(requestBody);
        boolean resolvedNotNull = false;
        if (resolved == null) {
            resolved = requestBody;
        } else {
            resolvedNotNull = true;
        }
        this.traverseMap((Map)resolved.getContent(), visitor, (BiFunction)this::traverseMediaType);
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, requestBody.get$ref(), visitor)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getRequestBodies() == null) {
                this.context.getOpenApi().getComponents().requestBodies(new LinkedHashMap());
            }
            this.visitedMap.put(requestBody, this.deepcopy(requestBody, RequestBody.class));
            this.visiting.remove(requestBody);
            return this.handleRootLocalRefs(requestBody.get$ref(), resolved, this.context.getOpenApi().getComponents().getRequestBodies());
        }
        if (requestBody.getDescription() != null) {
            resolved.description(requestBody.getDescription());
        }
        this.visitedMap.put(requestBody, this.deepcopy(resolved, RequestBody.class));
        this.visiting.remove(requestBody);
        return resolved;
    }

    public PathItem traversePathItem(PathItem pathItem, ReferenceVisitor visitor) {
        Operation traceOp;
        Operation postOp;
        Operation headOp;
        Operation optionsOp;
        Operation patchOp;
        Operation deleteOp;
        Operation putOp;
        if (pathItem == null) {
            return null;
        }
        if (this.visiting.contains(pathItem)) {
            return pathItem;
        }
        if (this.visitedMap.containsKey(pathItem)) {
            return (PathItem)this.visitedMap.get(pathItem);
        }
        this.visiting.add(pathItem);
        PathItem resolved = visitor.visitPathItem(pathItem);
        boolean resolvedNotNull = false;
        if (resolved == null) {
            resolved = pathItem;
        } else {
            resolvedNotNull = true;
        }
        Operation getOp = resolved.getGet();
        Operation resolvedOperation = this.traverseOperation(getOp, visitor);
        if (resolvedOperation != null) {
            resolved.setGet(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(putOp = resolved.getPut(), visitor)) != null) {
            resolved.setPut(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(deleteOp = resolved.getDelete(), visitor)) != null) {
            resolved.setDelete(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(patchOp = resolved.getPatch(), visitor)) != null) {
            resolved.setPatch(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(optionsOp = resolved.getOptions(), visitor)) != null) {
            resolved.setOptions(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(headOp = resolved.getHead(), visitor)) != null) {
            resolved.setHead(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(postOp = resolved.getPost(), visitor)) != null) {
            resolved.setPost(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(traceOp = resolved.getTrace(), visitor)) != null) {
            resolved.setTrace(resolvedOperation);
        }
        if (resolved.getParameters() != null) {
            for (int i = 0; i < resolved.getParameters().size(); ++i) {
                Parameter resolvedParameter = this.traverseParameter((Parameter)resolved.getParameters().get(i), visitor);
                if (resolvedParameter == null) continue;
                resolved.getParameters().set(i, resolvedParameter);
            }
        }
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, pathItem.get$ref(), visitor)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getPathItems() == null) {
                this.context.getOpenApi().getComponents().pathItems(new LinkedHashMap());
            }
            this.visitedMap.put(pathItem, this.deepcopy(pathItem, PathItem.class));
            this.visiting.remove(pathItem);
            return this.handleRootLocalRefs(pathItem.get$ref(), resolved, this.context.getOpenApi().getComponents().getPathItems());
        }
        if (pathItem.getParameters() != null) {
            resolved.parameters(pathItem.getParameters());
        }
        if (pathItem.getDescription() != null) {
            resolved.description(pathItem.getDescription());
        }
        if (pathItem.getSummary() != null) {
            resolved.summary(pathItem.getSummary());
        }
        this.visitedMap.put(pathItem, this.deepcopy(resolved, PathItem.class));
        this.visiting.remove(pathItem);
        return resolved;
    }

    public Parameter traverseParameter(Parameter parameter, ReferenceVisitor visitor) {
        Schema schema;
        if (parameter == null) {
            return null;
        }
        if (this.visiting.contains(parameter)) {
            return parameter;
        }
        if (this.visitedMap.containsKey(parameter)) {
            return (Parameter)this.visitedMap.get(parameter);
        }
        this.visiting.add(parameter);
        Parameter resolved = visitor.visitParameter(parameter);
        boolean resolvedNotNull = false;
        if (resolved == null) {
            resolved = parameter;
        } else {
            resolvedNotNull = true;
        }
        this.traverseMap((Map)resolved.getContent(), visitor, (BiFunction)this::traverseMediaType);
        if (resolved.getSchema() != null && (schema = this.traverseSchema(resolved.getSchema(), visitor, new ArrayList<String>())) != null) {
            resolved.setSchema(schema);
        }
        this.traverseMap(resolved.getExamples(), visitor, this::traverseExample);
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, parameter.get$ref(), visitor)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getParameters() == null) {
                this.context.getOpenApi().getComponents().parameters(new LinkedHashMap());
            }
            this.visitedMap.put(parameter, this.deepcopy(parameter, Parameter.class));
            this.visiting.remove(parameter);
            return this.handleRootLocalRefs(parameter.get$ref(), resolved, this.context.getOpenApi().getComponents().getParameters());
        }
        if (parameter.getDescription() != null) {
            resolved.description(parameter.getDescription());
        }
        this.visitedMap.put(parameter, this.deepcopy(resolved, Parameter.class));
        this.visiting.remove(parameter);
        return resolved;
    }

    public Example traverseExample(Example example, ReferenceVisitor visitor) {
        if (example == null) {
            return null;
        }
        if (this.visiting.contains(example)) {
            return example;
        }
        if (this.visitedMap.containsKey(example)) {
            return (Example)this.visitedMap.get(example);
        }
        this.visiting.add(example);
        Example resolved = visitor.visitExample(example);
        boolean resolvedNotNull = false;
        if (resolved == null) {
            resolved = example;
        } else {
            resolvedNotNull = true;
        }
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, example.get$ref(), visitor)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getExamples() == null) {
                this.context.getOpenApi().getComponents().examples(new LinkedHashMap());
            }
            this.visitedMap.put(example, this.deepcopy(example, Example.class));
            this.visiting.remove(example);
            return this.handleRootLocalRefs(example.get$ref(), resolved, this.context.getOpenApi().getComponents().getExamples());
        }
        if (example.getDescription() != null) {
            resolved.description(example.getDescription());
        }
        if (example.getSummary() != null) {
            resolved.summary(example.getSummary());
        }
        this.visitedMap.put(example, this.deepcopy(resolved, Example.class));
        this.visiting.remove(example);
        return resolved;
    }

    public Callback traverseCallback(Callback callback, ReferenceVisitor visitor) {
        if (callback == null) {
            return null;
        }
        if (this.visiting.contains(callback)) {
            return callback;
        }
        if (this.visitedMap.containsKey(callback)) {
            return (Callback)this.visitedMap.get(callback);
        }
        this.visiting.add(callback);
        this.traverseMap((Map)callback, visitor, (BiFunction)this::traversePathItem);
        this.visitedMap.put(callback, callback);
        this.visiting.remove(callback);
        return callback;
    }

    public MediaType traverseMediaType(MediaType mediaType, ReferenceVisitor visitor) {
        Schema schema;
        if (mediaType == null) {
            return null;
        }
        if (this.visiting.contains(mediaType)) {
            return mediaType;
        }
        if (this.visitedMap.containsKey(mediaType)) {
            return (MediaType)this.visitedMap.get(mediaType);
        }
        this.visiting.add(mediaType);
        MediaType resolved = visitor.visitMediaType(mediaType);
        if (resolved == null) {
            resolved = mediaType;
        }
        if (resolved.getSchema() != null && (schema = this.traverseSchema(resolved.getSchema(), visitor, new ArrayList<String>())) != null) {
            resolved.setSchema(schema);
        }
        this.traverseMap(resolved.getEncoding(), visitor, this::traverseEncoding);
        this.traverseMap(resolved.getExamples(), visitor, this::traverseExample);
        this.visitedMap.put(mediaType, resolved);
        this.visiting.remove(mediaType);
        return resolved;
    }

    public Encoding traverseEncoding(Encoding encoding, ReferenceVisitor visitor) {
        if (encoding == null) {
            return null;
        }
        if (this.visiting.contains(encoding)) {
            return encoding;
        }
        if (this.visitedMap.containsKey(encoding)) {
            return (Encoding)this.visitedMap.get(encoding);
        }
        this.visiting.add(encoding);
        Encoding resolved = visitor.visitEncoding(encoding);
        if (resolved == null) {
            resolved = encoding;
        }
        this.traverseMap(resolved.getHeaders(), visitor, this::traverseHeader);
        this.visitedMap.put(encoding, resolved);
        this.visiting.remove(encoding);
        return resolved;
    }

    public Header traverseHeader(Header header, ReferenceVisitor visitor) {
        Schema schema;
        if (header == null) {
            return null;
        }
        if (this.visiting.contains(header)) {
            return header;
        }
        if (this.visitedMap.containsKey(header)) {
            return (Header)this.visitedMap.get(header);
        }
        this.visiting.add(header);
        Header resolved = visitor.visitHeader(header);
        boolean resolvedNotNull = false;
        if (resolved == null) {
            resolved = header;
        } else {
            resolvedNotNull = true;
        }
        this.traverseMap((Map)resolved.getContent(), visitor, (BiFunction)this::traverseMediaType);
        if (resolved.getSchema() != null && (schema = this.traverseSchema(resolved.getSchema(), visitor, new ArrayList<String>())) != null) {
            resolved.setSchema(schema);
        }
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, header.get$ref(), visitor)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getHeaders() == null) {
                this.context.getOpenApi().getComponents().headers(new LinkedHashMap());
            }
            this.visitedMap.put(header, this.deepcopy(header, Header.class));
            this.visiting.remove(header);
            return this.handleRootLocalRefs(header.get$ref(), resolved, this.context.getOpenApi().getComponents().getHeaders());
        }
        if (header.getDescription() != null) {
            resolved.description(header.getDescription());
        }
        this.visitedMap.put(header, this.deepcopy(resolved, Header.class));
        this.visiting.remove(header);
        return resolved;
    }

    public SecurityScheme traverseSecurityScheme(SecurityScheme securityScheme, ReferenceVisitor visitor) {
        if (securityScheme == null) {
            return null;
        }
        if (this.visiting.contains(securityScheme)) {
            return securityScheme;
        }
        if (this.visitedMap.containsKey(securityScheme)) {
            return (SecurityScheme)this.visitedMap.get(securityScheme);
        }
        this.visiting.add(securityScheme);
        SecurityScheme resolved = visitor.visitSecurityScheme(securityScheme);
        boolean resolvedNotNull = false;
        if (resolved == null) {
            resolved = securityScheme;
        } else {
            resolvedNotNull = true;
        }
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, securityScheme.get$ref(), visitor)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getSecuritySchemes() == null) {
                this.context.getOpenApi().getComponents().securitySchemes(new LinkedHashMap());
            }
            this.visitedMap.put(securityScheme, this.deepcopy(securityScheme, SecurityScheme.class));
            this.visiting.remove(securityScheme);
            return this.handleRootLocalRefs(securityScheme.get$ref(), resolved, this.context.getOpenApi().getComponents().getSecuritySchemes());
        }
        if (securityScheme.getDescription() != null) {
            resolved.description(securityScheme.getDescription());
        }
        this.visitedMap.put(securityScheme, this.deepcopy(resolved, SecurityScheme.class));
        this.visiting.remove(securityScheme);
        return resolved;
    }

    public Link traverseLink(Link link, ReferenceVisitor visitor) {
        if (link == null) {
            return null;
        }
        if (this.visiting.contains(link)) {
            return link;
        }
        if (this.visitedMap.containsKey(link)) {
            return (Link)this.visitedMap.get(link);
        }
        this.visiting.add(link);
        Link resolved = visitor.visitLink(link);
        boolean resolvedNotNull = false;
        if (resolved == null) {
            resolved = link;
        } else {
            resolvedNotNull = true;
        }
        this.traverseMap(resolved.getHeaders(), visitor, this::traverseHeader);
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, link.get$ref(), visitor)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getLinks() == null) {
                this.context.getOpenApi().getComponents().links(new LinkedHashMap());
            }
            this.visitedMap.put(link, this.deepcopy(link, Link.class));
            this.visiting.remove(link);
            return this.handleRootLocalRefs(link.get$ref(), resolved, this.context.getOpenApi().getComponents().getLinks());
        }
        if (link.getDescription() != null) {
            resolved.description(link.getDescription());
        }
        this.visitedMap.put(link, this.deepcopy(resolved, Link.class));
        this.visiting.remove(link);
        return resolved;
    }

    public Schema traverseSchema(Schema schema, ReferenceVisitor visitor, List<String> inheritedIds) {
        Schema resolvedSchema;
        Schema traversedSchema;
        if (schema == null) {
            return null;
        }
        if (this.visiting.contains(schema)) {
            return schema;
        }
        if (this.visitedMap.containsKey(schema)) {
            return (Schema)this.visitedMap.get(schema);
        }
        this.visiting.add(schema);
        if (StringUtils.isNotBlank((CharSequence)schema.get$id())) {
            inheritedIds.add(schema.get$id());
        }
        Schema resolved = visitor.visitSchema(schema, inheritedIds);
        boolean resolvedNotNull = false;
        if (resolved == null) {
            resolved = schema;
        } else {
            resolvedNotNull = true;
        }
        this.traverseSchemaMap(resolved.getProperties(), visitor, inheritedIds);
        if (resolved.getAdditionalItems() != null && (traversedSchema = this.traverseSchema(resolved.getAdditionalItems(), visitor, inheritedIds)) != null) {
            resolved.setAdditionalItems(traversedSchema);
        }
        if (resolved.getAdditionalProperties() != null && resolved.getAdditionalProperties() instanceof Schema && (traversedSchema = this.traverseSchema((Schema)resolved.getAdditionalProperties(), visitor, inheritedIds)) != null) {
            resolved.setAdditionalProperties((Object)traversedSchema);
        }
        if (resolved.getAllOf() != null) {
            for (int i = 0; i < resolved.getAllOf().size(); ++i) {
                resolvedSchema = this.traverseSchema((Schema)resolved.getAllOf().get(i), visitor, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved.getAllOf().set(i, resolvedSchema);
            }
        }
        if (resolved.getAnyOf() != null) {
            for (int i = 0; i < resolved.getAnyOf().size(); ++i) {
                resolvedSchema = this.traverseSchema((Schema)resolved.getAnyOf().get(i), visitor, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved.getAnyOf().set(i, resolvedSchema);
            }
        }
        if (resolved.getContains() != null && (traversedSchema = this.traverseSchema(resolved.getContains(), visitor, inheritedIds)) != null) {
            resolved.setContains(traversedSchema);
        }
        if (resolved.getContentSchema() != null && (traversedSchema = this.traverseSchema(resolved.getContentSchema(), visitor, inheritedIds)) != null) {
            resolved.setContentSchema(traversedSchema);
        }
        this.traverseSchemaMap(resolved.getDependentSchemas(), visitor, inheritedIds);
        if (resolved.getElse() != null && (traversedSchema = this.traverseSchema(resolved.getElse(), visitor, inheritedIds)) != null) {
            resolved.setElse(traversedSchema);
        }
        if (resolved.getIf() != null && (traversedSchema = this.traverseSchema(resolved.getIf(), visitor, inheritedIds)) != null) {
            resolved.setIf(traversedSchema);
        }
        if (resolved.getItems() != null && (traversedSchema = this.traverseSchema(resolved.getItems(), visitor, inheritedIds)) != null) {
            resolved.setItems(traversedSchema);
        }
        if (resolved.getNot() != null && (traversedSchema = this.traverseSchema(resolved.getNot(), visitor, inheritedIds)) != null) {
            resolved.setNot(traversedSchema);
        }
        if (resolved.getOneOf() != null) {
            for (int i = 0; i < resolved.getOneOf().size(); ++i) {
                resolvedSchema = this.traverseSchema((Schema)resolved.getOneOf().get(i), visitor, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved.getOneOf().set(i, resolvedSchema);
            }
        }
        this.traverseSchemaMap(resolved.getPatternProperties(), visitor, inheritedIds);
        if (resolved.getPrefixItems() != null) {
            for (int i = 0; i < resolved.getPrefixItems().size(); ++i) {
                resolvedSchema = this.traverseSchema((Schema)resolved.getPrefixItems().get(i), visitor, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved.getPrefixItems().set(i, resolvedSchema);
            }
        }
        if (resolved.getThen() != null && (traversedSchema = this.traverseSchema(resolved.getThen(), visitor, inheritedIds)) != null) {
            resolved.setThen(traversedSchema);
        }
        if (resolved.getUnevaluatedItems() != null && (traversedSchema = this.traverseSchema(resolved.getUnevaluatedItems(), visitor, inheritedIds)) != null) {
            resolved.setUnevaluatedItems(traversedSchema);
        }
        if (resolved.getAdditionalProperties() != null && resolved.getUnevaluatedProperties() instanceof Schema && (traversedSchema = this.traverseSchema((Schema)resolved.getUnevaluatedProperties(), visitor, inheritedIds)) != null) {
            resolved.setUnevaluatedProperties((Object)traversedSchema);
        }
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, schema.get$ref(), visitor)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getSchemas() == null) {
                this.context.getOpenApi().getComponents().schemas(new LinkedHashMap());
            }
            this.visitedMap.put(schema, this.deepcopy(schema, Schema.class));
            this.visiting.remove(schema);
            return this.handleRootLocalRefs(schema.get$ref(), resolved, this.context.getOpenApi().getComponents().getSchemas());
        }
        this.mergeSchemas(schema, resolved);
        this.visitedMap.put(schema, this.deepcopy(resolved, Schema.class));
        this.visiting.remove(schema);
        return resolved;
    }

    public <T> T deepcopy(T entity, Class<T> clazz) {
        try {
            return (T)Json31.mapper().readValue(Json31.mapper().writeValueAsString(entity), clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void traverseMap(Map<String, T> map, ReferenceVisitor visitor, BiFunction<T, ReferenceVisitor, T> traverser) {
        if (map != null) {
            LinkedHashMap<String, T> copy = new LinkedHashMap<String, T>(map);
            for (String key : copy.keySet()) {
                Object entity = copy.get(key);
                T resolved = traverser.apply(entity, visitor);
                if (resolved == null) continue;
                map.put(key, resolved);
            }
        }
    }

    public void traverseSchemaMap(Map<String, Schema> map, ReferenceVisitor visitor, List<String> inheritedIds) {
        if (map != null) {
            LinkedHashMap<String, Schema> copy = new LinkedHashMap<String, Schema>(map);
            for (String key : copy.keySet()) {
                Schema entity = (Schema)copy.get(key);
                Schema resolved = this.traverseSchema(entity, visitor, inheritedIds);
                if (resolved == null) continue;
                map.put(key, resolved);
            }
        }
    }

    public <T> T handleRootLocalRefs(String ref, T entity, Map<String, T> map) {
        if (!ReferenceUtils.isLocalRefToComponents(ref) && ReferenceUtils.isAnchorRef(ref)) {
            return null;
        }
        String name = ReferenceUtils.getRefName(ref);
        map.put(name, entity);
        return null;
    }

    public boolean shouldHandleRootLocalRefs(boolean resolvedNotNull, String ref, ReferenceVisitor visitor) {
        return resolvedNotNull && ReferenceUtils.isLocalRef(ref) && !this.getContext().getParseOptions().isResolveFully() && visitor.reference.getUri().equals(this.getContext().getRootUri()) && (ReferenceUtils.isLocalRefToComponents(ref) || ReferenceUtils.isAnchorRef(ref));
    }

    public void ensureComponents(OpenAPI openAPI) {
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(new Components());
        }
    }

    public void mergeSchemas(Schema source, Schema target) {
        if (source.getDescription() != null) {
            target.description(source.getDescription());
        }
        if (source.getOneOf() != null && !source.getOneOf().isEmpty()) {
            target.oneOf(source.getOneOf());
        }
        if (source.getNot() != null) {
            target.not(source.getNot());
        }
        if (source.getAnyOf() != null && !source.getAnyOf().isEmpty()) {
            target.anyOf(source.getAnyOf());
        }
        if (source.getType() != null) {
            target.type(source.getType());
        }
        if (source.getTypes() != null && !source.getTypes().isEmpty()) {
            target.types(source.getTypes());
        }
        if (source.getFormat() != null) {
            target.format(source.getFormat());
        }
        if (source.getRequired() != null) {
            target.required(source.getRequired());
        }
        if (source.getThen() != null) {
            target.then(source.getThen());
        }
        if (source.getIf() != null) {
            target._if(source.getIf());
        }
        if (source.getElse() != null) {
            target._else(source.getElse());
        }
        if (source.getContentSchema() != null) {
            target.contentSchema(source.getContentSchema());
        }
        if (source.getContains() != null) {
            target.contains(source.getContains());
        }
        if (source.getAdditionalProperties() != null) {
            target.additionalProperties(source.getAdditionalProperties());
        }
        if (source.getUnevaluatedProperties() != null) {
            target.unevaluatedProperties(source.getUnevaluatedProperties());
        }
        if (source.getUnevaluatedItems() != null) {
            target.unevaluatedItems(source.getUnevaluatedItems());
        }
        if (source.getPrefixItems() != null && !source.getPrefixItems().isEmpty()) {
            target.prefixItems(source.getPrefixItems());
        }
        if (source.getProperties() != null && !source.getProperties().isEmpty()) {
            target.properties(source.getProperties());
        }
        if (source.getPatternProperties() != null && !source.getPatternProperties().isEmpty()) {
            target.patternProperties(source.getPatternProperties());
        }
        if (source.getPattern() != null) {
            target.pattern(source.getPattern());
        }
        if (source.getDependentSchemas() != null && !source.getDependentSchemas().isEmpty()) {
            target.dependentSchemas(source.getDependentSchemas());
        }
        if (source.getConst() != null) {
            target._const(source.getConst());
        }
        if (source.getAdditionalItems() != null) {
            target.additionalItems(source.getAdditionalItems());
        }
        if (source.getEnum() != null && !source.getEnum().isEmpty()) {
            target._enum(source.getEnum());
        }
        if (source.getReadOnly() != null) {
            target.setReadOnly(source.getReadOnly());
        }
        if (source.getWriteOnly() != null) {
            target.setWriteOnly(source.getWriteOnly());
        }
        if (source.getMaxLength() != null) {
            target.setMaxLength(source.getMaxLength());
        }
        if (source.get$anchor() != null) {
            target.set$anchor(source.get$anchor());
        }
        if (source.get$comment() != null) {
            target.set$comment(source.get$comment());
        }
        if (source.get$id() != null) {
            target.set$id(source.get$id());
        }
        if (source.get$schema() != null) {
            target.set$schema(source.get$schema());
        }
        if (source.getContentEncoding() != null) {
            target.setContentEncoding(source.getContentEncoding());
        }
        if (source.getContentMediaType() != null) {
            target.setContentMediaType(source.getContentMediaType());
        }
        if (source.getDefault() != null) {
            target.setDefault(source.getDefault());
        }
        if (source.getDependentRequired() != null && !source.getDependentRequired().isEmpty()) {
            target.setDependentRequired(source.getDependentRequired());
        }
        if (source.getDeprecated() != null) {
            target.setDeprecated(source.getDeprecated());
        }
        if (source.getDiscriminator() != null) {
            target.setDiscriminator(source.getDiscriminator());
        }
        if (source.getExample() != null) {
            target.setExample(source.getExample());
        }
        if (source.getExamples() != null && !source.getExamples().isEmpty()) {
            target.setExamples(source.getExamples());
        }
        if (source.getExclusiveMaximum() != null) {
            target.setExclusiveMaximum(source.getExclusiveMaximum());
        }
        if (source.getExclusiveMaximumValue() != null) {
            target.setExclusiveMaximumValue(source.getExclusiveMaximumValue());
        }
        if (source.getExclusiveMinimum() != null) {
            target.setExclusiveMinimum(source.getExclusiveMinimum());
        }
        if (source.getExclusiveMinimumValue() != null) {
            target.setExclusiveMinimumValue(source.getExclusiveMinimumValue());
        }
        if (source.getExtensions() != null && !source.getExtensions().isEmpty()) {
            target.setExtensions(source.getExtensions());
        }
        if (source.getExternalDocs() != null) {
            target.setExternalDocs(source.getExternalDocs());
        }
        if (source.getMaxContains() != null) {
            target.setMaxContains(source.getMaxContains());
        }
        if (source.getMaximum() != null) {
            target.setMaximum(source.getMaximum());
        }
        if (source.getMaxItems() != null) {
            target.setMaxItems(source.getMaxItems());
        }
        if (source.getMaxProperties() != null) {
            target.setMaxProperties(source.getMaxProperties());
        }
        if (source.getMinContains() != null) {
            target.setMinContains(source.getMinContains());
        }
        if (source.getMinItems() != null) {
            target.setMinItems(source.getMinItems());
        }
        if (source.getMinProperties() != null) {
            target.setMinProperties(source.getMinProperties());
        }
        if (source.getMultipleOf() != null) {
            target.setMultipleOf(source.getMultipleOf());
        }
        if (source.getNullable() != null) {
            target.setNullable(source.getNullable());
        }
        if (source.getPropertyNames() != null) {
            target.setPropertyNames(source.getPropertyNames());
        }
        if (source.getTitle() != null) {
            target.setTitle(source.getTitle());
        }
        if (source.getUniqueItems() != null) {
            target.setUniqueItems(source.getUniqueItems());
        }
    }
}

