/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.vertx.ext.web.api.io.swagger.v3.parser.ResolverCache;
import io.vertx.ext.web.api.io.swagger.v3.parser.models.RefFormat;
import io.vertx.ext.web.api.io.swagger.v3.parser.processors.ExampleProcessor;
import io.vertx.ext.web.api.io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.vertx.ext.web.api.io.swagger.v3.parser.processors.SchemaProcessor;
import io.vertx.ext.web.api.io.swagger.v3.parser.util.RefUtils;

public class RequestBodyProcessor {
    private final SchemaProcessor schemaProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ExampleProcessor exampleProcessor;
    private final ResolverCache cache;
    private final OpenAPI openAPI;

    public RequestBodyProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, false);
    }

    public RequestBodyProcessor(ResolverCache cache, OpenAPI openAPI, boolean openapi31) {
        this.schemaProcessor = new SchemaProcessor(cache, openAPI, openapi31);
        this.exampleProcessor = new ExampleProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.cache = cache;
        this.openAPI = openAPI;
    }

    public void processRequestBody(RequestBody requestBody) {
        if (requestBody.get$ref() != null) {
            this.processReferenceRequestBody(requestBody);
        }
        Schema schema = null;
        if (requestBody.getContent() != null) {
            Content content = requestBody.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() != null && (schema = mediaType.getSchema()) != null) {
                    this.schemaProcessor.processSchema(schema);
                }
                if (mediaType.getExamples() == null) continue;
                for (Example ex : mediaType.getExamples().values()) {
                    this.exampleProcessor.processExample(ex);
                }
            }
        }
    }

    public void processReferenceRequestBody(RequestBody requestBody) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(requestBody.get$ref());
        String $ref = requestBody.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalRequestBody($ref, refFormat)) != null) {
            requestBody.set$ref(newRef);
        }
    }
}

