/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.io.swagger.v3.parser.reference;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.core.util.Yaml31;
import io.vertx.ext.web.api.io.swagger.v3.parser.core.models.AuthorizationValue;
import io.vertx.ext.web.api.io.swagger.v3.parser.util.ClasspathHelper;
import io.vertx.ext.web.api.io.swagger.v3.parser.util.RemoteUrl;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ReferenceUtils {
    public static String toBaseURI(String uri) throws Exception {
        URI resolved = new URI(uri);
        return (resolved.getScheme() != null ? resolved.getScheme() + ":" : "") + resolved.getSchemeSpecificPart();
    }

    public static String getFragment(String uri) throws Exception {
        URI resolved = new URI(uri);
        return resolved.getFragment();
    }

    public static String resolve(String uri, String baseURI) throws Exception {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return baseURI;
        }
        return new URI(baseURI).resolve(uri).toString();
    }

    public static boolean isLocalRef(String ref) {
        return !StringUtils.isBlank((CharSequence)ref) && ref.startsWith("#");
    }

    public static boolean isLocalRefToComponents(String ref) {
        return !StringUtils.isBlank((CharSequence)ref) && ref.startsWith("#/components");
    }

    public static boolean isAnchorRef(String ref) {
        if (!StringUtils.isBlank((CharSequence)ref) && ref.startsWith("#")) {
            return ReferenceUtils.isAnchor(ref.substring(1));
        }
        return false;
    }

    public static boolean isAnchor(String ref) {
        return !StringUtils.isBlank((CharSequence)ref) && Pattern.matches("^[A-Za-z_][A-Za-z_0-9.-]*$", ref);
    }

    public static String readURI(String absoluteUri, List<AuthorizationValue> auths) throws Exception {
        URI resolved = new URI(absoluteUri);
        if (StringUtils.isBlank((CharSequence)resolved.getScheme())) {
            String content = null;
            try {
                content = ReferenceUtils.readFile(absoluteUri);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isBlank((CharSequence)content)) {
                content = ReferenceUtils.readClasspath(absoluteUri);
            }
            return content;
        }
        if (resolved.getScheme().startsWith("http")) {
            return ReferenceUtils.readHttp(absoluteUri, auths);
        }
        if (resolved.getScheme().startsWith("file")) {
            return ReferenceUtils.readFile(absoluteUri);
        }
        if (resolved.getScheme().startsWith("classpath")) {
            return ReferenceUtils.readClasspath(absoluteUri);
        }
        throw new RuntimeException("scheme not supported for uri: " + absoluteUri);
    }

    public static JsonNode deserializeIntoTree(String content) throws Exception {
        boolean isJson = content.trim().startsWith("{");
        return isJson ? Json31.mapper().readTree(content) : Yaml31.mapper().readTree(content);
    }

    public static JsonNode parse(String absoluteUri, List<AuthorizationValue> auths) throws Exception {
        return ReferenceUtils.deserializeIntoTree(ReferenceUtils.readURI(absoluteUri, auths));
    }

    public static String readFile(String uri) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(uri);){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public static String readClasspath(String uri) throws Exception {
        return ClasspathHelper.loadFileFromClasspath(uri);
    }

    public static String readHttp(String uri, List<AuthorizationValue> auths) throws Exception {
        return RemoteUrl.urlToString(uri, auths);
    }

    public static String unescapePointer(String jsonPathElement) {
        try {
            jsonPathElement = URLDecoder.decode(jsonPathElement, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        jsonPathElement = jsonPathElement.replaceAll("~1", "/");
        return jsonPathElement.replaceAll("~0", "~");
    }

    public static JsonNode jsonPointerEvaluate(String fragment, JsonNode tree, String uri) {
        if (StringUtils.isBlank((CharSequence)fragment)) {
            return tree;
        }
        String[] tokens = fragment.split("/");
        JsonNode node = tree;
        for (String token : tokens) {
            if (!StringUtils.isNotBlank((CharSequence)token) || (node = node.get(ReferenceUtils.unescapePointer(token))) != null) continue;
            throw new RuntimeException("Could not find " + fragment + " in contents of " + uri);
        }
        return node;
    }

    public static String getRefName(String uri) {
        if (uri.indexOf("/") == -1 && uri.startsWith("#")) {
            return uri.substring(1);
        }
        String[] tokens = uri.split("/");
        return tokens[tokens.length - 1];
    }
}

