/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.api.contract.RouterFactoryException;
import io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenAPI3RouterFactoryImpl;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenApi3Utils;
import io.vertx.ext.web.api.io.swagger.v3.parser.OpenAPIV3Parser;
import io.vertx.ext.web.api.io.swagger.v3.parser.ResolverCache;
import io.vertx.ext.web.api.io.swagger.v3.parser.core.models.AuthorizationValue;
import io.vertx.ext.web.api.io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static void create(Vertx vertx, String url, List<JsonObject> auth, Handler<AsyncResult<OpenAPI3RouterFactory>> handler) {
        List authorizationValues = auth.stream().map(obj -> {
            AuthorizationValue authorizationValue = (AuthorizationValue)obj.mapTo(AuthorizationValue.class);
            authorizationValue.setUrlMatcher(u -> true);
            return authorizationValue;
        }).collect(Collectors.toList());
        vertx.executeBlocking(future -> {
            SwaggerParseResult swaggerParseResult = new OpenAPIV3Parser().readLocation(url, authorizationValues, OpenApi3Utils.getParseOptions());
            if (swaggerParseResult.getMessages().isEmpty()) {
                future.complete((Object)new OpenAPI3RouterFactoryImpl(vertx, swaggerParseResult.getOpenAPI(), new ResolverCache(swaggerParseResult.getOpenAPI(), null, url)));
            } else if (swaggerParseResult.getMessages().size() == 1 && swaggerParseResult.getMessages().get(0).matches("Unable to read location `?\\Q" + url + "\\E`?")) {
                future.fail((Throwable)RouterFactoryException.createSpecNotExistsException(url));
            } else {
                future.fail((Throwable)RouterFactoryException.createSpecInvalidException(StringUtils.join(swaggerParseResult.getMessages(), (String)", ")));
            }
        }, handler);
    }
}

