/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.io.swagger.v3.parser.util;

import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathUtils {
    static final String SCHEME_FILE = "file:";
    static final String SCHEME_HTTP = "http:";
    static final String SCHEME_HTTPS = "https:";

    public static Path getParentDirectoryOfFile(String location) {
        Path file = null;
        try {
            location = location.replaceAll("\\\\", "/");
            file = location.toLowerCase().startsWith(SCHEME_FILE) ? Paths.get(URI.create(location)).toAbsolutePath() : Paths.get(location, new String[0]).toAbsolutePath();
            if (!Files.exists(file, new LinkOption[0])) {
                return PathUtils.getParentDirectoryFromUrl(location);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return file.toAbsolutePath().getParent();
    }

    private static Path getParentDirectoryFromUrl(String location) {
        try {
            URL url = PathUtils.class.getResource(location);
            if (url == null) {
                url = PathUtils.class.getClassLoader().getResource(location);
            }
            if (url == null) {
                url = ClassLoader.getSystemResource(location);
            }
            Path file = Paths.get(URI.create(url.toExternalForm()));
            return file.getParent();
        }
        catch (Exception e) {
            e.getMessage();
            return null;
        }
    }

    public static String getAbsoluteUrl(String location) {
        Path file;
        block4: {
            file = null;
            try {
                location = location.replaceAll("\\\\", "/");
                if (location.toLowerCase().startsWith(SCHEME_HTTP) || location.toLowerCase().startsWith(SCHEME_HTTPS)) {
                    return location;
                }
                file = location.toLowerCase().startsWith(SCHEME_FILE) ? Paths.get(URI.create(location)).toAbsolutePath() : Paths.get(location, new String[0]).toAbsolutePath();
                if (!Files.exists(file, new LinkOption[0])) {
                    return PathUtils.getClasspathUrl(location);
                }
            }
            catch (Exception e) {
                if (file != null) break block4;
                return location;
            }
        }
        return file.toAbsolutePath().toUri().toString();
    }

    private static String getClasspathUrl(String location) {
        try {
            URL url = PathUtils.class.getResource(location);
            if (url == null) {
                url = PathUtils.class.getClassLoader().getResource(location);
            }
            if (url == null) {
                url = ClassLoader.getSystemResource(location);
            }
            Path file = Paths.get(URI.create(url.toExternalForm()));
            return file.toAbsolutePath().toUri().toString();
        }
        catch (Exception e) {
            return location;
        }
    }
}

