/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.io.swagger.v3.parser.reference;

import io.swagger.v3.oas.models.OpenAPI;
import io.vertx.ext.web.api.io.swagger.v3.parser.core.models.AuthorizationValue;
import io.vertx.ext.web.api.io.swagger.v3.parser.core.models.ParseOptions;
import io.vertx.ext.web.api.io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.vertx.ext.web.api.io.swagger.v3.parser.reference.Reference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DereferencerContext {
    protected final OpenAPI openApi;
    protected final List<AuthorizationValue> auths;
    protected String rootUri;
    protected final ParseOptions parseOptions;
    protected String providedBaseUri;
    protected SwaggerParseResult swaggerParseResult;
    protected boolean addParametersToEachOperation = true;
    protected String currentUri;
    private Map<String, Reference> referenceSet = new LinkedHashMap<String, Reference>();

    public DereferencerContext(SwaggerParseResult swaggerParseResult, List<AuthorizationValue> auths, String rootUri, ParseOptions parseOptions, String providedBaseUri, Map<String, Reference> referenceSet, Boolean addParametersToEachOperation) {
        this.swaggerParseResult = swaggerParseResult;
        this.openApi = swaggerParseResult.getOpenAPI();
        this.auths = auths;
        this.rootUri = rootUri;
        this.currentUri = rootUri;
        this.parseOptions = parseOptions;
        this.providedBaseUri = providedBaseUri;
        this.addParametersToEachOperation = addParametersToEachOperation != null ? addParametersToEachOperation : true;
        this.referenceSet = referenceSet != null ? referenceSet : new LinkedHashMap();
    }

    public OpenAPI getOpenApi() {
        return this.openApi;
    }

    public List<AuthorizationValue> getAuths() {
        return this.auths;
    }

    public String getRootUri() {
        return this.rootUri;
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }

    public String getProvidedBaseUri() {
        return this.providedBaseUri;
    }

    public SwaggerParseResult getSwaggerParseResult() {
        return this.swaggerParseResult;
    }

    public boolean isAddParametersToEachOperation() {
        return this.addParametersToEachOperation;
    }

    public void setAddParametersToEachOperation(boolean addParametersToEachOperation) {
        this.addParametersToEachOperation = addParametersToEachOperation;
    }

    public String getCurrentUri() {
        return this.currentUri;
    }

    public void setCurrentUri(String currentUri) {
        this.currentUri = currentUri;
    }

    public DereferencerContext providedBaseUri(String providedBaseUri) {
        this.providedBaseUri = providedBaseUri;
        return this;
    }

    public DereferencerContext swaggerParseResult(SwaggerParseResult swaggerParseResult) {
        this.swaggerParseResult = swaggerParseResult;
        return this;
    }

    public DereferencerContext addParametersToEachOperation(boolean addParametersToEachOperation) {
        this.addParametersToEachOperation = addParametersToEachOperation;
        return this;
    }

    public DereferencerContext currentUri(String currentUri) {
        this.currentUri = currentUri;
        return this;
    }

    public Map<String, Reference> getReferenceSet() {
        return this.referenceSet;
    }

    public void setReferenceSet(Map<String, Reference> referenceSet) {
        this.referenceSet = referenceSet;
    }

    public DereferencerContext referenceSet(Map<String, Reference> referenceSet) {
        this.referenceSet = referenceSet;
        return this;
    }

    public DereferencerContext rootUri(String rootUri) {
        this.rootUri = rootUri;
        return this;
    }
}

