/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.vertx.ext.web.api.io.swagger.v3.parser.ResolverCache;
import io.vertx.ext.web.api.io.swagger.v3.parser.models.RefFormat;
import io.vertx.ext.web.api.io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.vertx.ext.web.api.io.swagger.v3.parser.processors.OperationProcessor;
import io.vertx.ext.web.api.io.swagger.v3.parser.processors.ParameterProcessor;
import io.vertx.ext.web.api.io.swagger.v3.parser.util.RefUtils;
import java.util.List;
import java.util.Map;

public class CallbackProcessor {
    private final ResolverCache cache;
    private final OperationProcessor operationProcessor;
    private final ParameterProcessor parameterProcessor;
    private final OpenAPI openAPI;
    private final ExternalRefProcessor externalRefProcessor;

    public CallbackProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, false);
    }

    public CallbackProcessor(ResolverCache cache, OpenAPI openAPI, boolean openapi31) {
        this.cache = cache;
        this.operationProcessor = new OperationProcessor(cache, openAPI, openapi31);
        this.parameterProcessor = new ParameterProcessor(cache, openAPI, openapi31);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.openAPI = openAPI;
    }

    public void processCallback(Callback callback) {
        if (callback.get$ref() != null) {
            this.processReferenceCallback(callback);
        }
        for (String name : callback.keySet()) {
            PathItem pathItem = (PathItem)callback.get((Object)name);
            Map operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = (Operation)operationMap.get(httpMethod);
                this.operationProcessor.processOperation(operation);
            }
            List parameters = pathItem.getParameters();
            if (parameters == null) continue;
            for (Parameter parameter : parameters) {
                this.parameterProcessor.processParameter(parameter);
            }
        }
    }

    public void processReferenceCallback(Callback callback) {
        String newRef;
        String $ref = callback.get$ref();
        RefFormat refFormat = RefUtils.computeRefFormat($ref);
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalCallback($ref, refFormat)) != null) {
            callback.set$ref("#/components/callbacks/" + newRef);
        }
    }
}

