/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.impl.RequestParameterImpl;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.SingleValueParameterTypeValidator;
import java.util.List;

public class EnumTypeValidator<T>
extends SingleValueParameterTypeValidator<T> {
    private List<T> allowedValues;
    private ParameterTypeValidator innerValidator;

    public EnumTypeValidator(List<T> allowedValues, ParameterTypeValidator innerValidator) {
        super(innerValidator != null ? innerValidator.getDefault() : null);
        this.innerValidator = innerValidator;
        this.allowedValues = allowedValues;
    }

    @Override
    public RequestParameter isValidSingleParam(String value) {
        RequestParameterImpl parsedValue = (RequestParameterImpl)(this.innerValidator != null ? this.innerValidator.isValid(value) : RequestParameter.create(value));
        if (!this.allowedValues.contains(parsedValue.getValue())) {
            throw ValidationException.ValidationExceptionFactory.generateNotMatchValidationException("Value " + value + " in not inside enum list " + this.allowedValues.toString());
        }
        return parsedValue;
    }
}

