/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.io.swagger.v3.parser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.vertx.ext.web.api.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.vertx.ext.web.api.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;

public class ObjectMapperFactory {
    public static ObjectMapper createJson() {
        return ObjectMapperFactory.createJson(true, true);
    }

    protected static ObjectMapper createJson(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(ObjectMapperFactory.createJsonFactory(), includePathDeserializer, includeResponseDeserializer);
    }

    public static ObjectMapper createYaml() {
        return ObjectMapperFactory.createYaml(true, true);
    }

    protected static ObjectMapper createYaml(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(ObjectMapperFactory.createYamlFactory(), includePathDeserializer, includeResponseDeserializer);
    }

    private static ObjectMapper create(JsonFactory jsonFactory, boolean includePathDeserializer, boolean includeResponseDeserializer) {
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    private static JsonFactory createJsonFactory() {
        return ((JsonFactoryBuilder)new JsonFactoryBuilder().enable(StreamReadFeature.STRICT_DUPLICATE_DETECTION)).build();
    }

    private static JsonFactory createYamlFactory() {
        return ((YAMLFactoryBuilder)YAMLFactory.builder().enable(StreamReadFeature.STRICT_DUPLICATE_DETECTION)).build();
    }
}

