/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3.impl;

import java.util.regex.Pattern;

public class RegexBuilder {
    StringBuilder stringBuilder = new StringBuilder();

    RegexBuilder() {
    }

    public RegexBuilder escapeCharacter(String c) {
        this.stringBuilder.append("\\" + c);
        return this;
    }

    public RegexBuilder escapeCharacters(String ... chars) {
        for (String c : chars) {
            this.stringBuilder.append("\\" + c);
        }
        return this;
    }

    public RegexBuilder append(String s) {
        this.stringBuilder.append(s);
        return this;
    }

    public RegexBuilder quote(String s) {
        this.stringBuilder.append(Pattern.quote(s));
        return this;
    }

    public RegexBuilder atomicGroup(RegexBuilder group) {
        this.stringBuilder.append("(?>");
        this.stringBuilder.append(group.toString());
        this.stringBuilder.append(")");
        return this;
    }

    public RegexBuilder optionalGroup(RegexBuilder group) {
        this.stringBuilder.append("(?>");
        this.stringBuilder.append(group.toString());
        this.stringBuilder.append(")?");
        return this;
    }

    public RegexBuilder namedGroup(String name, RegexBuilder group) {
        this.stringBuilder.append("(?<");
        this.stringBuilder.append(name);
        this.stringBuilder.append(">");
        this.stringBuilder.append(group.toString());
        this.stringBuilder.append(")");
        return this;
    }

    public RegexBuilder negativeLookaheadGroup(RegexBuilder group) {
        this.stringBuilder.append("(!");
        this.stringBuilder.append(group.toString());
        this.stringBuilder.append(")");
        return this;
    }

    public RegexBuilder notCharactersClass(RegexBuilder group) {
        this.stringBuilder.append("[^");
        this.stringBuilder.append(group.toString());
        this.stringBuilder.append("]");
        return this;
    }

    public RegexBuilder notCharactersClass(String ... chars) {
        this.stringBuilder.append("[^");
        for (String c : chars) {
            if (c == null || c.length() == 0) continue;
            this.stringBuilder.append("\\" + c);
        }
        this.stringBuilder.append("]");
        return this;
    }

    public RegexBuilder charactersClass(RegexBuilder group) {
        this.stringBuilder.append("[");
        this.stringBuilder.append(group.toString());
        this.stringBuilder.append("]");
        return this;
    }

    public RegexBuilder charactersClass(String ... chars) {
        this.stringBuilder.append("[");
        for (String c : chars) {
            this.stringBuilder.append("\\" + c);
        }
        this.stringBuilder.append("]");
        return this;
    }

    public RegexBuilder zeroOrOne() {
        this.stringBuilder.append("?");
        return this;
    }

    public RegexBuilder zeroOrMore() {
        this.stringBuilder.append("*");
        return this;
    }

    public RegexBuilder oneOrMore() {
        this.stringBuilder.append("+");
        return this;
    }

    static RegexBuilder create() {
        return new RegexBuilder();
    }

    public String toString() {
        return this.stringBuilder.toString();
    }
}

