/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl.cache;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.client.CachingWebClientOptions;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.cache.CacheControl;
import io.vertx.ext.web.client.impl.cache.CacheKey;
import io.vertx.ext.web.client.impl.cache.CacheVariationsKey;
import io.vertx.ext.web.client.impl.cache.CachedHttpResponse;
import io.vertx.ext.web.client.impl.cache.Vary;
import io.vertx.ext.web.client.spi.CacheStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CacheInterceptor
implements Handler<HttpContext<?>> {
    private static final String IS_CACHE_DISPATCH = "cache.dispatch";
    private static final String REVALIDATION_RESPONSE = "cache.response_to_revalidate";
    private final CacheStore publicCacheStore;
    private final CachingWebClientOptions options;
    private final Map<CacheVariationsKey, Set<Vary>> variationsRegistry;

    public CacheInterceptor(CacheStore store, CachingWebClientOptions options) {
        this.publicCacheStore = store;
        this.options = options;
        this.variationsRegistry = new ConcurrentHashMap<CacheVariationsKey, Set<Vary>>();
    }

    public void handle(HttpContext<?> context) {
        switch (context.phase()) {
            case SEND_REQUEST: {
                this.handleSendRequest(context);
                break;
            }
            case DISPATCH_RESPONSE: {
                this.handleDispatchResponse(context);
                break;
            }
            default: {
                context.next();
            }
        }
    }

    private void handleSendRequest(HttpContext<Buffer> context) {
        Vary variation;
        RequestOptions request = context.requestOptions();
        if (!this.options.getCachedMethods().contains(request.getMethod()) || (variation = this.selectVariation(request)) == null) {
            context.next();
            return;
        }
        Promise promise = Promise.promise();
        CacheKey key = new CacheKey(request, variation);
        if (context.privateCacheStore() != null) {
            context.privateCacheStore().get(key).onSuccess(cached -> {
                if (cached == null) {
                    this.publicCacheStore.get(key).onComplete((Handler)promise);
                } else {
                    promise.complete(cached);
                }
            });
        } else {
            this.publicCacheStore.get(key).onComplete((Handler)promise);
        }
        promise.future().map(cached -> this.respondFromCache(context, (CachedHttpResponse)cached)).onComplete(ar -> {
            if (ar.succeeded() && ((Optional)ar.result()).isPresent()) {
                context.set(IS_CACHE_DISPATCH, true);
                context.dispatchResponse((HttpResponse)((Optional)ar.result()).get());
            } else {
                context.next();
            }
        });
    }

    private void handleDispatchResponse(HttpContext<Buffer> context) {
        Boolean isCacheDispatch = (Boolean)context.get(IS_CACHE_DISPATCH);
        if (isCacheDispatch == Boolean.TRUE) {
            context.next();
            return;
        }
        CachedHttpResponse responseToValidate = (CachedHttpResponse)context.get(REVALIDATION_RESPONSE);
        if (responseToValidate != null) {
            this.processRevalidationResponse(context, responseToValidate).onComplete(ar -> {
                if (ar.succeeded()) {
                    context.response((HttpResponse)ar.result());
                }
                context.next();
            });
        } else {
            this.processResponse(context, null).onComplete(ar -> context.next());
        }
    }

    private Vary selectVariation(RequestOptions request) {
        CacheVariationsKey key = new CacheVariationsKey(request);
        Set possibleVariations = this.variationsRegistry.getOrDefault(key, Collections.emptySet());
        for (Vary variation : possibleVariations) {
            if (!variation.matchesRequest(request)) continue;
            return variation;
        }
        return null;
    }

    private Future<HttpResponse<Buffer>> processResponse(HttpContext<Buffer> context, CachedHttpResponse cachedResponse) {
        HttpResponse<Buffer> response = context.response();
        if (this.options.getCachedStatusCodes().contains(response.statusCode())) {
            return this.cacheResponse(context, response).map(response);
        }
        if (cachedResponse != null && cachedResponse.useStaleIfError()) {
            return Future.succeededFuture(cachedResponse.rehydrate());
        }
        return Future.succeededFuture(response);
    }

    private Optional<HttpResponse<Buffer>> respondFromCache(HttpContext<Buffer> context, CachedHttpResponse response) {
        if (response == null) {
            return Optional.empty();
        }
        HttpResponse<Buffer> result = response.rehydrate();
        result.headers().set(HttpHeaders.AGE, (CharSequence)Long.toString(response.age()));
        if (response.getCacheControl().noCache()) {
            this.markForRevalidation(context, response);
            return Optional.empty();
        }
        if (response.isFresh()) {
            return Optional.of(result);
        }
        if (response.useStaleWhileRevalidate()) {
            context.clientRequest().send();
            return Optional.of(result);
        }
        this.markForRevalidation(context, response);
        return Optional.empty();
    }

    private void markForRevalidation(HttpContext<?> context, CachedHttpResponse response) {
        context.request().headers().set(HttpHeaders.IF_NONE_MATCH, (CharSequence)response.getCacheControl().getEtag());
        context.set(REVALIDATION_RESPONSE, response);
    }

    private Future<HttpResponse<Buffer>> processRevalidationResponse(HttpContext<Buffer> context, CachedHttpResponse cachedResponse) {
        if (context.response().statusCode() == 304) {
            return this.cacheResponse(context, cachedResponse.rehydrate());
        }
        return this.processResponse(context, cachedResponse);
    }

    private Future<HttpResponse<Buffer>> cacheResponse(HttpContext<?> context, HttpResponse<Buffer> response) {
        HttpRequest<?> request = context.request();
        CacheControl cacheControl = CacheControl.parse(response.headers());
        if (!cacheControl.isCacheable()) {
            return Future.succeededFuture(response);
        }
        if (cacheControl.isPrivate() && context.privateCacheStore() == null) {
            return Future.succeededFuture(response);
        }
        if (cacheControl.isVarying() && !this.options.isVaryCachingEnabled()) {
            return Future.succeededFuture(response);
        }
        CacheVariationsKey variationsKey = new CacheVariationsKey(context.requestOptions());
        Vary variation = new Vary(request.headers(), response.headers());
        this.registerVariation(variationsKey, variation);
        CacheKey key = new CacheKey(context.requestOptions(), variation);
        CachedHttpResponse cachedResponse = CachedHttpResponse.wrap(response, cacheControl);
        if (cacheControl.isPrivate()) {
            return context.privateCacheStore().set(key, cachedResponse).map(response);
        }
        return this.publicCacheStore.set(key, cachedResponse).map(response);
    }

    private void registerVariation(CacheVariationsKey variationsKey, Vary variation) {
        Set existing = this.variationsRegistry.getOrDefault(variationsKey, Collections.emptySet());
        HashSet updated = new HashSet(existing);
        updated.add(variation);
        this.variationsRegistry.put(variationsKey, updated);
    }
}

