/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.handler.graphql.GraphiQLHandler;
import io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class GraphiQLHandlerImpl
implements GraphiQLHandler {
    private static final String WEBROOT = "io/vertx/ext/web/handler/graphiql";
    private static final Function<RoutingContext, MultiMap> DEFAULT_FACTORY = rc -> null;
    private final Vertx vertx;
    private final GraphiQLHandlerOptions options;
    private final Function<RoutingContext, MultiMap> factory;

    public GraphiQLHandlerImpl(Vertx vertx, GraphiQLHandlerOptions options, Function<RoutingContext, MultiMap> factory) {
        this.vertx = vertx;
        this.options = options == null ? new GraphiQLHandlerOptions() : options;
        this.factory = factory == null ? DEFAULT_FACTORY : factory;
    }

    @Override
    public Router router() {
        Router router = Router.router((Vertx)this.vertx);
        if (this.options.isEnabled()) {
            router.get().handler(this::redirectIfNeeded);
            router.get("/").handler(this::serveIndex);
            router.get("/index.html").handler(this::serveIndex);
            router.get().handler((Handler)StaticHandler.create((String)WEBROOT).setCachingEnabled(true).setMaxAgeSeconds(TimeUnit.SECONDS.convert(365L, TimeUnit.DAYS)));
        }
        return router;
    }

    private void redirectIfNeeded(RoutingContext rc) {
        String normalizedPath = rc.normalizedPath();
        if (Utils.pathOffset((String)normalizedPath, (RoutingContext)rc).isEmpty()) {
            rc.response().setStatusCode(302).putHeader(HttpHeaders.LOCATION, (CharSequence)(normalizedPath + "/")).end();
            return;
        }
        rc.next();
    }

    private void serveIndex(RoutingContext rc) {
        String resource = rc.vertx().fileSystem().readFileBlocking("io/vertx/ext/web/handler/graphiql/index.html").toString(StandardCharsets.UTF_8).replace("__VERTX_GRAPHIQL_CONFIG__", this.replacement(rc));
        rc.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html;charset=utf8").end(resource);
    }

    private String replacement(RoutingContext rc) {
        MultiMap dynamicHeaders;
        JsonObject json = new JsonObject();
        json.put("httpEnabled", (Object)this.options.isHttpEnabled());
        if (this.options.getGraphQLUri() != null) {
            json.put("graphQLUri", (Object)this.options.getGraphQLUri());
        }
        json.put("graphQLWSEnabled", (Object)this.options.isGraphQLWSEnabled());
        if (this.options.getGraphQLWSUri() != null) {
            json.put("graphQLWSUri", (Object)this.options.getGraphQLWSUri());
        }
        if (this.options.getWsConnectionParams() != null) {
            json.put("wsConnectionParams", (Object)this.options.getWsConnectionParams());
        }
        MultiMap headers = MultiMap.caseInsensitiveMultiMap();
        Map<String, String> fixedHeaders = this.options.getHeaders();
        if (fixedHeaders != null) {
            fixedHeaders.forEach((arg_0, arg_1) -> ((MultiMap)headers).add(arg_0, arg_1));
        }
        if ((dynamicHeaders = this.factory.apply(rc)) != null) {
            headers.addAll(dynamicHeaders);
        }
        if (!headers.isEmpty()) {
            JsonObject headersJson = new JsonObject();
            headers.forEach(header -> headersJson.put((String)header.getKey(), header.getValue()));
            json.put("headers", (Object)headersJson);
        }
        if (this.options.getQuery() != null) {
            json.put("query", (Object)this.options.getQuery());
        }
        if (this.options.getVariables() != null) {
            json.put("parameters", (Object)this.options.getVariables());
        }
        return json.encode();
    }
}

