/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.router.impl;

import io.vertx.core.Future;
import io.vertx.ext.web.handler.APIKeyHandler;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.DigestAuthHandler;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.openapi.router.RouterBuilder;
import io.vertx.ext.web.openapi.router.Security;
import io.vertx.ext.web.openapi.router.impl.RouterBuilderInternal;
import io.vertx.openapi.contract.SecurityScheme;
import java.util.Objects;
import java.util.function.Function;

public class SecurityImpl
implements Security {
    private final RouterBuilderInternal routerBuilder;
    private final SecurityScheme securityScheme;
    private final String securitySchemeId;

    SecurityImpl(RouterBuilderInternal routerBuilder, SecurityScheme securityScheme, String securitySchemeId) {
        Objects.requireNonNull(routerBuilder, "'routerBuilder' cannot be null");
        Objects.requireNonNull(securityScheme, "'securityScheme' cannot be null");
        Objects.requireNonNull(securitySchemeId, "'securitySchemeId' cannot be null");
        this.routerBuilder = routerBuilder;
        this.securityScheme = securityScheme;
        this.securitySchemeId = securitySchemeId;
    }

    @Override
    public RouterBuilder apiKeyHandler(APIKeyHandler handler) {
        Objects.requireNonNull(handler, "'handler' cannot be null");
        if (!"apiKey".equals(this.securityScheme.getType())) {
            throw new IllegalStateException("Invalid 'type' value for APIKey security scheme: " + this.securityScheme.getType());
        }
        Objects.requireNonNull(this.securityScheme.getName(), "'name' cannot be null");
        Objects.requireNonNull(this.securityScheme.getIn(), "'in' cannot be null");
        switch (this.securityScheme.getIn()) {
            case "header": {
                this.routerBuilder.security(this.securitySchemeId, (AuthenticationHandler)handler.header(this.securityScheme.getName()), null);
                break;
            }
            case "query": {
                this.routerBuilder.security(this.securitySchemeId, (AuthenticationHandler)handler.parameter(this.securityScheme.getName()), null);
                break;
            }
            case "cookie": {
                this.routerBuilder.security(this.securitySchemeId, (AuthenticationHandler)handler.cookie(this.securityScheme.getName()), null);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid 'in' value for APIKey security scheme: " + this.securityScheme.getIn());
            }
        }
        return this.routerBuilder;
    }

    @Override
    public RouterBuilder httpHandler(BasicAuthHandler handler) {
        Objects.requireNonNull(handler, "'handler' cannot be null");
        if (!"http".equals(this.securityScheme.getType())) {
            throw new IllegalStateException("Invalid 'type' value for HTTP security scheme: " + this.securityScheme.getType());
        }
        if (!"basic".equals(this.securityScheme.getScheme())) {
            throw new IllegalStateException("Invalid 'schema' value for HTTP security scheme: " + this.securityScheme.getScheme());
        }
        this.routerBuilder.security(this.securitySchemeId, (AuthenticationHandler)handler, null);
        return this.routerBuilder;
    }

    @Override
    public RouterBuilder httpHandler(DigestAuthHandler handler) {
        Objects.requireNonNull(handler, "'handler' cannot be null");
        if (!"http".equals(this.securityScheme.getType())) {
            throw new IllegalStateException("Invalid 'type' value for HTTP security scheme: " + this.securityScheme.getType());
        }
        if (!"digest".equals(this.securityScheme.getScheme())) {
            throw new IllegalStateException("Invalid 'schema' value for HTTP security scheme: " + this.securityScheme.getScheme());
        }
        this.routerBuilder.security(this.securitySchemeId, (AuthenticationHandler)handler, null);
        return this.routerBuilder;
    }

    @Override
    public RouterBuilder httpHandler(JWTAuthHandler handler) {
        Objects.requireNonNull(handler, "'handler' cannot be null");
        if (!"http".equals(this.securityScheme.getType())) {
            throw new IllegalStateException("Invalid 'type' value for HTTP security scheme: " + this.securityScheme.getType());
        }
        if (!"bearer".equals(this.securityScheme.getScheme())) {
            throw new IllegalStateException("Invalid 'schema' value for HTTP security scheme: " + this.securityScheme.getScheme());
        }
        this.routerBuilder.security(this.securitySchemeId, (AuthenticationHandler)handler, null);
        return this.routerBuilder;
    }

    @Override
    public RouterBuilder oauth2Handler(String callback, Function<SecurityScheme, OAuth2AuthHandler> factory) {
        Objects.requireNonNull(factory, "'factory' cannot be null");
        if (!"oauth2".equals(this.securityScheme.getType())) {
            throw new IllegalStateException("Invalid 'type' value for Oauth2 security scheme: " + this.securityScheme.getType());
        }
        if (this.securityScheme.getFlows() != null && this.securityScheme.getFlows().getAuthorizationCode() != null) {
            Objects.requireNonNull(callback, "'callback' cannot be null when using authorizationCode flow");
        }
        this.routerBuilder.security(this.securitySchemeId, (AuthenticationHandler)factory.apply(this.securityScheme), callback);
        return this.routerBuilder;
    }

    @Override
    public Future<RouterBuilder> openIdConnectHandler(String callback, Function<String, Future<OAuth2AuthHandler>> factory) {
        if (!"openIdConnect".equals(this.securityScheme.getType())) {
            throw new IllegalStateException("Invalid 'type' value for OpenIdConnect security scheme: " + this.securityScheme.getType());
        }
        return factory.apply(this.securityScheme.getOpenIdConnectUrl()).onSuccess(handler -> this.routerBuilder.security(this.securitySchemeId, (AuthenticationHandler)handler, callback)).map((Object)this.routerBuilder);
    }
}

