/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.web.openapi.OpenAPIHolder;
import io.vertx.ext.web.openapi.OpenAPILoaderOptions;
import io.vertx.ext.web.openapi.impl.OpenAPI3Utils;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.common.SchemaURNId;
import io.vertx.json.schema.common.URIUtils;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class OpenAPIHolderImpl
implements OpenAPIHolder {
    private final Vertx vertx;
    private final Map<URI, JsonObject> absolutePaths;
    private final HttpClient client;
    private final FileSystem fs;
    private final SchemaRouter router;
    private final SchemaParser parser;
    private final Schema openapiSchema;
    private final OpenAPILoaderOptions options;
    private URI initialScope;
    private String initialScopeDirectory;
    private final Map<URI, Future<JsonObject>> externalSolvingRefs;
    private final YAMLMapper yamlMapper;
    private JsonObject openapiRoot;

    public OpenAPIHolderImpl(Vertx vertx, HttpClient client, FileSystem fs, OpenAPILoaderOptions options) {
        this.vertx = vertx;
        this.absolutePaths = new ConcurrentHashMap<URI, JsonObject>();
        this.externalSolvingRefs = new ConcurrentHashMap<URI, Future<JsonObject>>();
        this.client = client;
        this.fs = fs;
        this.options = options;
        this.router = SchemaRouter.create((HttpClient)client, (FileSystem)fs, (SchemaRouterOptions)options.toSchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
        this.yamlMapper = new YAMLMapper();
        this.openapiSchema = this.parser.parseFromString(OpenAPI3Utils.openapiSchemaJson);
    }

    public Future<JsonObject> loadOpenAPI(String u) {
        URI uri = URIUtils.removeFragment((URI)URI.create(u));
        return (URIUtils.isRemoteURI((URI)uri) ? this.solveRemoteRef(uri) : this.solveLocalRef(uri)).onSuccess(openapiBytes -> {
            this.initialScope = URIUtils.isRemoteURI((URI)uri) || uri.isAbsolute() ? uri : OpenAPIHolderImpl.getResourceAbsoluteURI(uri);
            this.initialScopeDirectory = this.resolveContainingDirPath(this.initialScope);
        }).compose(openapi -> {
            this.absolutePaths.put(this.initialScope, (JsonObject)openapi);
            this.openapiRoot = openapi;
            return this.walkAndSolve((JsonObject)openapi, this.initialScope).map(openapi);
        }).compose(openapi -> {
            JsonObject openapiCopy = openapi.copy();
            this.deepSubstituteForValidation(openapiCopy, JsonPointer.fromURI((URI)this.initialScope), new HashMap<JsonPointer, JsonPointer>());
            return this.openapiSchema.validateAsync((Object)openapiCopy).map(openapi);
        });
    }

    @Override
    public JsonObject getCached(JsonPointer pointer) {
        JsonObject startingObj = this.absolutePaths.get(this.resolveRefResolutionURIWithoutFragment(pointer.getURIWithoutFragment(), this.initialScope));
        return (JsonObject)pointer.queryJson((Object)startingObj);
    }

    @Override
    public JsonObject solveIfNeeded(JsonObject obj) {
        JsonObject o;
        Objects.requireNonNull(obj);
        if (this.isRef(obj) && !(o = this.getCached(JsonPointer.fromURI((URI)URI.create(obj.getString("$ref"))))).equals((Object)obj)) {
            return this.solveIfNeeded(o);
        }
        return obj;
    }

    private boolean isRef(JsonObject object) {
        return object.containsKey("$ref");
    }

    @Override
    public JsonObject getOpenAPI() {
        return this.openapiRoot;
    }

    public Map.Entry<JsonPointer, JsonObject> normalizeSchema(JsonObject schema, JsonPointer scope, Map<JsonPointer, JsonObject> additionalSchemasToRegister) {
        JsonObject normalized = schema.copy();
        JsonPointer newId = new SchemaURNId().toPointer();
        normalized.put("x-$id", (Object)newId.toURI().toString());
        this.innerNormalizeSchema(normalized, scope, additionalSchemasToRegister);
        return new AbstractMap.SimpleImmutableEntry<JsonPointer, JsonObject>(newId, normalized);
    }

    private void innerNormalizeSchema(Object schema, JsonPointer schemaRootScope, Map<JsonPointer, JsonObject> additionalSchemasToRegister) {
        if (schema instanceof JsonObject) {
            JsonObject schemaObject = (JsonObject)schema;
            if (this.isRef(schemaObject)) {
                JsonPointer refPointer = JsonPointer.fromURI((URI)URI.create(schemaObject.getString("$ref")));
                if (refPointer.isParent(schemaRootScope)) {
                    JsonPointer newRef = OpenAPI3Utils.pointerDifference(schemaRootScope, refPointer);
                    schemaObject.put("$ref", (Object)newRef.toURI().toString());
                } else if (refPointer.equals(schemaRootScope)) {
                    JsonPointer newRef = JsonPointer.create();
                    schemaObject.put("$ref", (Object)newRef.toURI().toString());
                } else {
                    JsonObject resolved = this.getCached(refPointer);
                    if (!resolved.containsKey("x-$id")) {
                        JsonPointer id = new SchemaURNId().toPointer();
                        resolved.put("x-$id", (Object)id.toURI().toString());
                        JsonObject resolvedCopy = resolved.copy();
                        this.innerNormalizeSchema(resolvedCopy, refPointer, additionalSchemasToRegister);
                        additionalSchemasToRegister.put(id, resolvedCopy);
                    }
                    schemaObject.put("$ref", (Object)resolved.getString("x-$id"));
                }
            } else {
                schemaObject.forEach(e -> this.innerNormalizeSchema(e.getValue(), schemaRootScope, additionalSchemasToRegister));
            }
        } else if (schema instanceof JsonArray) {
            JsonArray schemaArray = (JsonArray)schema;
            for (int i = 0; i < schemaArray.size(); ++i) {
                this.innerNormalizeSchema(schemaArray.getValue(i), schemaRootScope, additionalSchemasToRegister);
            }
        }
    }

    protected URI getInitialScope() {
        return this.initialScope;
    }

    private Future<Void> walkAndSolve(JsonObject obj, URI scope) {
        ArrayList<JsonObject> candidateRefs = new ArrayList<JsonObject>();
        HashSet<URI> refsToSolve = new HashSet<URI>();
        this.deepGetAllRefs(obj, candidateRefs);
        if (candidateRefs.isEmpty()) {
            return Future.succeededFuture();
        }
        for (JsonObject ref : candidateRefs) {
            JsonPointer parsedRef = JsonPointer.fromURI((URI)URI.create(ref.getString("$ref")));
            if (!parsedRef.getURIWithoutFragment().isAbsolute()) {
                parsedRef = JsonPointer.fromURI((URI)URIUtils.replaceFragment((URI)this.resolveRefResolutionURIWithoutFragment(parsedRef.getURIWithoutFragment(), scope), (String)parsedRef.toURI().getFragment()));
            }
            URI solvedURI = parsedRef.toURI();
            ref.put("$ref", (Object)solvedURI.toString());
            if (this.absolutePaths.containsKey(parsedRef.getURIWithoutFragment())) continue;
            refsToSolve.add(parsedRef.getURIWithoutFragment());
        }
        return CompositeFuture.all(refsToSolve.stream().map(this::resolveExternalRef).collect(Collectors.toList())).compose(cf -> Future.succeededFuture());
    }

    private void deepGetAllRefs(Object obj, List<JsonObject> refsList) {
        if (obj instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)obj;
            if (jsonObject.containsKey("$ref")) {
                refsList.add(jsonObject);
            } else {
                for (String keys : jsonObject.fieldNames()) {
                    this.deepGetAllRefs(jsonObject.getValue(keys), refsList);
                }
            }
        }
        if (obj instanceof JsonArray) {
            for (Object in : (JsonArray)obj) {
                this.deepGetAllRefs(in, refsList);
            }
        }
    }

    private void deepSubstituteForValidation(Object obj, JsonPointer scope, Map<JsonPointer, JsonPointer> originalToSubstitutedMap) {
        if (obj instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)obj;
            if (jsonObject.containsKey("$ref")) {
                JsonPointer pointer = JsonPointer.fromURI((URI)URI.create(jsonObject.getString("$ref")));
                if (!pointer.isParent(scope)) {
                    JsonObject resolved;
                    JsonObject cached = this.getCached(pointer);
                    if (cached == null) {
                        throw new IllegalStateException("Cannot resolve '" + pointer.toString() + "', this may be an invalid reference");
                    }
                    if (!originalToSubstitutedMap.containsKey(pointer)) {
                        resolved = this.solveIfNeeded(cached).copy();
                        jsonObject.remove("$ref");
                        jsonObject.mergeIn(resolved);
                        jsonObject.put("x-$ref", (Object)pointer.toURI().toString());
                        originalToSubstitutedMap.put(pointer, scope);
                        this.deepSubstituteForValidation(jsonObject, pointer, originalToSubstitutedMap);
                    } else {
                        resolved = this.solveIfNeeded(cached).copy();
                        jsonObject.remove("$ref");
                        jsonObject.mergeIn(resolved);
                        jsonObject.put("x-$ref", (Object)originalToSubstitutedMap.get(pointer).toURI().toString());
                    }
                }
            } else {
                for (String key : jsonObject.fieldNames()) {
                    this.deepSubstituteForValidation(jsonObject.getValue(key), scope.copy().append(key), originalToSubstitutedMap);
                }
            }
        }
        if (obj instanceof JsonArray) {
            for (int i = 0; i < ((JsonArray)obj).size(); ++i) {
                this.deepSubstituteForValidation(((JsonArray)obj).getValue(i), scope.copy().append(Integer.toString(i)), originalToSubstitutedMap);
            }
        }
    }

    private Future<JsonObject> resolveExternalRef(URI ref) {
        return this.externalSolvingRefs.computeIfAbsent(ref, uri -> (URIUtils.isRemoteURI((URI)uri) ? this.solveRemoteRef((URI)uri) : this.solveLocalRef((URI)uri)).compose(j -> {
            this.absolutePaths.put((URI)uri, (JsonObject)j);
            return this.walkAndSolve((JsonObject)j, (URI)uri).map(j);
        }));
    }

    private Future<JsonObject> solveRemoteRef(URI ref) {
        String uri = ref.toString();
        if (!this.options.getAuthQueryParams().isEmpty()) {
            QueryStringEncoder encoder = new QueryStringEncoder(uri);
            this.options.getAuthQueryParams().forEach((arg_0, arg_1) -> ((QueryStringEncoder)encoder).addParam(arg_0, arg_1));
            uri = encoder.toString();
        }
        RequestOptions reqOptions = new RequestOptions().setMethod(HttpMethod.GET).setAbsoluteURI(uri).setFollowRedirects(Boolean.valueOf(true)).addHeader(HttpHeaders.ACCEPT.toString(), "application/json, application/yaml, application/x-yaml");
        this.options.getAuthHeaders().forEach((arg_0, arg_1) -> ((RequestOptions)reqOptions).addHeader(arg_0, arg_1));
        Promise resultProm = Promise.promise();
        this.client.request(reqOptions, httpClientRequestAsyncResult -> {
            if (httpClientRequestAsyncResult.failed()) {
                resultProm.fail(httpClientRequestAsyncResult.cause());
                return;
            }
            ((HttpClientRequest)httpClientRequestAsyncResult.result()).send(responseAr -> {
                if (responseAr.failed()) {
                    resultProm.fail(responseAr.cause());
                    return;
                }
                HttpClientResponse res = (HttpClientResponse)responseAr.result();
                if (res.statusCode() != 200) {
                    resultProm.fail((Throwable)new IllegalStateException("Wrong status " + res.statusCode() + " " + res.statusMessage() + " received while resolving remote ref"));
                    return;
                }
                boolean expectJson = "application/json".equals(res.getHeader("Content-Type"));
                res.bodyHandler(buf -> {
                    try {
                        if (expectJson) {
                            resultProm.complete((Object)buf.toJsonObject());
                        } else {
                            resultProm.complete((Object)this.yamlToJson((Buffer)buf));
                        }
                    }
                    catch (DecodeException e) {
                        resultProm.fail((Throwable)new RuntimeException("Cannot decode the received " + (expectJson ? "JSON" : "YAML") + " response: ", e));
                    }
                });
            });
        });
        return resultProm.future();
    }

    private Future<JsonObject> solveLocalRef(URI ref) {
        String filePath = this.extractPath(ref);
        return this.fs.readFile(filePath).compose(buf -> {
            try {
                return Future.succeededFuture((Object)buf.toJsonObject());
            }
            catch (DecodeException e) {
                try {
                    return Future.succeededFuture((Object)this.yamlToJson((Buffer)buf));
                }
                catch (Exception e1) {
                    return Future.failedFuture((Throwable)new RuntimeException("File " + filePath + " is not a valid YAML or JSON", e1));
                }
            }
        });
    }

    private JsonObject yamlToJson(Buffer buf) {
        try {
            return JsonObject.mapFrom((Object)this.yamlMapper.readTree(buf.getBytes()));
        }
        catch (IOException e) {
            throw new DecodeException("Cannot decode YAML", (Throwable)e);
        }
    }

    private URI resolveRefResolutionURIWithoutFragment(URI ref, URI scope) {
        if ((ref = URIUtils.removeFragment((URI)ref)).isAbsolute()) {
            return ref;
        }
        if (ref.getPath() != null && !ref.getPath().isEmpty() && !ref.equals(scope)) {
            if (ref.toString().startsWith(this.initialScopeDirectory)) {
                return ref;
            }
            URI fromClasspath = OpenAPIHolderImpl.getResourceAbsoluteURIFromClasspath(ref);
            if (fromClasspath != null) {
                return fromClasspath;
            }
            return URIUtils.resolvePath((URI)scope, (String)ref.getPath());
        }
        return scope;
    }

    private String extractPath(URI ref) {
        return "jar".equals(ref.getScheme()) ? ref.getSchemeSpecificPart().split("!")[1].substring(1) : ref.getPath();
    }

    private Path uriToPath(URI uri) {
        try {
            switch (uri.getScheme()) {
                case "http": {
                    return Paths.get(uri.getPath(), new String[0]);
                }
                case "file": {
                    return Paths.get(uri);
                }
                case "jar": {
                    return Paths.get(uri.getSchemeSpecificPart().split("!")[1].substring(1), new String[0]);
                }
            }
            throw new IllegalArgumentException("unsupported scheme type for '" + uri + "'");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve path from " + uri, e);
        }
    }

    private String resolveContainingDirPath(URI absoluteURI) {
        return this.uriToPath(absoluteURI).resolveSibling("").toString();
    }

    protected static URI getResourceAbsoluteURI(URI relativeURI) {
        URI fromClasspath = OpenAPIHolderImpl.getResourceAbsoluteURIFromClasspath(relativeURI);
        if (fromClasspath != null) {
            return fromClasspath;
        }
        return Paths.get(relativeURI.getPath(), new String[0]).toAbsolutePath().toUri();
    }

    protected static URI getResourceAbsoluteURIFromClasspath(URI u) {
        try {
            return OpenAPIHolderImpl.getClassLoader().getResource(u.toString()).toURI();
        }
        catch (NullPointerException | URISyntaxException e) {
            return null;
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = OpenAPIHolderImpl.class.getClassLoader();
        }
        if (cl == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }

    public Map<URI, JsonObject> getAbsolutePaths() {
        return this.absolutePaths;
    }
}

