/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.SimpleAuthenticationHandler;
import io.vertx.ext.web.handler.impl.ScopedAuthentication;
import io.vertx.ext.web.openapi.RouterBuilderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class AuthenticationHandlersStore {
    private static final JsonObject EMPTY_JSON = new JsonObject(Collections.emptyMap());
    private static final AuthenticationHandler SUCCESS_HANDLER = SimpleAuthenticationHandler.create().authenticate(ctx -> Future.succeededFuture((Object)User.create((JsonObject)EMPTY_JSON)));
    private final Map<String, List<AuthenticationHandler>> securityHandlers = new HashMap<String, List<AuthenticationHandler>>();

    AuthenticationHandlersStore() {
    }

    protected void addAuthnRequirement(String name, AuthenticationHandler handler) {
        this.securityHandlers.computeIfAbsent(name, k -> new ArrayList()).add(handler);
    }

    protected AuthenticationHandler solveAuthenticationHandler(JsonArray securityRequirements, boolean failOnNotFound) {
        return this.orAuths(securityRequirements, failOnNotFound);
    }

    private List<AuthenticationHandler> resolveHandlers(Map.Entry<String, Object> e, boolean failOnNotFound) {
        List<Object> authenticationHandlers = failOnNotFound ? Optional.ofNullable(this.securityHandlers.get(e.getKey())).orElseThrow(() -> RouterBuilderException.createMissingSecurityHandler((String)e.getKey())) : Optional.ofNullable(this.securityHandlers.get(e.getKey())).orElse(Collections.emptyList());
        if (e.getValue() instanceof JsonArray && ((JsonArray)e.getValue()).size() != 0) {
            List scopes = ((JsonArray)e.getValue()).stream().map(v -> (String)v).collect(Collectors.toList());
            for (int i = 0; i < authenticationHandlers.size(); ++i) {
                if (!(authenticationHandlers.get(i) instanceof ScopedAuthentication)) continue;
                ScopedAuthentication scopedHandler = (ScopedAuthentication)authenticationHandlers.get(i);
                AuthenticationHandler updatedHandler = scopedHandler.withScopes(scopes);
                authenticationHandlers.set(i, updatedHandler);
            }
        }
        return authenticationHandlers;
    }

    private AuthenticationHandler andAuths(JsonObject securityRequirements, boolean failOnNotFound) {
        List<AuthenticationHandler> handlers = securityRequirements.stream().flatMap(e -> this.resolveHandlers((Map.Entry<String, Object>)e, failOnNotFound).stream()).collect(Collectors.toList());
        if (handlers.size() == 0) {
            return null;
        }
        if (handlers.size() == 1) {
            return (AuthenticationHandler)handlers.get(0);
        }
        ChainAuthHandler authHandler = ChainAuthHandler.all();
        handlers.forEach(arg_0 -> ((ChainAuthHandler)authHandler).add(arg_0));
        return authHandler;
    }

    private AuthenticationHandler orAuths(JsonArray securityRequirements, boolean failOnNotFound) {
        if (securityRequirements == null || securityRequirements.size() == 0) {
            return null;
        }
        boolean hasEmptyAuth = false;
        for (int i = 0; i < securityRequirements.size(); ++i) {
            if (!EMPTY_JSON.equals(securityRequirements.getValue(i))) continue;
            hasEmptyAuth = true;
            securityRequirements.remove(i);
            break;
        }
        switch (securityRequirements.size()) {
            case 0: {
                return SUCCESS_HANDLER;
            }
            case 1: {
                if (hasEmptyAuth) break;
                return this.andAuths(securityRequirements.getJsonObject(0), failOnNotFound);
            }
        }
        ChainAuthHandler authHandler = ChainAuthHandler.any();
        securityRequirements.stream().map(jo -> (JsonObject)jo).map(jo -> this.andAuths((JsonObject)jo, failOnNotFound)).filter(Objects::nonNull).forEach(arg_0 -> ((ChainAuthHandler)authHandler).add(arg_0));
        if (hasEmptyAuth) {
            authHandler.add(SUCCESS_HANDLER);
        }
        return authHandler;
    }
}

