/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.service.RouteToEBServiceHandler;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.ResponseContentTypeHandler;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.openapi.OpenAPIHolder;
import io.vertx.ext.web.openapi.OpenAPILoaderOptions;
import io.vertx.ext.web.openapi.Operation;
import io.vertx.ext.web.openapi.RouterBuilder;
import io.vertx.ext.web.openapi.RouterBuilderException;
import io.vertx.ext.web.openapi.RouterBuilderOptions;
import io.vertx.ext.web.openapi.SecurityScheme;
import io.vertx.ext.web.openapi.impl.AuthenticationHandlersStore;
import io.vertx.ext.web.openapi.impl.ContractEndpointHandler;
import io.vertx.ext.web.openapi.impl.DeepObjectParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.DefaultParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.ExplodedArrayParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.ExplodedMatrixArrayParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.ExplodedObjectParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.ExplodedSimpleObjectParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.JsonBodyProcessorGenerator;
import io.vertx.ext.web.openapi.impl.JsonParameterProcessorGenerator;
import io.vertx.ext.web.openapi.impl.MultipartFormBodyProcessorGenerator;
import io.vertx.ext.web.openapi.impl.OpenAPI3PathResolver;
import io.vertx.ext.web.openapi.impl.OpenAPI3Utils;
import io.vertx.ext.web.openapi.impl.OpenAPI3ValidationHandlerGenerator;
import io.vertx.ext.web.openapi.impl.OpenAPIHolderImpl;
import io.vertx.ext.web.openapi.impl.OperationImpl;
import io.vertx.ext.web.openapi.impl.SecuritySchemeImpl;
import io.vertx.ext.web.openapi.impl.UrlEncodedFormBodyProcessorGenerator;
import io.vertx.ext.web.validation.impl.ValidationHandlerImpl;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.openapi3.OpenAPI3SchemaParser;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OpenAPI3RouterBuilderImpl
implements RouterBuilder {
    private static final String OPENAPI_EXTENSION = "x-vertx-event-bus";
    private static final String OPENAPI_EXTENSION_ADDRESS = "address";
    private static final String OPENAPI_EXTENSION_METHOD_NAME = "method";
    private static final Handler<RoutingContext> NOT_IMPLEMENTED_HANDLER = rc -> rc.fail(501);
    private static final Logger LOG = LoggerFactory.getLogger(OpenAPI3RouterBuilderImpl.class);
    private Vertx vertx;
    private OpenAPIHolder openapi;
    private RouterBuilderOptions options;
    private Map<String, OperationImpl> operations;
    private BodyHandler bodyHandler;
    private AuthenticationHandlersStore securityHandlers;
    private List<Handler<RoutingContext>> globalHandlers;
    private Function<RoutingContext, JsonObject> serviceExtraPayloadMapper;
    private SchemaRouter schemaRouter;
    private OpenAPI3SchemaParser schemaParser;
    private OpenAPI3ValidationHandlerGenerator validationHandlerGenerator;

    private static Handler<RoutingContext> generateNotAllowedHandler(List<HttpMethod> allowedMethods) {
        return rc -> {
            rc.addHeadersEndHandler(v -> rc.response().headers().add("Allow", String.join((CharSequence)", ", allowedMethods.stream().map(HttpMethod::toString).collect(Collectors.toList()))));
            rc.fail(405);
        };
    }

    public OpenAPI3RouterBuilderImpl(Vertx vertx, HttpClient client, OpenAPIHolderImpl spec, OpenAPILoaderOptions options) {
        this.vertx = vertx;
        this.openapi = spec;
        this.options = new RouterBuilderOptions();
        this.bodyHandler = BodyHandler.create();
        this.globalHandlers = new ArrayList<Handler<RoutingContext>>();
        this.schemaRouter = SchemaRouter.create((HttpClient)client, (FileSystem)vertx.fileSystem(), (SchemaRouterOptions)options.toSchemaRouterOptions());
        this.schemaParser = OpenAPI3SchemaParser.create((SchemaRouter)this.schemaRouter);
        this.schemaParser.withStringFormatValidator("binary", v -> true);
        this.validationHandlerGenerator = new OpenAPI3ValidationHandlerGenerator(spec, (SchemaParser)this.schemaParser);
        spec.getAbsolutePaths().forEach((u, jo) -> this.schemaRouter.addJson(u, jo));
        this.validationHandlerGenerator.addParameterProcessorGenerator(new DeepObjectParameterProcessorGenerator()).addParameterProcessorGenerator(new ExplodedArrayParameterProcessorGenerator()).addParameterProcessorGenerator(new ExplodedMatrixArrayParameterProcessorGenerator()).addParameterProcessorGenerator(new ExplodedObjectParameterProcessorGenerator()).addParameterProcessorGenerator(new ExplodedSimpleObjectParameterProcessorGenerator()).addParameterProcessorGenerator(new JsonParameterProcessorGenerator()).addParameterProcessorGenerator(new DefaultParameterProcessorGenerator());
        this.validationHandlerGenerator.addBodyProcessorGenerator(new JsonBodyProcessorGenerator()).addBodyProcessorGenerator(new UrlEncodedFormBodyProcessorGenerator()).addBodyProcessorGenerator(new MultipartFormBodyProcessorGenerator());
        this.operations = new LinkedHashMap<String, OperationImpl>();
        this.securityHandlers = new AuthenticationHandlersStore();
        spec.solveIfNeeded(spec.getOpenAPI().getJsonObject("paths")).forEach(pathEntry -> {
            if (((String)pathEntry.getKey()).startsWith("x-")) {
                return;
            }
            JsonObject pathModel = spec.solveIfNeeded((JsonObject)pathEntry.getValue());
            Stream.of("get", "put", "post", "delete", "options", "head", "patch", "trace").filter(arg_0 -> ((JsonObject)pathModel).containsKey(arg_0)).forEach(verb -> {
                JsonObject operationModel = spec.solveIfNeeded(pathModel.getJsonObject(verb));
                this.operations.put(operationModel.getString("operationId"), new OperationImpl(operationModel.getString("operationId"), HttpMethod.valueOf((String)verb.toUpperCase()), (String)pathEntry.getKey(), operationModel, pathModel, spec.getInitialScope(), this.openapi));
            });
        });
    }

    @Override
    public RouterBuilder setOptions(RouterBuilderOptions options) {
        Objects.requireNonNull(options);
        this.options = options;
        return this;
    }

    @Override
    public RouterBuilderOptions getOptions() {
        return this.options;
    }

    @Override
    public OpenAPIHolder getOpenAPI() {
        return this.openapi;
    }

    @Override
    public SchemaRouter getSchemaRouter() {
        return this.schemaRouter;
    }

    @Override
    public SchemaParser getSchemaParser() {
        return this.schemaParser;
    }

    @Override
    public RouterBuilder serviceExtraPayloadMapper(Function<RoutingContext, JsonObject> serviceExtraPayloadMapper) {
        this.serviceExtraPayloadMapper = serviceExtraPayloadMapper;
        return this;
    }

    @Override
    public SecurityScheme securityHandler(String securitySchemeName) {
        return new SecuritySchemeImpl(this, securitySchemeName);
    }

    @Override
    public RouterBuilder securityHandler(String securitySchemaName, AuthenticationHandler handler) {
        Objects.requireNonNull(securitySchemaName);
        Objects.requireNonNull(handler);
        this.securityHandlers.addAuthnRequirement(securitySchemaName, handler);
        return this;
    }

    @Override
    public List<Operation> operations() {
        return this.operations.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public Operation operation(String operationId) {
        Objects.requireNonNull(operationId);
        if (!this.operations.containsKey(operationId)) {
            throw new IllegalArgumentException("Cannot find the operation " + operationId);
        }
        return this.operations.get(operationId);
    }

    @Override
    public RouterBuilder bodyHandler(BodyHandler bodyHandler) {
        this.bodyHandler = bodyHandler;
        return this;
    }

    @Override
    public RouterBuilder rootHandler(Handler<RoutingContext> rootHandler) {
        this.globalHandlers.add(rootHandler);
        return this;
    }

    @Override
    public RouterBuilder mountServiceInterface(Class interfaceClass, String address) {
        for (Method m : interfaceClass.getMethods()) {
            String methodName;
            OperationImpl op;
            if (!OpenAPI3Utils.serviceProxyMethodIsCompatibleHandler(m) || (op = Optional.ofNullable(this.operations.get(methodName = m.getName())).orElseGet(() -> this.operations.entrySet().stream().filter(e -> OpenAPI3Utils.sanitizeOperationId((String)e.getKey()).equals(methodName)).map(Map.Entry::getValue).findFirst().orElse(null))) == null) continue;
            op.mountRouteToService(address, methodName);
        }
        return this;
    }

    @Override
    public RouterBuilder mountServicesFromExtensions() {
        for (Map.Entry<String, OperationImpl> opEntry : this.operations.entrySet()) {
            OperationImpl operation = opEntry.getValue();
            Object extensionVal = OpenAPI3Utils.getAndMergeServiceExtension(OPENAPI_EXTENSION, OPENAPI_EXTENSION_ADDRESS, OPENAPI_EXTENSION_METHOD_NAME, operation.getPathModel(), operation.getOperationModel());
            if (extensionVal == null) continue;
            if (extensionVal instanceof String) {
                operation.mountRouteToService((String)extensionVal, opEntry.getKey());
                continue;
            }
            if (extensionVal instanceof JsonObject) {
                JsonObject extensionMap = (JsonObject)extensionVal;
                String address = extensionMap.getString(OPENAPI_EXTENSION_ADDRESS);
                String methodName = extensionMap.getString(OPENAPI_EXTENSION_METHOD_NAME);
                JsonObject sanitizedMap = OpenAPI3Utils.sanitizeDeliveryOptionsExtension(extensionMap);
                if (address == null) {
                    throw RouterBuilderException.createWrongExtension("Extension x-vertx-event-bus must define address");
                }
                if (methodName == null) {
                    operation.mountRouteToService(address, opEntry.getKey(), new DeliveryOptions(sanitizedMap));
                    continue;
                }
                operation.mountRouteToService(address, methodName, new DeliveryOptions(sanitizedMap));
                continue;
            }
            throw RouterBuilderException.createWrongExtension("Extension x-vertx-event-bus must be or string or a JsonObject");
        }
        return this;
    }

    @Override
    public Router createRouter() {
        Router router = Router.router((Vertx)this.vertx);
        Route globalRoute = router.route();
        if (this.bodyHandler != null) {
            globalRoute.handler((Handler)this.bodyHandler);
        }
        this.globalHandlers.forEach(arg_0 -> ((Route)globalRoute).handler(arg_0));
        for (OperationImpl operation : this.operations.values()) {
            if (!this.options.isMountNotImplementedHandler() && !operation.isConfigured()) continue;
            ArrayList<Object> handlersToLoad = new ArrayList<Object>();
            ArrayList<Handler<RoutingContext>> failureHandlersToLoad = new ArrayList<Handler<RoutingContext>>();
            AuthenticationHandler authnHandler = this.securityHandlers.solveAuthenticationHandler(OpenAPI3Utils.mergeSecurityRequirements(this.openapi.getOpenAPI().getJsonArray("security"), operation.getOperationModel().getJsonArray("security")), this.options.isRequireSecurityHandlers());
            if (authnHandler != null) {
                handlersToLoad.add(authnHandler);
            }
            ValidationHandlerImpl validationHandler = this.validationHandlerGenerator.create(operation);
            handlersToLoad.add(validationHandler);
            if (operation.isConfigured()) {
                handlersToLoad.addAll(operation.getUserHandlers());
                failureHandlersToLoad.addAll(operation.getUserFailureHandlers());
                if (operation.mustMountRouteToService()) {
                    try {
                        RouteToEBServiceHandler routeToEBServiceHandler = operation.getEbServiceDeliveryOptions() != null ? RouteToEBServiceHandler.build((EventBus)this.vertx.eventBus(), (String)operation.getEbServiceAddress(), (String)operation.getEbServiceMethodName(), (DeliveryOptions)operation.getEbServiceDeliveryOptions()) : RouteToEBServiceHandler.build((EventBus)this.vertx.eventBus(), (String)operation.getEbServiceAddress(), (String)operation.getEbServiceMethodName());
                        routeToEBServiceHandler.extraPayloadMapper(this.serviceExtraPayloadMapper);
                        handlersToLoad.add(routeToEBServiceHandler);
                    }
                    catch (NoClassDefFoundError exception) {
                        throw new IllegalStateException("You're trying to use api service without adding it to your classpath. Check you have included vertx-web-api-service in your dependencies", exception);
                    }
                }
            } else {
                List<HttpMethod> configuredMethodsForThisPath = this.operations.values().stream().filter(ov -> operation.getOpenAPIPath().equals(ov.getOpenAPIPath())).filter(OperationImpl::isConfigured).map(OperationImpl::getHttpMethod).collect(Collectors.toList());
                if (!configuredMethodsForThisPath.isEmpty()) {
                    handlersToLoad.add(OpenAPI3RouterBuilderImpl.generateNotAllowedHandler(configuredMethodsForThisPath));
                } else {
                    handlersToLoad.add(NOT_IMPLEMENTED_HANDLER);
                }
            }
            OpenAPI3PathResolver pathResolver = new OpenAPI3PathResolver(operation.getOpenAPIPath(), new ArrayList<JsonObject>(operation.getParameters().values()), this.openapi);
            Route route = pathResolver.solve().map(solvedRegex -> router.routeWithRegex(operation.getHttpMethod(), solvedRegex.toString())).orElseGet(() -> router.route(operation.getHttpMethod(), operation.getOpenAPIPath())).setName(this.options.getRouteNamingStrategy().apply(operation));
            String exposeConfigurationKey = this.getOptions().getOperationModelKey();
            if (exposeConfigurationKey != null) {
                route.handler(context -> context.put(exposeConfigurationKey, (Object)operation.getOperationModel()).next());
            }
            Set consumes = ((JsonObject)JsonPointer.from((String)"/requestBody/content").queryJsonOrDefault((Object)operation.getOperationModel(), (Object)new JsonObject())).fieldNames();
            Set produces = operation.getOperationModel().getJsonObject("responses", new JsonObject()).stream().map(Map.Entry::getValue).map(j -> (JsonObject)j).flatMap(j -> j.getJsonObject("content", new JsonObject()).fieldNames().stream()).collect(Collectors.toSet());
            for (String string : produces) {
                route.produces(string);
            }
            if (!consumes.isEmpty()) {
                ((RouteImpl)route).setEmptyBodyPermittedWithConsumes(!validationHandler.isBodyRequired());
            }
            if (this.options.isMountResponseContentTypeHandler() && produces.size() != 0) {
                route.handler((Handler)ResponseContentTypeHandler.create());
            }
            route.setRegexGroupsNames(new ArrayList<String>(pathResolver.getMappedGroups().values()));
            for (Handler handler : handlersToLoad) {
                route.handler(handler);
            }
            for (Handler handler : failureHandlersToLoad) {
                route.failureHandler(handler);
            }
        }
        if (this.options.getContractEndpoint() != null) {
            router.get(this.options.getContractEndpoint()).handler((Handler)ContractEndpointHandler.create(this.openapi));
        }
        return router;
    }
}

