/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.openapi.RouterBuilder;
import io.vertx.ext.web.openapi.SecurityScheme;
import java.util.function.Function;

public class SecuritySchemeImpl
implements SecurityScheme {
    private final RouterBuilder routerBuilder;
    private final String securitySchemeId;

    SecuritySchemeImpl(RouterBuilder routerBuilder, String securitySchemeId) {
        this.routerBuilder = routerBuilder;
        this.securitySchemeId = securitySchemeId;
    }

    @Override
    public RouterBuilder bindBlocking(Function<JsonObject, AuthenticationHandler> factory) {
        JsonObject securitySchemes = this.routerBuilder.getOpenAPI().getCached(JsonPointer.from((String)"/components/securitySchemes"));
        if (securitySchemes != null && securitySchemes.containsKey(this.securitySchemeId)) {
            this.routerBuilder.securityHandler(this.securitySchemeId, factory.apply(securitySchemes.getJsonObject(this.securitySchemeId)));
            return this.routerBuilder;
        }
        throw new IllegalStateException("OpenAPI does not contain securityScheme: " + this.securitySchemeId);
    }

    @Override
    public Future<RouterBuilder> bind(Function<JsonObject, Future<AuthenticationHandler>> factory) {
        JsonObject securitySchemes = this.routerBuilder.getOpenAPI().getCached(JsonPointer.from((String)"/components/securitySchemes"));
        if (securitySchemes != null && securitySchemes.containsKey(this.securitySchemeId)) {
            return factory.apply(securitySchemes.getJsonObject(this.securitySchemeId)).onSuccess(handler -> this.routerBuilder.securityHandler(this.securitySchemeId, (AuthenticationHandler)handler)).mapEmpty();
        }
        return Future.failedFuture((String)("OpenAPI does not contain securityScheme: " + this.securitySchemeId));
    }
}

