/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.openapi.impl.BodyProcessorGenerator;
import io.vertx.ext.web.openapi.impl.GeneratorContext;
import io.vertx.ext.web.openapi.impl.OpenAPI3Utils;
import io.vertx.ext.web.openapi.impl.SchemaHolder;
import io.vertx.ext.web.validation.RequestPredicate;
import io.vertx.ext.web.validation.RequestPredicateResult;
import io.vertx.ext.web.validation.impl.ValueParserInferenceUtils;
import io.vertx.ext.web.validation.impl.body.BodyProcessor;
import io.vertx.ext.web.validation.impl.body.FormBodyProcessorImpl;
import io.vertx.ext.web.validation.impl.body.FormValueParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.impl.validator.ValueValidator;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;

public class MultipartFormBodyProcessorGenerator
implements BodyProcessorGenerator {
    @Override
    public boolean canGenerate(String mediaTypeName, JsonObject mediaTypeObject) {
        return mediaTypeName.equals("multipart/form-data");
    }

    @Override
    public BodyProcessor generate(String mediaTypeName, JsonObject mediaTypeObject, JsonPointer mediaTypePointer, GeneratorContext context) {
        SchemaHolder schemas = context.getSchemaHolder(mediaTypeObject.getJsonObject("schema", new JsonObject()), mediaTypePointer.copy().append("schema"));
        Map propertiesValueParsers = ValueParserInferenceUtils.infeerPropertiesFormValueParserForObjectSchema((Object)schemas.getFakeSchema());
        Map patternPropertiesValueParsers = ValueParserInferenceUtils.infeerPatternPropertiesFormValueParserForObjectSchema((Object)schemas.getFakeSchema());
        ValueParser additionalPropertiesValueParser = ValueParserInferenceUtils.infeerAdditionalPropertiesFormValueParserForObjectSchema((Object)schemas.getFakeSchema());
        for (Map.Entry pe : schemas.getFakeSchema().getJsonObject("properties", new JsonObject())) {
            JsonObject propSchema = (JsonObject)pe.getValue();
            String encoding = (String)JsonPointer.create().append("encoding").append((String)pe.getKey()).append("contentType").queryJson((Object)mediaTypeObject);
            if (encoding == null) {
                if (OpenAPI3Utils.isSchemaObjectOrCombinators(propSchema) || OpenAPI3Utils.isSchemaArray(propSchema) && OpenAPI3Utils.isSchemaObjectOrAllOfType(propSchema.getJsonObject("items", new JsonObject()))) {
                    propertiesValueParsers.put(pe.getKey(), new FormValueParser(false, ValueParser.JSON_PARSER));
                    continue;
                }
                if (!"string".equals(propSchema.getString("type")) || !"binary".equals(propSchema.getString("format")) && !"base64".equals(propSchema.getString("format"))) continue;
                context.addPredicate((Function<RoutingContext, RequestPredicateResult>)RequestPredicate.multipartFileUploadExists((String)((String)pe.getKey()), (String)Pattern.quote("application/octet-stream")));
                propertiesValueParsers.remove(pe.getKey());
                this.searchPropAndRemoveInSchema(schemas.getNormalizedSchema(), (String)pe.getKey());
                continue;
            }
            context.addPredicate((Function<RoutingContext, RequestPredicateResult>)RequestPredicate.multipartFileUploadExists((String)((String)pe.getKey()), (String)OpenAPI3Utils.resolveContentTypeRegex(encoding)));
            propertiesValueParsers.remove(pe.getKey());
            this.searchPropAndRemoveInSchema(schemas.getNormalizedSchema(), (String)pe.getKey());
        }
        return new FormBodyProcessorImpl(propertiesValueParsers, patternPropertiesValueParsers, additionalPropertiesValueParser, mediaTypeName, (ValueValidator)schemas.getValidator());
    }

    private void searchPropAndRemoveInSchema(JsonObject object, String propName) {
        if (object.containsKey("allOf") || object.containsKey("anyOf") || object.containsKey("oneOf")) {
            object.getJsonArray("allOf", object.getJsonArray("anyOf", object.getJsonArray("oneOf"))).forEach(j -> this.searchPropAndRemoveInSchema((JsonObject)j, propName));
        } else {
            if (object.containsKey("properties")) {
                object.getJsonObject("properties").remove(propName);
            }
            if (object.containsKey("required")) {
                object.getJsonArray("required").remove((Object)propName);
            }
        }
    }
}

