/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.openapi.OpenAPILoaderOptionsConverter;
import io.vertx.json.schema.SchemaRouterOptions;
import java.util.HashMap;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class OpenAPILoaderOptions {
    private Map<String, String> authQueryParams;
    private Map<String, String> authHeaders;

    public OpenAPILoaderOptions() {
        this.authHeaders = new HashMap<String, String>();
        this.authQueryParams = new HashMap<String, String>();
    }

    public OpenAPILoaderOptions(JsonObject obj) {
        OpenAPILoaderOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)obj, this);
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        OpenAPILoaderOptionsConverter.toJson(this, obj);
        return obj;
    }

    @Fluent
    public OpenAPILoaderOptions putAuthHeader(String headerName, String headerValue) {
        this.authHeaders.put(headerName, headerValue);
        return this;
    }

    @Fluent
    public OpenAPILoaderOptions putAuthQueryParam(String queryParamName, String queryParamValue) {
        this.authQueryParams.put(queryParamName, queryParamValue);
        return this;
    }

    public Map<String, String> getAuthQueryParams() {
        return this.authQueryParams;
    }

    public Map<String, String> getAuthHeaders() {
        return this.authHeaders;
    }

    @GenIgnore
    public SchemaRouterOptions toSchemaRouterOptions() {
        SchemaRouterOptions opt = new SchemaRouterOptions();
        this.authHeaders.forEach((arg_0, arg_1) -> ((SchemaRouterOptions)opt).putAuthHeader(arg_0, arg_1));
        this.authQueryParams.forEach((arg_0, arg_1) -> ((SchemaRouterOptions)opt).putAuthQueryParam(arg_0, arg_1));
        return opt;
    }
}

