/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.openapi.OpenAPIHolder;
import io.vertx.ext.web.openapi.Operation;
import io.vertx.ext.web.openapi.impl.OpenAPI3Utils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OperationImpl
implements Operation {
    private String operationId;
    private HttpMethod method;
    private String path;
    private JsonObject pathModel;
    private JsonObject operationModel;
    private JsonPointer operationPointer;
    private Map<JsonPointer, JsonObject> parameters;
    private List<String> tags;
    private List<Handler<RoutingContext>> userHandlers;
    private List<Handler<RoutingContext>> userFailureHandlers;
    private String ebServiceAddress;
    private String ebServiceMethodName;
    private DeliveryOptions ebServiceDeliveryOptions;

    protected OperationImpl(String operationId, HttpMethod method, String path, JsonObject operationModel, JsonObject pathModel, URI specScope, OpenAPIHolder holder) {
        JsonObject parameterModel;
        int i;
        this.operationId = operationId;
        this.method = method;
        this.path = path;
        this.pathModel = pathModel;
        this.operationModel = operationModel;
        this.tags = operationModel.getJsonArray("tags", new JsonArray()).stream().map(Object::toString).collect(Collectors.toList());
        JsonPointer pathPointer = JsonPointer.fromURI((URI)specScope).append("paths").append(path);
        this.operationPointer = pathPointer.copy().append(method.name().toLowerCase());
        this.parameters = new HashMap<JsonPointer, JsonObject>();
        JsonArray operationParameters = operationModel.getJsonArray("parameters", new JsonArray());
        JsonArray pathParameters = pathModel.getJsonArray("parameters", new JsonArray());
        for (i = 0; i < operationParameters.size(); ++i) {
            parameterModel = holder.solveIfNeeded(operationParameters.getJsonObject(i));
            JsonPointer parameterPointer = this.operationPointer.copy().append("parameters").append(i);
            this.parameters.put(parameterPointer, parameterModel);
        }
        for (i = 0; i < pathParameters.size(); ++i) {
            parameterModel = holder.solveIfNeeded(pathParameters.getJsonObject(i));
            String paramName = parameterModel.getString("name");
            String paramIn = parameterModel.getString("in");
            if (!this.parameters.values().stream().noneMatch(j -> j.getString("in").equalsIgnoreCase(paramIn) && j.getString("name").equals(paramName))) continue;
            this.parameters.put(pathPointer.copy().append(i), parameterModel);
        }
        this.userHandlers = new ArrayList<Handler<RoutingContext>>();
        this.userFailureHandlers = new ArrayList<Handler<RoutingContext>>();
    }

    @Override
    public Operation handler(Handler<RoutingContext> handler) {
        this.userHandlers.add(handler);
        return this;
    }

    @Override
    public Operation failureHandler(Handler<RoutingContext> handler) {
        this.userFailureHandlers.add(handler);
        return this;
    }

    @Override
    public Operation routeToEventBus(String address) {
        this.mountRouteToService(address);
        return this;
    }

    @Override
    public Operation routeToEventBus(String address, DeliveryOptions options) {
        this.mountRouteToService(address, options);
        return this;
    }

    @Override
    public String getOperationId() {
        return this.operationId;
    }

    @Override
    public JsonObject getOperationModel() {
        return this.operationModel;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.method;
    }

    @Override
    public String getOpenAPIPath() {
        return this.path;
    }

    protected JsonPointer getPointer() {
        return this.operationPointer.copy();
    }

    protected Map<JsonPointer, JsonObject> getParameters() {
        return this.parameters;
    }

    protected JsonObject getPathModel() {
        return this.pathModel;
    }

    protected List<Handler<RoutingContext>> getUserHandlers() {
        return this.userHandlers;
    }

    protected List<Handler<RoutingContext>> getUserFailureHandlers() {
        return this.userFailureHandlers;
    }

    protected boolean isConfigured() {
        return this.userHandlers.size() != 0 || this.mustMountRouteToService();
    }

    protected List<String> getTags() {
        return this.tags;
    }

    protected boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    protected void mountRouteToService(String address) {
        this.ebServiceAddress = address;
        this.ebServiceMethodName = OpenAPI3Utils.sanitizeOperationId(this.operationId);
    }

    protected void mountRouteToService(String address, String methodName) {
        this.ebServiceAddress = address;
        this.ebServiceMethodName = OpenAPI3Utils.sanitizeOperationId(methodName);
    }

    protected void mountRouteToService(String address, DeliveryOptions deliveryOptions) {
        this.ebServiceAddress = address;
        this.ebServiceMethodName = OpenAPI3Utils.sanitizeOperationId(this.operationId);
        this.ebServiceDeliveryOptions = deliveryOptions;
    }

    protected void mountRouteToService(String address, String methodName, DeliveryOptions deliveryOptions) {
        this.ebServiceAddress = address;
        this.ebServiceMethodName = OpenAPI3Utils.sanitizeOperationId(methodName);
        this.ebServiceDeliveryOptions = deliveryOptions;
    }

    protected boolean mustMountRouteToService() {
        return this.ebServiceAddress != null;
    }

    protected String getEbServiceAddress() {
        return this.ebServiceAddress;
    }

    protected String getEbServiceMethodName() {
        return this.ebServiceMethodName;
    }

    protected DeliveryOptions getEbServiceDeliveryOptions() {
        return this.ebServiceDeliveryOptions;
    }
}

