/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.cookie.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.cookie.CookieSessionStore;
import io.vertx.ext.web.sstore.cookie.impl.CookieSession;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.spec.SecretKeySpec;

public class CookieSessionStoreImpl
implements CookieSessionStore {
    private static final String SHA_CRYPT = "SHA-256";
    private static final String AES_ALGORITHM = "AES";
    private SecretKeySpec aesKey;
    private VertxContextPRNG random;
    private ContextInternal ctx;

    public CookieSessionStoreImpl() {
    }

    public CookieSessionStoreImpl(Vertx vertx, String secret) {
        this.init(vertx, new JsonObject().put("secret", (Object)secret));
    }

    public SessionStore init(Vertx vertx, JsonObject options) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.ctx = (ContextInternal)vertx.getOrCreateContext();
        Objects.requireNonNull(options.getValue("secret"), "secret must be set");
        try {
            MessageDigest sha256 = MessageDigest.getInstance(SHA_CRYPT);
            byte[] keyBytes = sha256.digest(options.getString("secret").getBytes(StandardCharsets.UTF_8));
            this.aesKey = new SecretKeySpec(keyBytes, AES_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public long retryTimeout() {
        return -1L;
    }

    public Session createSession(long timeout) {
        return new CookieSession(this.aesKey, this.random, timeout, 16);
    }

    public Session createSession(long timeout, int length) {
        return new CookieSession(this.aesKey, this.random, timeout, length);
    }

    public Future<@Nullable Session> get(String cookieValue) {
        try {
            CookieSession session = new CookieSession(this.aesKey, this.random).setValue(cookieValue);
            if (session == null) {
                return this.ctx.succeededFuture();
            }
            long now = System.currentTimeMillis();
            if (now - session.lastAccessed() > session.timeout()) {
                return this.ctx.succeededFuture();
            }
            return this.ctx.succeededFuture((Object)session);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    public Future<Void> delete(String id) {
        return this.ctx.succeededFuture();
    }

    public Future<Void> put(Session session) {
        CookieSession cookieSession = (CookieSession)session;
        if (cookieSession.oldVersion() != -1 && cookieSession.oldVersion() != cookieSession.version()) {
            return Future.failedFuture((String)"Session version mismatch");
        }
        cookieSession.incrementVersion();
        return this.ctx.succeededFuture();
    }

    public Future<Void> clear() {
        return this.ctx.succeededFuture();
    }

    public Future<Integer> size() {
        return this.ctx.succeededFuture((Object)0);
    }

    public void close() {
    }
}

