/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.freemarker.impl;

import freemarker.cache.NullCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.template.CachedTemplate;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine;
import io.vertx.ext.web.templ.freemarker.impl.FreeMarkerTemplateLoader;
import io.vertx.ext.web.templ.freemarker.impl.VertxWebObjectWrapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import java.util.Map;

public class FreeMarkerTemplateEngineImpl
extends CachingTemplateEngine<Template>
implements FreeMarkerTemplateEngine {
    private final Configuration config = new Configuration(Configuration.VERSION_2_3_29);

    public FreeMarkerTemplateEngineImpl(Vertx vertx, String extension) {
        super(vertx, extension);
        this.config.setObjectWrapper(new VertxWebObjectWrapper(this.config.getIncompatibleImprovements()));
        this.config.setTemplateLoader(new FreeMarkerTemplateLoader(vertx));
        this.config.setCacheStorage(new NullCacheStorage());
    }

    public <T> T unwrap() {
        return (T)this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Buffer> render(Map<String, Object> context, String templateFile) {
        Future future;
        Locale locale = context.containsKey("lang") ? Locale.forLanguageTag((String)context.get("lang")) : Locale.getDefault();
        String src = this.adjustLocation(templateFile);
        String key = src + "_" + locale.toLanguageTag();
        CachedTemplate template = this.getTemplate(key);
        if (template == null) {
            FreeMarkerTemplateEngineImpl freeMarkerTemplateEngineImpl = this;
            synchronized (freeMarkerTemplateEngineImpl) {
                template = new CachedTemplate((Object)this.config.getTemplate(src, locale));
            }
            this.putTemplate(key, template);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ((Template)template.template()).process(context, new OutputStreamWriter(baos));
            future = Future.succeededFuture((Object)Buffer.buffer((byte[])baos.toByteArray()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return Future.failedFuture((Throwable)ex);
            }
        }
        baos.close();
        return future;
    }
}

