/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.handlebars.impl;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Utils;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.common.template.impl.TemplateHolder;
import io.vertx.ext.web.templ.handlebars.HandlebarsTemplateEngine;
import io.vertx.ext.web.templ.handlebars.impl.JsonArrayValueResolver;
import io.vertx.ext.web.templ.handlebars.impl.JsonObjectValueResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class HandlebarsTemplateEngineImpl
extends CachingTemplateEngine<Template>
implements HandlebarsTemplateEngine {
    private static final List<ValueResolver> VALUE_RESOLVERS_LIST = ValueResolver.defaultValueResolvers();
    private static final ValueResolver[] VALUE_RESOLVERS = VALUE_RESOLVERS_LIST.toArray(new ValueResolver[VALUE_RESOLVERS_LIST.size()]);
    private final Handlebars handlebars;
    private final Loader loader;
    private ValueResolver[] resolvers;

    public HandlebarsTemplateEngineImpl(Vertx vertx, String extension) {
        super(vertx, extension);
        this.loader = new Loader(vertx);
        this.resolvers = new ValueResolver[VALUE_RESOLVERS.length + 2];
        this.resolvers[0] = JsonArrayValueResolver.INSTANCE;
        this.resolvers[1] = JsonObjectValueResolver.INSTANCE;
        System.arraycopy(VALUE_RESOLVERS, 0, this.resolvers, 2, VALUE_RESOLVERS.length);
        this.handlebars = new Handlebars(this.loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<String, Object> context, String templateFile, Handler<AsyncResult<Buffer>> handler) {
        try {
            String src = this.adjustLocation(templateFile);
            TemplateHolder template = this.getTemplate(src);
            if (template == null) {
                int idx = HandlebarsTemplateEngineImpl.findLastFileSeparator(src);
                String prefix = "";
                String basename = src;
                if (idx != -1) {
                    prefix = src.substring(0, idx);
                    basename = src.substring(idx + 1);
                }
                HandlebarsTemplateEngineImpl handlebarsTemplateEngineImpl = this;
                synchronized (handlebarsTemplateEngineImpl) {
                    this.loader.setPrefix(prefix);
                    template = new TemplateHolder((Object)this.handlebars.compile(basename), prefix);
                }
                this.putTemplate(src, template);
            }
            Context engineContext = Context.newBuilder(context).resolver(this.getResolvers()).build();
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)((Template)template.template()).apply(engineContext))));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    private static int findLastFileSeparator(String src) {
        if (Utils.isWindows()) {
            return Math.max(src.lastIndexOf(47), src.lastIndexOf(92));
        }
        return src.lastIndexOf(47);
    }

    public <T> T unwrap() {
        return (T)this.handlebars;
    }

    @Override
    public Handlebars getHandlebars() {
        return this.handlebars;
    }

    @Override
    public ValueResolver[] getResolvers() {
        return this.resolvers;
    }

    @Override
    public HandlebarsTemplateEngine setResolvers(ValueResolver ... resolvers) {
        this.resolvers = resolvers;
        return this;
    }

    private class Loader
    implements TemplateLoader {
        private final Vertx vertx;
        private String templateDirectory;
        private Charset charset = Charset.defaultCharset();

        Loader(Vertx vertx) {
            this.vertx = vertx;
        }

        @Override
        public TemplateSource sourceAt(String location) throws IOException {
            final String loc = this.resolve(location);
            if (!this.vertx.fileSystem().existsBlocking(loc)) {
                throw new FileNotFoundException(loc);
            }
            final Buffer templ = this.vertx.fileSystem().readFileBlocking(loc);
            if (templ == null) {
                throw new IOException("Cannot read resource " + loc);
            }
            final long lastMod = System.currentTimeMillis();
            return new TemplateSource(){

                @Override
                public String content(Charset charset) {
                    return templ.toString(charset);
                }

                @Override
                public String filename() {
                    return loc;
                }

                @Override
                public long lastModified() {
                    return lastMod;
                }
            };
        }

        @Override
        public String resolve(String location) {
            return this.templateDirectory + "/" + HandlebarsTemplateEngineImpl.this.adjustLocation(location);
        }

        @Override
        public String getPrefix() {
            return this.templateDirectory;
        }

        @Override
        public String getSuffix() {
            return HandlebarsTemplateEngineImpl.this.extension;
        }

        @Override
        public void setPrefix(String prefix) {
            this.templateDirectory = prefix;
        }

        @Override
        public void setSuffix(String suffix) {
            HandlebarsTemplateEngineImpl.this.extension = suffix;
        }

        @Override
        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }
    }
}

