/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.jade.impl;

import de.neuland.jade4j.JadeConfiguration;
import de.neuland.jade4j.template.JadeTemplate;
import de.neuland.jade4j.template.TemplateLoader;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.templ.jade.JadeTemplateEngine;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Map;

public class JadeTemplateEngineImpl
extends CachingTemplateEngine<JadeTemplate>
implements JadeTemplateEngine {
    private final JadeConfiguration config = new JadeConfiguration();

    public JadeTemplateEngineImpl(Vertx vertx) {
        super("jade", 10000);
        this.config.setTemplateLoader(new JadeTemplateLoader(vertx));
        this.config.setCaching(false);
    }

    @Override
    public JadeTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public JadeTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<String, Object> context, String templateFile, Handler<AsyncResult<Buffer>> handler) {
        try {
            JadeTemplate template;
            JadeTemplate jadeTemplate = template = this.isCachingEnabled() ? (JadeTemplate)this.cache.get((Object)templateFile) : null;
            if (template == null) {
                JadeTemplateEngineImpl jadeTemplateEngineImpl = this;
                synchronized (jadeTemplateEngineImpl) {
                    template = this.config.getTemplate(templateFile);
                }
                if (this.isCachingEnabled()) {
                    this.cache.put((Object)templateFile, (Object)template);
                }
            }
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)this.config.renderTemplate(template, context))));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    @Override
    public JadeConfiguration getJadeConfiguration() {
        return this.config;
    }

    private class JadeTemplateLoader
    implements TemplateLoader {
        private final Vertx vertx;
        private long lastMod = System.currentTimeMillis();

        JadeTemplateLoader(Vertx vertx) {
            this.vertx = vertx;
        }

        @Override
        public long getLastModified(String name) {
            return this.lastMod;
        }

        @Override
        public String getExtension() {
            return "jade";
        }

        @Override
        public Reader getReader(String name) throws IOException {
            name = JadeTemplateEngineImpl.this.adjustLocation(name.endsWith(".jade") ? name.substring(0, name.length() - 5) : name);
            String templ = null;
            if (this.vertx.fileSystem().existsBlocking(name)) {
                templ = this.vertx.fileSystem().readFileBlocking(name).toString(Charset.defaultCharset());
            }
            if (templ == null) {
                throw new IOException("Cannot find resource " + name);
            }
            return new StringReader(templ);
        }
    }
}

