/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.lexer;

import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.exceptions.JadeLexerException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.lexer.Assignment;
import de.neuland.jade4j.lexer.Each;
import de.neuland.jade4j.lexer.Scanner;
import de.neuland.jade4j.lexer.token.AttributeList;
import de.neuland.jade4j.lexer.token.AttributesBlock;
import de.neuland.jade4j.lexer.token.Block;
import de.neuland.jade4j.lexer.token.BlockCode;
import de.neuland.jade4j.lexer.token.Call;
import de.neuland.jade4j.lexer.token.CaseToken;
import de.neuland.jade4j.lexer.token.Colon;
import de.neuland.jade4j.lexer.token.Comment;
import de.neuland.jade4j.lexer.token.CssClass;
import de.neuland.jade4j.lexer.token.CssId;
import de.neuland.jade4j.lexer.token.Default;
import de.neuland.jade4j.lexer.token.Doctype;
import de.neuland.jade4j.lexer.token.Dot;
import de.neuland.jade4j.lexer.token.Else;
import de.neuland.jade4j.lexer.token.ElseIf;
import de.neuland.jade4j.lexer.token.Eos;
import de.neuland.jade4j.lexer.token.Expression;
import de.neuland.jade4j.lexer.token.ExtendsToken;
import de.neuland.jade4j.lexer.token.Filter;
import de.neuland.jade4j.lexer.token.If;
import de.neuland.jade4j.lexer.token.Include;
import de.neuland.jade4j.lexer.token.Indent;
import de.neuland.jade4j.lexer.token.Interpolation;
import de.neuland.jade4j.lexer.token.Mixin;
import de.neuland.jade4j.lexer.token.MixinBlock;
import de.neuland.jade4j.lexer.token.Newline;
import de.neuland.jade4j.lexer.token.Outdent;
import de.neuland.jade4j.lexer.token.PipelessText;
import de.neuland.jade4j.lexer.token.Tag;
import de.neuland.jade4j.lexer.token.Text;
import de.neuland.jade4j.lexer.token.Token;
import de.neuland.jade4j.lexer.token.When;
import de.neuland.jade4j.lexer.token.While;
import de.neuland.jade4j.lexer.token.Yield;
import de.neuland.jade4j.template.TemplateLoader;
import de.neuland.jade4j.util.CharacterParser;
import de.neuland.jade4j.util.Options;
import de.neuland.jade4j.util.StringReplacer;
import de.neuland.jade4j.util.StringReplacerCallback;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class Lexer {
    private static final Pattern cleanRe = Pattern.compile("^['\"]|['\"]$");
    private static final Pattern doubleQuotedRe = Pattern.compile("^\"[^\"]*\"$");
    private static final Pattern quotedRe = Pattern.compile("^'[^']*'$");
    private LinkedList<String> options;
    Scanner scanner;
    private LinkedList<Token> deferredTokens;
    private int lastIndents = -1;
    private int lineno;
    private LinkedList<Token> stash;
    private LinkedList<Integer> indentStack;
    private String indentRe = null;
    private boolean pipeless = false;
    private boolean attributeMode;
    private final String filename;
    private final TemplateLoader templateLoader;
    private String indentType;
    private CharacterParser characterParser;
    private ExpressionHandler expressionHandler;

    public Lexer(String filename, TemplateLoader templateLoader, ExpressionHandler expressionHandler) throws IOException {
        this.expressionHandler = expressionHandler;
        this.filename = this.ensureJadeExtension(filename);
        this.templateLoader = templateLoader;
        Reader reader = templateLoader.getReader(this.filename);
        this.options = new LinkedList();
        this.scanner = new Scanner(reader);
        this.deferredTokens = new LinkedList();
        this.stash = new LinkedList();
        this.indentStack = new LinkedList();
        this.lastIndents = 0;
        this.lineno = 1;
        this.characterParser = new CharacterParser();
    }

    public Lexer(String input, String filename, TemplateLoader templateLoader, ExpressionHandler expressionHandler) throws IOException {
        this.expressionHandler = expressionHandler;
        this.filename = this.ensureJadeExtension(filename);
        this.templateLoader = templateLoader;
        Reader reader = templateLoader.getReader(this.filename);
        this.options = new LinkedList();
        this.scanner = new Scanner(input);
        this.deferredTokens = new LinkedList();
        this.stash = new LinkedList();
        this.indentStack = new LinkedList();
        this.lastIndents = 0;
        this.lineno = 1;
        this.characterParser = new CharacterParser();
    }

    public Token next() {
        Token token = this.deferred();
        if (token != null) {
            return token;
        }
        token = this.blank();
        if (token != null) {
            return token;
        }
        token = this.eos();
        if (token != null) {
            return token;
        }
        token = this.pipelessText();
        if (token != null) {
            return token;
        }
        token = this.yield();
        if (token != null) {
            return token;
        }
        token = this.doctype();
        if (token != null) {
            return token;
        }
        token = this.interpolation();
        if (token != null) {
            return token;
        }
        token = this.caseToken();
        if (token != null) {
            return token;
        }
        token = this.when();
        if (token != null) {
            return token;
        }
        token = this.defaultToken();
        if (token != null) {
            return token;
        }
        token = this.extendsToken();
        if (token != null) {
            return token;
        }
        token = this.append();
        if (token != null) {
            return token;
        }
        token = this.prepend();
        if (token != null) {
            return token;
        }
        token = this.block();
        if (token != null) {
            return token;
        }
        token = this.mixinBlock();
        if (token != null) {
            return token;
        }
        token = this.include();
        if (token != null) {
            return token;
        }
        token = this.includeFiltered();
        if (token != null) {
            return token;
        }
        token = this.mixin();
        if (token != null) {
            return token;
        }
        token = this.call();
        if (token != null) {
            return token;
        }
        token = this.conditional();
        if (token != null) {
            return token;
        }
        token = this.each();
        if (token != null) {
            return token;
        }
        token = this.whileToken();
        if (token != null) {
            return token;
        }
        token = this.tag();
        if (token != null) {
            return token;
        }
        token = this.filter();
        if (token != null) {
            return token;
        }
        token = this.blockCode();
        if (token != null) {
            return token;
        }
        token = this.code();
        if (token != null) {
            return token;
        }
        token = this.id();
        if (token != null) {
            return token;
        }
        token = this.className();
        if (token != null) {
            return token;
        }
        token = this.attrs();
        if (token != null) {
            return token;
        }
        token = this.attributesBlock();
        if (token != null) {
            return token;
        }
        token = this.indent();
        if (token != null) {
            return token;
        }
        token = this.text();
        if (token != null) {
            return token;
        }
        token = this.comment();
        if (token != null) {
            return token;
        }
        token = this.colon();
        if (token != null) {
            return token;
        }
        token = this.dot();
        if (token != null) {
            return token;
        }
        token = this.assignment();
        if (token != null) {
            return token;
        }
        token = this.textFail();
        if (token != null) {
            return token;
        }
        token = this.fail();
        if (token != null) {
            return token;
        }
        return null;
    }

    public void consume(int len) {
        this.scanner.consume(len);
    }

    public void defer(Token tok) {
        this.deferredTokens.add(tok);
    }

    public Token lookahead(int n) {
        for (int fetch = n - this.stash.size(); fetch > 0; --fetch) {
            this.stash.add(this.next());
        }
        return this.stash.get(--n);
    }

    private CharacterParser.Match bracketExpression() {
        return this.bracketExpression(0);
    }

    private CharacterParser.Match bracketExpression(int skip) {
        CharacterParser.Match range;
        char start = this.scanner.getInput().charAt(skip);
        if (start != '(' && start != '{' && start != '[') {
            throw new JadeLexerException("unrecognized start character", this.filename, this.getLineno(), this.templateLoader);
        }
        HashMap<Character, Character> closingBrackets = new HashMap<Character, Character>();
        closingBrackets.put(Character.valueOf('('), Character.valueOf(')'));
        closingBrackets.put(Character.valueOf('{'), Character.valueOf('}'));
        closingBrackets.put(Character.valueOf('['), Character.valueOf(']'));
        char end = ((Character)closingBrackets.get(Character.valueOf(start))).charValue();
        Options options = new Options();
        options.setStart(skip + 1);
        try {
            range = this.characterParser.parseMax(this.scanner.getInput(), options);
        }
        catch (CharacterParser.SyntaxError exception) {
            throw new JadeLexerException(exception.getMessage() + " See " + StringUtils.substring(this.scanner.getInput(), 0, 5), this.filename, this.getLineno(), this.templateLoader);
        }
        if (this.scanner.getInput().charAt(range.getEnd()) != end) {
            throw new JadeLexerException("start character " + start + " does not match end character " + this.scanner.getInput().charAt(range.getEnd()), this.filename, this.getLineno(), this.templateLoader);
        }
        return range;
    }

    public int getLineno() {
        return this.lineno;
    }

    public void setPipeless(boolean pipeless) {
        this.pipeless = pipeless;
    }

    public Token advance() {
        Token t = this.stashed();
        return t != null ? t : this.next();
    }

    private String scan(String regexp) {
        String result = null;
        Matcher matcher = this.scanner.getMatcherForPattern(regexp);
        if (matcher.find(0) && matcher.group(0) != null) {
            int end = matcher.end();
            this.consume(end);
            return matcher.group(0);
        }
        return result;
    }

    private String scan1(String regexp) {
        String result = null;
        Matcher matcher = this.scanner.getMatcherForPattern(regexp);
        if (matcher.find(0) && matcher.groupCount() > 0) {
            int end = matcher.end();
            this.consume(end);
            return matcher.group(1);
        }
        return result;
    }

    private Token stashed() {
        if (this.stash.size() > 0) {
            return this.stash.poll();
        }
        return null;
    }

    private Token deferred() {
        if (this.deferredTokens.size() > 0) {
            return this.deferredTokens.poll();
        }
        return null;
    }

    private Token blank() {
        Matcher matcher = this.scanner.getMatcherForPattern("^\\n *\\n");
        if (matcher.find(0)) {
            this.consume(matcher.end() - 1);
            ++this.lineno;
            if (this.pipeless) {
                return new Text("", this.lineno);
            }
            return this.next();
        }
        return null;
    }

    private Token eos() {
        if (this.scanner.getInput().length() > 0) {
            return null;
        }
        if (this.indentStack.size() > 0) {
            this.indentStack.poll();
            return new Outdent(this.lineno);
        }
        return new Eos("eos", this.lineno);
    }

    private Token comment() {
        Matcher matcher = this.scanner.getMatcherForPattern("^\\/\\/(-)?([^\\n]*)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            boolean buffer = !"-".equals(matcher.group(1));
            Comment comment = new Comment(matcher.group(2), this.lineno, buffer);
            this.consume(matcher.end());
            this.pipeless = true;
            return comment;
        }
        return null;
    }

    private Token code() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(!?=|-)[ \\t]*([^\\n]+)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            this.consume(matcher.end());
            String flags = matcher.group(1);
            Expression code = new Expression(matcher.group(2), this.lineno);
            code.setEscape(flags.charAt(0) == '=');
            code.setBuffer(flags.charAt(0) == '=' || flags.length() > 1 && flags.charAt(1) == '=');
            if (code.isBuffer()) {
                try {
                    this.expressionHandler.assertExpression(matcher.group(2));
                }
                catch (ExpressionException e) {
                    throw new JadeLexerException(e.getMessage(), this.filename, this.lineno, this.templateLoader);
                }
            }
            return code;
        }
        return null;
    }

    private Token interpolation() {
        Matcher matcher = this.scanner.getMatcherForPattern("^#\\{");
        if (matcher.find(0)) {
            try {
                CharacterParser.Match match = this.bracketExpression(1);
                this.scanner.consume(match.getEnd() + 1);
                return new Interpolation(match.getSrc(), this.lineno);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private Token tag() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(\\w[-:\\w]*)(\\/?)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            Tag tok;
            this.consume(matcher.end());
            String name = matcher.group(1);
            if (':' == name.charAt(name.length() - 1)) {
                name = name.substring(0, name.length() - 1);
                tok = new Tag(name, this.lineno);
                this.defer(new Colon(this.lineno));
                while (' ' == this.scanner.getInput().charAt(0)) {
                    this.scanner.consume(1);
                }
            } else {
                tok = new Tag(name, this.lineno);
            }
            if (!matcher.group(2).isEmpty()) {
                tok.setSelfClosing(true);
            }
            return tok;
        }
        return null;
    }

    private Token yield() {
        Matcher matcher = this.scanner.getMatcherForPattern("^yield *");
        if (matcher.find(0)) {
            matcher.group(0);
            int end = matcher.end();
            this.consume(end);
            return new Yield(this.lineno);
        }
        return null;
    }

    private Token filter() {
        String val = this.scan1("^:([\\w\\-]+)");
        if (StringUtils.isNotBlank(val)) {
            this.pipeless = true;
            return new Filter(val, this.lineno);
        }
        return null;
    }

    private Token each() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(?:- *)?(?:each|for) +([a-zA-Z_$][\\w$]*)(?: *, *([a-zA-Z_$][\\w$]*))? * in *([^\\n]+)");
        if (matcher.find(0) && matcher.groupCount() > 2) {
            this.consume(matcher.end());
            String value = matcher.group(1);
            String key = matcher.group(2);
            String code = matcher.group(3);
            Each each = new Each(value, this.lineno);
            each.setCode(code);
            each.setKey(key);
            return each;
        }
        return null;
    }

    private Token whileToken() {
        String val = this.scan1("^while +([^\\n]+)");
        if (StringUtils.isNotBlank(val)) {
            return new While(val, this.lineno);
        }
        return null;
    }

    private Token conditional() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(if|unless|else if|else)\\b([^\\n]*)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            String type = matcher.group(1);
            String condition = matcher.group(2);
            this.consume(matcher.end());
            if ("else".equals(type)) {
                return new Else(null, this.lineno);
            }
            if ("else if".equals(type)) {
                return new ElseIf(condition, this.lineno);
            }
            If ifToken = new If(condition, this.lineno);
            ifToken.setInverseCondition("unless".equals(type));
            return ifToken;
        }
        return null;
    }

    private Token doctype() {
        String val = this.scan1("^!!! *([^\\n]+)?");
        if (StringUtils.isNotBlank(val)) {
            throw new JadeLexerException("`!!!` is deprecated, you must now use `doctype`", this.filename, this.getLineno(), this.templateLoader);
        }
        Matcher matcher = this.scanner.getMatcherForPattern("^(?:doctype) *([^\\n]+)?");
        if (matcher.find(0) && matcher.groupCount() > 0) {
            int end = matcher.end();
            this.consume(end);
            String name = matcher.group(1);
            if (name != null && "5".equals(name.trim())) {
                throw new JadeLexerException("`doctype 5` is deprecated, you must now use `doctype html`", this.filename, this.getLineno(), this.templateLoader);
            }
            return new Doctype(name, this.lineno);
        }
        return null;
    }

    private Token id() {
        String val = this.scan1("^#([\\w-]+)");
        if (StringUtils.isNotBlank(val)) {
            return new CssId(val, this.lineno);
        }
        return null;
    }

    private Token className() {
        String val = this.scan1("^\\.([\\w-]+)");
        if (StringUtils.isNotBlank(val)) {
            return new CssClass(val, this.lineno);
        }
        return null;
    }

    private Token text() {
        String val = this.scan1("^(?:\\| ?| )([^\\n]+)");
        if (StringUtils.isEmpty(val) && StringUtils.isEmpty(val = this.scan1("^\\|?( )"))) {
            val = this.scan1("^(<[^\\n]*)");
        }
        if (StringUtils.isNotEmpty(val)) {
            return new Text(val, this.lineno);
        }
        return null;
    }

    private Token textFail() {
        String val = this.scan1("^([^\\.\\n][^\\n]+)");
        if (StringUtils.isNotEmpty(val)) {
            return new Text(val, this.lineno);
        }
        return null;
    }

    private Token fail() {
        throw new JadeLexerException("unexpected text " + StringUtils.substring(this.scanner.getInput(), 0, 5), this.filename, this.getLineno(), this.templateLoader);
    }

    private Token extendsToken() {
        String val = this.scan1("^extends? +([^\\n]+)");
        if (StringUtils.isNotBlank(val)) {
            return new ExtendsToken(val, this.lineno);
        }
        return null;
    }

    private Token prepend() {
        String name = this.scan1("^prepend +([^\\n]+)");
        if (StringUtils.isNotBlank(name)) {
            Block tok = new Block(name, this.lineno);
            tok.setMode("prepend");
            return tok;
        }
        return null;
    }

    private Token append() {
        String name = this.scan1("^append +([^\\n]+)");
        if (StringUtils.isNotBlank(name)) {
            Block tok = new Block(name, this.lineno);
            tok.setMode("append");
            return tok;
        }
        return null;
    }

    private Token block() {
        Matcher matcher = this.scanner.getMatcherForPattern("^block\\b *(?:(prepend|append) +)?([^\\n]+)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            String val = matcher.group(1);
            String mode = StringUtils.isNotBlank(val) ? val : "replace";
            String name = matcher.group(2);
            Block tok = new Block(name, this.lineno);
            tok.setMode(mode);
            this.consume(matcher.end());
            return tok;
        }
        return null;
    }

    private Token mixinBlock() {
        Matcher matcher = this.scanner.getMatcherForPattern("^block[ \\t]*(\\n|$)");
        if (matcher.find(0) && matcher.groupCount() > 0) {
            this.consume(matcher.end() - matcher.group(1).length());
            return new MixinBlock(this.lineno);
        }
        return null;
    }

    private Token blockCode() {
        Matcher matcher = this.scanner.getMatcherForPattern("^-\\n");
        if (matcher.find(0)) {
            this.consume(matcher.end() - 1);
            BlockCode blockCode = new BlockCode(this.lineno);
            this.pipeless = true;
            return blockCode;
        }
        return null;
    }

    private Token include() {
        String val = this.scan1("^include +([^\\n]+)");
        if (StringUtils.isNotBlank(val)) {
            return new Include(val, this.lineno);
        }
        return null;
    }

    private Token includeFiltered() {
        Matcher matcher = Pattern.compile("^include:([\\w\\-]+)([\\( ])").matcher(this.scanner.getInput());
        if (matcher.find(0) && matcher.groupCount() > 1) {
            Token attrs;
            this.consume(matcher.end() - 1);
            String filter = matcher.group(1);
            Token token = attrs = matcher.group(2).equals("(") ? this.attrs() : null;
            if (!matcher.group(2).equals(" ") && this.scanner.getInput().charAt(0) != ' ') {
                throw new JadeLexerException("expected space after include:filter but got " + String.valueOf(this.scanner.getInput().charAt(0)), this.filename, this.getLineno(), this.templateLoader);
            }
            matcher = Pattern.compile("^ *([^\\n]+)").matcher(this.scanner.getInput());
            if (!matcher.find(0) || matcher.groupCount() <= 0 || matcher.group(1).trim().equals("")) {
                throw new JadeLexerException("missing path for include:filter", this.filename, this.getLineno(), this.templateLoader);
            }
            this.consume(matcher.end());
            String path = matcher.group(1);
            Include tok = new Include(path, this.lineno);
            tok.setFilter(filter);
            tok.setAttrs(attrs);
            return tok;
        }
        return null;
    }

    private Token caseToken() {
        String val = this.scan1("^case +([^\\n]+)");
        if (StringUtils.isNotBlank(val)) {
            return new CaseToken(val, this.lineno);
        }
        return null;
    }

    private Token when() {
        String val = this.scan1("^when +([^:\\n]+)");
        if (StringUtils.isNotBlank(val)) {
            return new When(val, this.lineno);
        }
        return null;
    }

    private Token defaultToken() {
        String val = this.scan1("^(default *)");
        if (StringUtils.isNotBlank(val)) {
            return new Default(val, this.lineno);
        }
        return null;
    }

    private Token assignment() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(\\w+) += *([^;\\n]+)( *;? *)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            String name = matcher.group(1);
            String val = matcher.group(2);
            this.consume(matcher.end());
            Assignment assign = new Assignment(val, this.lineno);
            assign.setName(name);
            return assign;
        }
        return null;
    }

    private Token dot() {
        this.pipeless = true;
        Matcher matcher = this.scanner.getMatcherForPattern("^\\.");
        if (matcher.find(0)) {
            Dot tok = new Dot(this.lineno);
            this.consume(matcher.end());
            return tok;
        }
        return null;
    }

    private Token mixin() {
        Matcher matcher = this.scanner.getMatcherForPattern("^mixin +([-\\w]+)(?: *\\((.*)\\))? *");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            Mixin tok = new Mixin(matcher.group(1), this.lineno);
            tok.setArguments(matcher.group(2));
            this.consume(matcher.end());
            return tok;
        }
        return null;
    }

    private Token call() {
        Matcher matcher = this.scanner.getMatcherForPattern("^\\+(\\s*)(([-\\w]+)|(#\\{))");
        if (matcher.find(0) && matcher.groupCount() > 3) {
            Call tok;
            if (matcher.group(3) != null) {
                this.consume(matcher.end());
                tok = new Call(matcher.group(3), this.lineno);
            } else {
                CharacterParser.Match match = this.bracketExpression(2 + matcher.group(1).length());
                this.consume(match.getEnd() + 1);
                try {
                    this.expressionHandler.assertExpression(match.getSrc());
                }
                catch (ExpressionException e) {
                    e.printStackTrace();
                }
                tok = new Call("#{" + match.getSrc() + "}", this.lineno);
            }
            matcher = this.scanner.getMatcherForPattern("^ *\\(");
            if (matcher.find(0)) {
                CharacterParser.Match range = this.bracketExpression(matcher.group(0).length() - 1);
                matcher = Pattern.compile("^\\s*[-\\w]+ *=").matcher(range.getSrc());
                if (!matcher.find(0)) {
                    this.consume(range.getEnd() + 1);
                    tok.setArguments(range.getSrc());
                }
                if (tok.getArguments() != null) {
                    try {
                        this.expressionHandler.assertExpression("[" + tok.getArguments() + "]");
                    }
                    catch (ExpressionException e) {
                        e.printStackTrace();
                    }
                }
            }
            return tok;
        }
        return null;
    }

    public boolean isEndOfAttribute(int i, String str, String key, String val, Loc loc, CharacterParser.State state) {
        if (key.trim().isEmpty()) {
            return false;
        }
        if (i == str.length()) {
            return true;
        }
        if (Loc.KEY.equals((Object)loc)) {
            if (str.charAt(i) == ' ' || str.charAt(i) == '\n') {
                for (int x = i; x < str.length(); ++x) {
                    if (str.charAt(x) == ' ' || str.charAt(x) == '\n') continue;
                    return str.charAt(x) != '=' && str.charAt(x) != '!' && str.charAt(x) != ',';
                }
            }
            return str.charAt(i) == ',';
        }
        if (Loc.VALUE.equals((Object)loc) && !state.isNesting()) {
            try {
                this.expressionHandler.assertExpression(val);
                if (str.charAt(i) == ' ' || str.charAt(i) == '\n') {
                    for (int x = i; x < str.length(); ++x) {
                        if (str.charAt(x) == ' ' || str.charAt(x) == '\n') continue;
                        return !this.characterParser.isPunctuator(Character.valueOf(str.charAt(x))) || str.charAt(x) == '\"' || str.charAt(x) == '\'';
                    }
                }
                return str.charAt(i) == ',';
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private String interpolate(String attr, final String quote) {
        Pattern regex = Pattern.compile("(\\\\)?#\\{(.+)");
        return StringReplacer.replace(attr, regex, new StringReplacerCallback(){

            @Override
            public String replace(Matcher m) {
                String match = m.group(0);
                String escape = m.group(1);
                String expr = m.group(2);
                if (escape != null) {
                    return match;
                }
                try {
                    try {
                        CharacterParser.Match range = Lexer.this.characterParser.parseMax(expr);
                        if (expr.charAt(range.getEnd()) != '}') {
                            return Lexer.this.substr(match, 0, 2) + Lexer.this.interpolate(match.substring(2), quote);
                        }
                        Lexer.this.expressionHandler.assertExpression(range.getSrc());
                        return quote + " + (" + range.getSrc() + ") + " + quote + Lexer.this.interpolate(expr.substring(range.getEnd() + 1), quote);
                    }
                    catch (ExpressionException ex) {
                        return Lexer.this.substr(match, 0, 2) + Lexer.this.interpolate(match.substring(2), quote);
                    }
                }
                catch (CharacterParser.SyntaxError e) {
                    throw new JadeLexerException(e.getMessage() + " See " + match, Lexer.this.filename, Lexer.this.getLineno(), Lexer.this.templateLoader);
                }
            }
        });
    }

    private String substr(String str, int start, int length) {
        return str.substring(start, start + length);
    }

    private boolean assertNestingCorrect(String exp) {
        try {
            CharacterParser.State res = this.characterParser.parse(exp);
            if (res.isNesting()) {
                throw new JadeLexerException("Nesting must match on expression `" + exp + "`", this.filename, this.getLineno(), this.templateLoader);
            }
        }
        catch (CharacterParser.SyntaxError syntaxError) {
            throw new JadeLexerException("Nesting must match on expression `" + exp + "`", this.filename, this.getLineno(), this.templateLoader);
        }
        return true;
    }

    private Token attrs() {
        if ('(' == this.scanner.getInput().charAt(0)) {
            int index = this.bracketExpression().getEnd();
            String str = this.scanner.getInput().substring(1, index);
            AttributeList tok = new AttributeList(this.getLineno());
            this.assertNestingCorrect(str);
            String quote = "";
            this.scanner.consume(index + 1);
            boolean escapedAttr = true;
            String key = "";
            String val = "";
            String interpolatable = "";
            CharacterParser.State state = this.characterParser.defaultState();
            Loc loc = Loc.KEY;
            this.lineno += str.split("\n").length - 1;
            block8: for (int i = 0; i <= str.length(); ++i) {
                if (this.isEndOfAttribute(i, str, key, val, loc, state)) {
                    val = val.trim();
                    if (!(val = val.replaceAll("\\n", "")).isEmpty()) {
                        try {
                            this.expressionHandler.assertExpression(val);
                        }
                        catch (ExpressionException e) {
                            throw new JadeLexerException(e.getMessage(), this.filename, this.lineno, this.templateLoader);
                        }
                    }
                    val = StringEscapeUtils.unescapeJson(val);
                    key = key.trim();
                    key = key.replaceAll("^['\"]|['\"]$", "");
                    if ("".equals(val)) {
                        tok.addBooleanAttribute(key, Boolean.TRUE);
                    } else if (doubleQuotedRe.matcher(val).matches() || quotedRe.matcher(val).matches()) {
                        tok.addAttribute(key, cleanRe.matcher(val).replaceAll(""), escapedAttr);
                    } else {
                        tok.addExpressionAttribute(key, val, escapedAttr);
                    }
                    val = "";
                    key = "";
                    loc = Loc.KEY;
                    escapedAttr = false;
                    continue;
                }
                switch (loc) {
                    case KEY_CHAR: {
                        if (String.valueOf(str.charAt(i)).equals(quote)) {
                            loc = Loc.KEY;
                            List<Character> expectedCharacter = Arrays.asList(Character.valueOf(' '), Character.valueOf(','), Character.valueOf('!'), Character.valueOf('='), Character.valueOf('\n'));
                            if (i + 1 >= str.length() || expectedCharacter.indexOf(Character.valueOf(str.charAt(i + 1))) != -1) continue block8;
                            throw new JadeLexerException("Unexpected character " + str.charAt(i + 1) + " expected ` `, `\\n`, `,`, `!` or `=`", this.filename, this.getLineno(), this.templateLoader);
                        }
                        key = key + str.charAt(i);
                        continue block8;
                    }
                    case KEY: {
                        if (key.isEmpty() && !str.isEmpty() && (str.charAt(i) == '\"' || str.charAt(i) == '\'')) {
                            loc = Loc.KEY_CHAR;
                            quote = String.valueOf(str.charAt(i));
                            continue block8;
                        }
                        if (!(str.isEmpty() || str.charAt(i) != '!' && str.charAt(i) != '=')) {
                            boolean bl = escapedAttr = str.charAt(i) != '!';
                            if (str.charAt(i) == '!') {
                                ++i;
                            }
                            if (str.charAt(i) != '=') {
                                throw new JadeLexerException("Unexpected character " + str.charAt(i) + " expected `=`", this.filename, this.getLineno(), this.templateLoader);
                            }
                            loc = Loc.VALUE;
                            state = this.characterParser.defaultState();
                            continue block8;
                        }
                        if (str.isEmpty()) continue block8;
                        key = key + str.charAt(i);
                        continue block8;
                    }
                    case VALUE: {
                        state = this.characterParser.parseChar(str.charAt(i), state);
                        if (state.isString()) {
                            loc = Loc.STRING;
                            quote = String.valueOf(str.charAt(i));
                            interpolatable = String.valueOf(str.charAt(i));
                            continue block8;
                        }
                        val = val + str.charAt(i);
                        continue block8;
                    }
                    case STRING: {
                        state = this.characterParser.parseChar(str.charAt(i), state);
                        interpolatable = interpolatable + str.charAt(i);
                        if (state.isString()) continue block8;
                        loc = Loc.VALUE;
                        val = val + this.interpolate(interpolatable, quote);
                    }
                }
            }
            if (this.scanner.getInput().length() > 0 && '/' == this.scanner.getInput().charAt(0)) {
                this.consume(1);
                tok.setSelfClosing(true);
            }
            return tok;
        }
        return null;
    }

    private Token attributesBlock() {
        Matcher matcher = this.scanner.getMatcherForPattern("^&attributes\\b");
        if (matcher.find(0) && matcher.group(0) != null) {
            this.scanner.consume(11);
            CharacterParser.Match match = this.bracketExpression();
            this.scanner.consume(match.getEnd() + 1);
            return new AttributesBlock(match.getSrc(), this.lineno);
        }
        return null;
    }

    private int indexOfDelimiters(char start, char end) {
        String str = this.scanner.getInput();
        int nstart = 0;
        int nend = 0;
        int pos = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (start == str.charAt(i)) {
                ++nstart;
                continue;
            }
            if (end != str.charAt(i) || ++nend != nstart) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private Token indent() {
        Matcher matcher;
        if (this.indentRe != null) {
            matcher = this.scanner.getMatcherForPattern(this.indentRe);
        } else {
            String re = "^\\n(\\t*) *";
            String indentType = "tabs";
            matcher = this.scanner.getMatcherForPattern(re);
            if (matcher.find(0) && matcher.group(1).length() == 0) {
                re = "^\\n( *)";
                indentType = "spaces";
                matcher = this.scanner.getMatcherForPattern(re);
            }
            if (matcher.find(0) && matcher.group(1).length() > 0) {
                this.indentRe = re;
            }
            this.indentType = indentType;
        }
        if (matcher.find(0) && matcher.groupCount() > 0) {
            Token tok;
            int indents = matcher.group(1).length();
            ++this.lineno;
            this.consume(indents + 1);
            if (this.scanner.getInput().length() > 0 && (this.scanner.getInput().charAt(0) == ' ' || this.scanner.getInput().charAt(0) == '\t')) {
                throw new JadeLexerException("Invalid indentation, you can use tabs or spaces but not both", this.filename, this.getLineno(), this.templateLoader);
            }
            if (this.scanner.isBlankLine()) {
                this.pipeless = false;
                return new Newline(this.lineno);
            }
            if (this.indentStack.size() > 0 && indents < this.indentStack.get(0)) {
                while (this.indentStack.size() > 0 && this.indentStack.get(0) > indents) {
                    this.stash.add(new Outdent(this.lineno));
                    this.indentStack.poll();
                }
                tok = this.stash.pollLast();
            } else if (indents > 0 && (this.indentStack.size() == 0 || indents != this.indentStack.get(0))) {
                this.indentStack.push(indents);
                tok = new Indent(String.valueOf(indents), this.lineno);
                tok.setIndents(indents);
            } else {
                tok = new Newline(this.lineno);
            }
            this.pipeless = false;
            return tok;
        }
        return null;
    }

    private Token pipelessText() {
        int indents;
        Matcher matcher;
        if (!this.pipeless) {
            return null;
        }
        if (this.indentRe != null) {
            matcher = this.scanner.getMatcherForPattern(this.indentRe);
        } else {
            String re = "^\\n(\\t*) *";
            matcher = this.scanner.getMatcherForPattern(re);
            if (matcher.find(0) && matcher.group(1).length() == 0) {
                re = "^\\n( *)";
                matcher = this.scanner.getMatcherForPattern(re);
            }
            if (matcher.find(0) && matcher.group(1).length() > 0) {
                this.indentRe = re;
            }
        }
        if (matcher.find(0) && matcher.group(1).length() > 0 && (indents = matcher.group(1).length()) > 0 && (this.indentStack.size() == 0 || indents > this.indentStack.get(0))) {
            String indent = matcher.group(1);
            ArrayList<String> tokens = new ArrayList<String>();
            boolean isMatch = false;
            do {
                int i;
                if (-1 == (i = this.scanner.getInput().substring(1).indexOf(10))) {
                    i = this.scanner.getInput().length() - 1;
                }
                String str = this.scanner.getInput().substring(1, i + 1);
                int indentLength = indent.length();
                if (str.length() <= indentLength) {
                    indentLength = str.length();
                }
                boolean bl = isMatch = str.substring(0, indentLength).equals(indent) || str.trim().length() <= 0;
                if (!isMatch) continue;
                this.consume(str.length() + 1);
                ++this.lineno;
                tokens.add(str.substring(indentLength));
            } while (this.scanner.getInput().length() > 0 && isMatch);
            while (this.scanner.getInput().length() == 0 && ((String)tokens.get(tokens.size() - 1)).equals("")) {
                tokens.remove(tokens.size() - 1);
            }
            PipelessText pipelessText = new PipelessText(this.lineno);
            pipelessText.setValues(tokens);
            return pipelessText;
        }
        return null;
    }

    private Token colon() {
        String val = this.scan("^: *");
        if (StringUtils.isNotBlank(val)) {
            return new Colon(this.lineno);
        }
        return null;
    }

    private String ensureJadeExtension(String templateName) {
        if (StringUtils.isBlank(FilenameUtils.getExtension(templateName))) {
            return templateName + ".jade";
        }
        return templateName;
    }

    public boolean getPipeless() {
        return this.pipeless;
    }

    public LinkedList<Token> getTokens() {
        Token t = null;
        LinkedList<Token> list = new LinkedList<Token>();
        while ((t = this.advance()) != null) {
            list.add(t);
            if (!(t instanceof Eos)) continue;
            break;
        }
        return list;
    }

    private static enum Loc {
        KEY,
        KEY_CHAR,
        VALUE,
        STRING;

    }
}

