/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.IndentWriter;
import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.JadeTemplate;
import org.apache.commons.lang3.StringEscapeUtils;

public class ExpressionNode
extends Node {
    private boolean escape;
    private boolean buffer;

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setBuffer(boolean buffer) {
        this.buffer = buffer;
    }

    @Override
    public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        try {
            Object result = template.getExpressionHandler().evaluateExpression(this.getValue(), model);
            if (result == null || !this.buffer) {
                return;
            }
            String string = result.toString();
            if (this.escape) {
                string = StringEscapeUtils.escapeHtml4(string);
            }
            writer.append(string);
            if (this.hasBlock()) {
                writer.increment();
                this.block.execute(writer, model, template);
                writer.decrement();
                writer.newline();
            }
        }
        catch (ExpressionException e) {
            throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
        }
    }

    @Override
    public void setValue(String value) {
        super.setValue(value.trim());
    }
}

