/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.attributes;

import io.pebbletemplates.pebble.error.ClassAccessException;
import io.pebbletemplates.pebble.template.EvaluationContextImpl;
import io.pebbletemplates.pebble.template.EvaluationOptions;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class MemberCacheUtils {
    private final ConcurrentHashMap<MemberCacheKey, Member> memberCache = new ConcurrentHashMap(100, 0.9f, 1);

    MemberCacheUtils() {
    }

    Member getMember(Object instance, String attributeName, Class<?>[] argumentTypes) {
        return this.memberCache.get(new MemberCacheKey(instance.getClass(), attributeName, argumentTypes));
    }

    Member cacheMember(Object instance, String attributeName, Class<?>[] argumentTypes, EvaluationContextImpl context, String filename, int lineNumber) {
        Member member = this.reflect(instance, attributeName, argumentTypes, filename, lineNumber, context.getEvaluationOptions());
        if (member != null) {
            this.memberCache.put(new MemberCacheKey(instance.getClass(), attributeName, argumentTypes), member);
        }
        return member;
    }

    private Member reflect(Object object, String attributeName, Class<?>[] parameterTypes, String filename, int lineNumber, EvaluationOptions evaluationOptions) {
        Class<?> clazz = object.getClass();
        String attributeCapitalized = Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
        List<Class> agenda = Arrays.asList(List.class, Set.class, Map.class, Map.Entry.class, Collection.class, Iterable.class, clazz);
        for (Class type : agenda) {
            if (!type.isAssignableFrom(clazz)) continue;
            AccessibleObject result = this.findMethod(object, type, "get" + attributeCapitalized, parameterTypes, filename, lineNumber, evaluationOptions);
            if (result == null) {
                result = this.findMethod(object, type, "is" + attributeCapitalized, parameterTypes, filename, lineNumber, evaluationOptions);
            }
            if (result == null) {
                result = this.findMethod(object, type, "has" + attributeCapitalized, parameterTypes, filename, lineNumber, evaluationOptions);
            }
            if (result == null) {
                result = this.findMethod(object, type, attributeName, parameterTypes, filename, lineNumber, evaluationOptions);
            }
            if (result == null) {
                try {
                    result = type.getField(attributeName);
                }
                catch (NoSuchFieldException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (result == null) continue;
            ((AccessibleObject)result).setAccessible(true);
            return result;
        }
        return null;
    }

    private Method findMethod(Object object, Class<?> clazz, String name, Class<?>[] requiredTypes, String filename, int lineNumber, EvaluationOptions evaluationOptions) {
        int i;
        Class<?>[] types;
        boolean compatibleTypes;
        List<Method> candidates = this.getCandidates(clazz, name, requiredTypes);
        Method bestMatch = null;
        block0: for (Method candidate : candidates) {
            compatibleTypes = true;
            types = candidate.getParameterTypes();
            for (i = 0; i < types.length; ++i) {
                if (requiredTypes[i] == null || this.widen(types[i]).isAssignableFrom(requiredTypes[i])) continue;
                compatibleTypes = false;
                break;
            }
            if (!compatibleTypes) continue;
            if (bestMatch == null) {
                bestMatch = candidate;
                continue;
            }
            Class<?>[] bestMatchParamTypes = bestMatch.getParameterTypes();
            for (int i2 = 0; i2 < types.length; ++i2) {
                Class<?> widened = this.widen(bestMatchParamTypes[i2]);
                if (!widened.isAssignableFrom(types[i2]) || widened.equals(types[i2])) continue;
                bestMatch = candidate;
                continue block0;
            }
        }
        if (bestMatch != null) {
            this.verifyUnsafeMethod(filename, lineNumber, evaluationOptions, object, bestMatch);
            return bestMatch;
        }
        if (evaluationOptions.isGreedyMatchMethod()) {
            for (Method candidate : candidates) {
                compatibleTypes = true;
                types = candidate.getParameterTypes();
                for (i = 0; i < types.length; ++i) {
                    if (requiredTypes[i] == null || this.isCompatibleType(types[i], requiredTypes[i])) continue;
                    compatibleTypes = false;
                    break;
                }
                if (!compatibleTypes) continue;
                this.verifyUnsafeMethod(filename, lineNumber, evaluationOptions, object, candidate);
                return candidate;
            }
        }
        return null;
    }

    private void verifyUnsafeMethod(String filename, int lineNumber, EvaluationOptions evaluationOptions, Object object, Method method) {
        boolean methodAccessAllowed = evaluationOptions.getMethodAccessValidator().isMethodAccessAllowed(object, method);
        if (!methodAccessAllowed) {
            throw new ClassAccessException(method, filename, lineNumber);
        }
    }

    private Class<?> widen(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    private List<Method> getCandidates(Class<?> clazz, String name, Object[] requiredTypes) {
        Method[] methods;
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (Method m : methods = clazz.getMethods()) {
            Class<?>[] types;
            if (!m.getName().equalsIgnoreCase(name) || (types = m.getParameterTypes()).length != requiredTypes.length) continue;
            candidates.add(m);
        }
        return candidates;
    }

    private boolean isCompatibleType(Class<?> type1, Class<?> type2) {
        Class<?> widenType = this.widen(type1);
        return Number.class.isAssignableFrom(widenType) && Number.class.isAssignableFrom(type2);
    }

    private class MemberCacheKey {
        private final Class<?> clazz;
        private final String attributeName;
        private final Class<?>[] methodParameterTypes;

        public MemberCacheKey(Class<?> clazz, String attributeName, Class<?>[] methodParameterTypes) {
            this.clazz = clazz;
            this.attributeName = attributeName;
            this.methodParameterTypes = methodParameterTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberCacheKey that = (MemberCacheKey)o;
            if (!this.clazz.equals(that.clazz)) {
                return false;
            }
            if (!this.attributeName.equals(that.attributeName)) {
                return false;
            }
            return Arrays.equals(this.methodParameterTypes, that.methodParameterTypes);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.attributeName.hashCode();
            result = 31 * result + Arrays.hashCode(this.methodParameterTypes);
            return result;
        }
    }
}

