/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.pebble.impl;

import io.pebbletemplates.pebble.error.LoaderException;
import io.pebbletemplates.pebble.loader.Loader;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;

public class PebbleVertxLoader
implements Loader<String> {
    private final Vertx vertx;
    private Charset charset = Charset.defaultCharset();

    public PebbleVertxLoader(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public Reader getReader(String s) throws LoaderException {
        try {
            return new StringReader(this.vertx.fileSystem().readFileBlocking(s).toString(this.charset));
        }
        catch (RuntimeException e) {
            throw new LoaderException(e, e.getMessage());
        }
    }

    @Override
    public void setCharset(String s) {
        this.charset = Charset.forName(s);
    }

    @Override
    public void setPrefix(String s) {
    }

    @Override
    public void setSuffix(String s) {
    }

    @Override
    public String resolveRelativePath(String s, String anchorPath) {
        File resolved = new File(new File(anchorPath).getParentFile(), s);
        return resolved.getPath();
    }

    @Override
    public String createCacheKey(String s) {
        return s;
    }

    @Override
    public boolean resourceExists(String s) {
        try {
            return this.vertx.fileSystem().existsBlocking(s);
        }
        catch (RuntimeException e) {
            throw new LoaderException(e, e.getMessage());
        }
    }
}

