/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.rocker.impl;

import com.fizzed.rocker.BindableRockerModel;
import com.fizzed.rocker.Rocker;
import com.fizzed.rocker.RockerOutputFactory;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.templ.rocker.RockerTemplateEngine;
import io.vertx.ext.web.templ.rocker.impl.VertxBufferOutput;
import java.util.Map;

public class RockerTemplateEngineImpl
implements RockerTemplateEngine {
    private final String extension;

    public RockerTemplateEngineImpl(String extension) {
        this.extension = extension.charAt(0) == '.' ? extension : "." + extension;
    }

    public void render(Map<String, Object> context, String templateFile, Handler<AsyncResult<Buffer>> handler) {
        try {
            String templatePath = this.adjustLocation(templateFile);
            BindableRockerModel model = Rocker.template((String)templatePath);
            context.forEach((k, v) -> {
                if (!k.startsWith("__")) {
                    model.bind(k, v);
                }
            });
            VertxBufferOutput output = (VertxBufferOutput)model.render((RockerOutputFactory)VertxBufferOutput.FACTORY);
            handler.handle((Object)Future.succeededFuture((Object)output.getBuffer()));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    private String adjustLocation(String location) {
        if (this.extension != null && !location.endsWith(this.extension)) {
            location = location + this.extension;
        }
        return location;
    }
}

