/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.templ;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.buffer.Buffer;
import org.thymeleaf.templatemode.TemplateMode;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A template engine that uses the Thymeleaf library.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.templ.ThymeleafTemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.web.templ.ThymeleafTemplateEngine.class)
public class ThymeleafTemplateEngine extends TemplateEngine {

  public static final io.vertx.lang.reactivex.TypeArg<ThymeleafTemplateEngine> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new ThymeleafTemplateEngine((io.vertx.ext.web.templ.ThymeleafTemplateEngine) obj),
    ThymeleafTemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.templ.ThymeleafTemplateEngine delegate;
  
  public ThymeleafTemplateEngine(io.vertx.ext.web.templ.ThymeleafTemplateEngine delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.web.templ.ThymeleafTemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Create a template engine using defaults
   * @return the engine
   */
  public static ThymeleafTemplateEngine create() { 
    ThymeleafTemplateEngine ret = ThymeleafTemplateEngine.newInstance(io.vertx.ext.web.templ.ThymeleafTemplateEngine.create());
    return ret;
  }

  /**
   * Set the mode for the engine
   * @param mode the mode
   * @return a reference to this for fluency
   */
  public ThymeleafTemplateEngine setMode(TemplateMode mode) { 
    ThymeleafTemplateEngine ret = ThymeleafTemplateEngine.newInstance(delegate.setMode(mode));
    return ret;
  }


  public static  ThymeleafTemplateEngine newInstance(io.vertx.ext.web.templ.ThymeleafTemplateEngine arg) {
    return arg != null ? new ThymeleafTemplateEngine(arg) : null;
  }
}
