/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.thymeleaf.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.WebEnvironment;
import io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.linkbuilder.ILinkBuilder;
import org.thymeleaf.linkbuilder.StandardLinkBuilder;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public class ThymeleafTemplateEngineImpl
implements ThymeleafTemplateEngine {
    private final TemplateEngine templateEngine = new TemplateEngine();
    private final ResourceTemplateResolver templateResolver;

    public ThymeleafTemplateEngineImpl(Vertx vertx) {
        ResourceTemplateResolver templateResolver = new ResourceTemplateResolver(vertx);
        templateResolver.setCacheable(!WebEnvironment.development());
        templateResolver.setTemplateMode(ThymeleafTemplateEngine.DEFAULT_TEMPLATE_MODE);
        this.templateResolver = templateResolver;
        this.templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        this.templateEngine.setLinkBuilder((ILinkBuilder)new StandardLinkBuilder(){

            protected String computeContextPath(IExpressionContext context, String base, Map<String, Object> parameters) {
                return "/";
            }
        });
    }

    public <T> T unwrap() {
        return (T)this.templateEngine;
    }

    public void clearCache() {
        this.templateEngine.clearTemplateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Buffer> render(Map<String, Object> context, String templateFile) {
        final Buffer buffer = Buffer.buffer();
        try {
            ThymeleafTemplateEngineImpl thymeleafTemplateEngineImpl = this;
            synchronized (thymeleafTemplateEngineImpl) {
                this.templateEngine.process(templateFile, (IContext)new WebIContext(context, (String)context.get("lang")), new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) {
                        buffer.appendString(new String(cbuf, off, len));
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() {
                    }
                });
            }
            return Future.succeededFuture((Object)buffer);
        }
        catch (Exception ex) {
            return Future.failedFuture((Throwable)ex);
        }
    }

    private static class ResourceTemplateResolver
    extends StringTemplateResolver {
        private final Vertx vertx;

        ResourceTemplateResolver(Vertx vertx) {
            this.vertx = vertx;
            this.setName("vertx/Thymeleaf3");
        }

        protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
            return new StringTemplateResource(this.vertx.fileSystem().readFileBlocking(template).toString(Charset.defaultCharset()));
        }
    }

    private static class WebIContext
    implements IContext {
        private final Map<String, Object> data;
        private final Locale locale;

        private WebIContext(Map<String, Object> data, String lang) {
            this.data = data;
            this.locale = lang == null ? Locale.getDefault() : Locale.forLanguageTag(lang);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean containsVariable(String name) {
            return this.data.containsKey(name);
        }

        public Set<String> getVariableNames() {
            return this.data.keySet();
        }

        public Object getVariable(String name) {
            return this.data.get(name);
        }
    }
}

