/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor;

import io.vertx.codegen.format.CamelCase;
import io.vertx.codegen.format.Case;
import io.vertx.codegen.processor.MethodKind;
import io.vertx.codegen.processor.ParamInfo;
import io.vertx.codegen.processor.Signature;
import io.vertx.codegen.processor.TypeArgExpression;
import io.vertx.codegen.processor.TypeParamInfo;
import io.vertx.codegen.processor.doc.Doc;
import io.vertx.codegen.processor.doc.Text;
import io.vertx.codegen.processor.type.ClassKind;
import io.vertx.codegen.processor.type.ClassTypeInfo;
import io.vertx.codegen.processor.type.ParameterizedTypeInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import io.vertx.codegen.processor.type.TypeVariableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MethodInfo
implements Comparable<MethodInfo> {
    private String name;
    private TypeInfo returnType;
    private Text returnDescription;
    private boolean fluent;
    private boolean cacheReturn;
    private String comment;
    private Doc doc;
    private boolean staticMethod;
    private boolean defaultMethod;
    private List<TypeParamInfo.Method> typeParams;
    private Set<ClassTypeInfo> ownerTypes;
    private List<ParamInfo> params;
    private boolean deprecated;
    private Text deprecatedDesc;
    private boolean methodOverride;

    public MethodInfo(Set<ClassTypeInfo> ownerTypes, String name, TypeInfo returnType, Text returnDescription, boolean fluent, boolean cacheReturn, List<ParamInfo> params, String comment, Doc doc, boolean staticMethod, boolean defaultMethod, List<TypeParamInfo.Method> typeParams, boolean deprecated, Text deprecatedDesc, boolean methodOverride) {
        this.comment = comment;
        this.name = name;
        this.returnType = returnType;
        this.returnDescription = returnDescription;
        this.fluent = fluent;
        this.cacheReturn = cacheReturn;
        this.doc = doc;
        this.staticMethod = staticMethod;
        this.defaultMethod = defaultMethod;
        this.params = params;
        this.typeParams = typeParams;
        this.ownerTypes = ownerTypes;
        this.deprecated = deprecated;
        this.deprecatedDesc = deprecatedDesc;
        this.methodOverride = methodOverride;
    }

    public String getName() {
        return this.name;
    }

    public MethodInfo setName(String name) {
        this.name = name;
        return this;
    }

    public String getName(Case _case) {
        return _case.format(CamelCase.INSTANCE.parse(this.name));
    }

    public TypeInfo getCallbackType() {
        TypeInfo lastParamType;
        int lastParamIndex = this.params.size() - 1;
        if (lastParamIndex >= 0 && (this.returnType.isVoid() || this.fluent) && (lastParamType = this.params.get((int)lastParamIndex).type).getKind() == ClassKind.HANDLER) {
            return ((ParameterizedTypeInfo)lastParamType).getArgs().get(0);
        }
        return null;
    }

    public MethodKind getKind() {
        TypeInfo callbackType = this.getCallbackType();
        if (callbackType != null) {
            return MethodKind.HANDLER;
        }
        if (this.returnType.getKind() == ClassKind.FUTURE) {
            return MethodKind.FUTURE;
        }
        return MethodKind.OTHER;
    }

    public TypeInfo getReturnType() {
        return this.returnType;
    }

    public MethodInfo setReturnType(TypeInfo returnType) {
        this.returnType = returnType;
        return this;
    }

    public boolean isContainingAnyJavaType() {
        return this.params.stream().map(ParamInfo::getType).anyMatch(MethodInfo::containsAnyJavaType) || MethodInfo.containsAnyJavaType(this.returnType);
    }

    private static boolean containsAnyJavaType(TypeInfo type) {
        if (type instanceof ParameterizedTypeInfo) {
            return MethodInfo.containsAnyJavaType(type.getRaw()) || ((ParameterizedTypeInfo)type).getArgs().stream().anyMatch(MethodInfo::containsAnyJavaType);
        }
        return type.getKind() == ClassKind.OTHER;
    }

    public ParamInfo resolveClassTypeParam(TypeVariableInfo typeVar) {
        TypeArgExpression res = this.resolveTypeArg(typeVar);
        if (res != null && res.isClassType()) {
            return res.getParam();
        }
        return null;
    }

    public TypeArgExpression resolveTypeArg(TypeVariableInfo typeVar) {
        for (TypeParamInfo.Method typeParam : this.typeParams) {
            if (!typeParam.getName().equals(typeVar.getName())) continue;
            for (ParamInfo param : this.params) {
                if (param.getType().getKind() == ClassKind.CLASS_TYPE && param.getType().isParameterized()) {
                    TypeVariableInfo ttt;
                    TypeInfo arg_ = ((ParameterizedTypeInfo)param.getType()).getArg(0);
                    if (!arg_.isVariable() || !(ttt = (TypeVariableInfo)arg_).getParam().equals(typeParam)) continue;
                    return new TypeArgExpression(0, ttt, param, 0);
                }
                if (param.getType().getKind() != ClassKind.API || !param.getType().isParameterized()) continue;
                ParameterizedTypeInfo type = (ParameterizedTypeInfo)param.getType();
                int index = 0;
                for (TypeInfo i : type.getArgs()) {
                    TypeVariableInfo tt;
                    if (i instanceof TypeVariableInfo && (tt = (TypeVariableInfo)i).getParam().equals(typeParam)) {
                        return new TypeArgExpression(1, tt, param, index);
                    }
                    ++index;
                }
            }
            return null;
        }
        return null;
    }

    public Text getReturnDescription() {
        return this.returnDescription;
    }

    public MethodInfo setReturnDescription(Text returnDescription) {
        this.returnDescription = returnDescription;
        return this;
    }

    public Set<ClassTypeInfo> getOwnerTypes() {
        return this.ownerTypes;
    }

    public MethodInfo setOwnerTypes(Set<ClassTypeInfo> ownerTypes) {
        this.ownerTypes = ownerTypes;
        return this;
    }

    public Signature getSignature() {
        return new Signature(this.name, new ArrayList<ParamInfo>(this.params));
    }

    public boolean isOwnedBy(ClassTypeInfo owner) {
        return this.ownerTypes.contains(owner) && this.ownerTypes.size() == 1;
    }

    public boolean isFluent() {
        return this.fluent;
    }

    public MethodInfo setFluent(boolean fluent) {
        this.fluent = fluent;
        return this;
    }

    public boolean isCacheReturn() {
        return this.cacheReturn;
    }

    public MethodInfo setCacheReturn(boolean cacheReturn) {
        this.cacheReturn = cacheReturn;
        return this;
    }

    public boolean isNullableReturn() {
        return this.returnType.isNullable();
    }

    public Boolean isNullableFutureReturn() {
        switch (this.returnType.getKind()) {
            case FUTURE: {
                TypeInfo handler = ((ParameterizedTypeInfo)this.returnType).getArg(0);
                return handler.isNullable();
            }
        }
        return null;
    }

    public List<ParamInfo> getParams() {
        return this.params;
    }

    public MethodInfo setParams(List<ParamInfo> params) {
        this.params = params;
        return this;
    }

    public ParamInfo getParam(int index) {
        return this.params.get(index);
    }

    public String getComment() {
        return this.comment;
    }

    public MethodInfo setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public MethodInfo setDoc(Doc doc) {
        this.doc = doc;
        return this;
    }

    public boolean isStaticMethod() {
        return this.staticMethod;
    }

    public MethodInfo setStaticMethod(boolean staticMethod) {
        this.staticMethod = staticMethod;
        return this;
    }

    public boolean isDefaultMethod() {
        return this.defaultMethod;
    }

    public MethodInfo setDefaultMethod(boolean defaultMethod) {
        this.defaultMethod = defaultMethod;
        return this;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public MethodInfo setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public boolean isMethodOverride() {
        return this.methodOverride;
    }

    public Text getDeprecatedDesc() {
        return this.deprecatedDesc;
    }

    public MethodInfo setDeprecatedDesc(Text deprecatedDesc) {
        this.deprecatedDesc = deprecatedDesc;
        return this;
    }

    public List<TypeParamInfo.Method> getTypeParams() {
        return this.typeParams;
    }

    public MethodInfo setTypeParams(List<TypeParamInfo.Method> typeParams) {
        this.typeParams = typeParams;
        return this;
    }

    public void mergeTypeParams(List<TypeParamInfo.Method> mergedTypeParams) throws IllegalArgumentException {
        int l = Math.min(this.typeParams.size(), mergedTypeParams.size());
        if (this.typeParams.subList(0, l).equals(mergedTypeParams.subList(0, l))) {
            if (mergedTypeParams.size() > this.typeParams.size()) {
                this.typeParams.addAll(mergedTypeParams.subList(this.typeParams.size(), mergedTypeParams.size()));
            }
        } else {
            throw new IllegalArgumentException("Merged type params " + String.valueOf(mergedTypeParams) + " don't match the existing ones " + String.valueOf(this.typeParams));
        }
    }

    public void collectImports(Collection<ClassTypeInfo> imports) {
        this.params.stream().map(ParamInfo::getType).forEach(a -> a.collectImports(imports));
    }

    public MethodInfo copy() {
        return new MethodInfo(new HashSet<ClassTypeInfo>(this.ownerTypes), this.name, this.returnType, this.returnDescription, this.fluent, this.cacheReturn, new ArrayList<ParamInfo>(this.params), this.comment, this.doc, this.staticMethod, this.defaultMethod, new ArrayList<TypeParamInfo.Method>(this.typeParams), this.deprecated, this.deprecatedDesc, this.methodOverride);
    }

    @Override
    public int compareTo(MethodInfo o) {
        int cmp = this.name.compareTo(o.name);
        if (cmp != 0) {
            return cmp;
        }
        Iterator<ParamInfo> i1 = this.params.iterator();
        Iterator<ParamInfo> i2 = o.params.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            ParamInfo p1 = i1.next();
            ParamInfo p2 = i2.next();
            cmp = p1.getType().getRaw().getName().compareTo(p2.getType().getRaw().getName());
            if (cmp == 0) continue;
            return cmp;
        }
        if (i1.hasNext()) {
            if (!i2.hasNext()) {
                return 1;
            }
        } else if (!i2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.typeParams.size() > 0) {
            for (int i = 0; i < this.typeParams.size(); ++i) {
                sb.append(i > 0 ? ", " : "<");
                sb.append(this.typeParams.get(i).getName());
            }
            sb.append("> ");
        }
        sb.append(this.returnType.getName());
        sb.append(' ');
        sb.append(this.getSignature().toString());
        return sb.toString();
    }
}

