/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor.type;

import io.vertx.codegen.processor.Helper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AnnotationValueInfo {
    private String name;
    private String simpleName;
    private String packageName;
    private Map<String, Object> values;

    public AnnotationValueInfo(String name) {
        this(name, new HashMap<String, Object>());
    }

    public AnnotationValueInfo(String name, Map<String, Object> values) {
        this.name = name;
        this.simpleName = Helper.getSimpleName(name);
        this.packageName = Helper.getPackageName(name);
        this.values = values != null ? values : new HashMap();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public void putMember(String memberName, Object memberValue) {
        this.values.put(memberName, memberValue);
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<String> getMembersNames() {
        return this.values.keySet();
    }

    public Object getMember(String name) {
        return this.values.getOrDefault(name, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationValueInfo that = (AnnotationValueInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }
}

