/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.multipart.MultipartForm;
import io.vertx.ext.web.validation.BaseValidationHandlerTest;
import io.vertx.ext.web.validation.RequestPredicate;
import io.vertx.ext.web.validation.ValidationHandler;
import io.vertx.ext.web.validation.testutils.TestRequest;
import io.vertx.ext.web.validation.testutils.ValidationTestUtils;
import io.vertx.json.schema.SchemaParser;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={VertxExtension.class})
public class ValidationHandlerPredicatesIntegrationTest
extends BaseValidationHandlerTest {
    @Test
    public void testRequiredBodyPredicate(VertxTestContext testContext, @TempDir Path tempDir) {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler = ValidationHandler.builder((SchemaParser)this.parser).predicate(RequestPredicate.BODY_REQUIRED).build();
        this.router.route("/testRequiredBody").handler((Handler)BodyHandler.create((String)tempDir.toAbsolutePath().toString())).handler((Handler)validationHandler).handler(routingContext -> routingContext.response().setStatusCode(200).end());
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testRequiredBody").expect(TestRequest.statusCode(200)).sendJson((Object)new JsonObject(), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testRequiredBody").expect(TestRequest.statusCode(400), ValidationTestUtils.failurePredicateResponse()).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testRequiredBody").expect(TestRequest.statusCode(400), ValidationTestUtils.failurePredicateResponse()).send(testContext, checkpoint);
    }

    @Test
    public void testFileUploadExists(VertxTestContext testContext, @TempDir Path tempDir) {
        Checkpoint checkpoint = testContext.checkpoint(4);
        ValidationHandler validationHandler = ValidationHandler.builder((SchemaParser)this.parser).predicate(RequestPredicate.multipartFileUploadExists((String)"myfile", (String)Pattern.quote("text/plain"))).build();
        this.router.post("/testFileUpload").handler((Handler)BodyHandler.create((String)tempDir.toAbsolutePath().toString())).handler((Handler)validationHandler).handler(routingContext -> routingContext.response().setStatusCode(200).end());
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFileUpload").expect(TestRequest.statusCode(200)).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFileUpload").expect(TestRequest.statusCode(400)).sendMultipartForm(MultipartForm.create(), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFileUpload").expect(TestRequest.statusCode(400)).sendMultipartForm(MultipartForm.create().attribute("myfile", "bla"), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFileUpload").expect(TestRequest.statusCode(200)).sendMultipartForm(MultipartForm.create().textFileUpload("myfile", "myfile.txt", "src/test/resources/myfile.txt", "text/plain"), testContext, checkpoint);
    }
}

