/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.impl.parameter.DeepObjectValueParameterParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.testutils.TestParsers;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
public class DeepObjectValueParameterParserTest {
    SchemaRouter router;
    SchemaParser parser;

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testValid() {
        DeepObjectValueParameterParser parser = new DeepObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bla[prop1]", Collections.singletonList("1"));
        map.put("bla[prop2]", Collections.singletonList("2.1"));
        map.put("bla[prop3]", Collections.singletonList("aaa"));
        map.put("bla[prop4]", Collections.singletonList("true"));
        map.put("bla[other]", Collections.singletonList("hello"));
        map.put("other", Collections.singletonList("francesco"));
        map.put("other[bla]", Collections.singletonList("world"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT.copy().put("other", (Object)"hello"));
        });
        Assertions.assertThat(map).containsKeys((Object[])new String[]{"other", "other[bla]"});
    }

    @Test
    public void testNoAdditionalProperties() {
        DeepObjectValueParameterParser parser = new DeepObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, null);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bla[prop1]", Collections.singletonList("1"));
        map.put("bla[prop2]", Collections.singletonList("2.1"));
        map.put("bla[prop3]", Collections.singletonList("aaa"));
        map.put("bla[prop4]", Collections.singletonList("true"));
        map.put("bla[other]", Collections.singletonList("hello"));
        map.put("other", Collections.singletonList("francesco"));
        map.put("other[bla]", Collections.singletonList("world"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT.copy().put("other", (Object)"hello"));
        });
        Assertions.assertThat(map).containsKeys((Object[])new String[]{"other", "other[bla]"});
    }

    @Test
    public void testNull() {
        DeepObjectValueParameterParser parser = new DeepObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bla[prop1]", Collections.singletonList("1"));
        map.put("bla[prop2]", Collections.singletonList(""));
        map.put("bla[prop3]", Collections.singletonList(null));
        map.put("bla[prop4]", Collections.singletonList("true"));
        map.put("bla[other]", Collections.singletonList("hello"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT.copy().put("other", (Object)"hello").putNull("prop2").putNull("prop3"));
        });
        Assertions.assertThat(map).isEmpty();
    }

    @Test
    public void testEmptyString() {
        DeepObjectValueParameterParser parser = new DeepObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bla[prop1]", Collections.singletonList("1"));
        map.put("bla[prop2]", Collections.singletonList("2.1"));
        map.put("bla[prop3]", Collections.singletonList(""));
        map.put("bla[prop4]", Collections.singletonList("true"));
        map.put("bla[other]", Collections.singletonList("hello"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT.copy().put("other", (Object)"hello").put("prop3", (Object)""));
        });
        Assertions.assertThat(map).isEmpty();
    }

    @Test
    public void testMissingProp() {
        DeepObjectValueParameterParser parser = new DeepObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bla[prop1]", Collections.singletonList("1"));
        map.put("bla[prop3]", Collections.singletonList("aaa"));
        Object result = parser.parseParameter(map);
        JsonObject expected = TestParsers.SAMPLE_OBJECT.copy();
        expected.remove("prop2");
        expected.remove("prop4");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)expected);
        });
        Assertions.assertThat(map).isEmpty();
    }

    @Test
    public void testInvalid() {
        DeepObjectValueParameterParser parser = new DeepObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bla[prop1]", Collections.singletonList("1"));
        map.put("bla[prop2]", Collections.singletonList("bla"));
        map.put("bla[prop3]", Collections.singletonList("aaa"));
        map.put("bla[prop4]", Collections.singletonList("true"));
        map.put("bla[other]", Collections.singletonList("hello"));
        map.put("other", Collections.singletonList("francesco"));
        map.put("other[bla]", Collections.singletonList("world"));
        Assertions.assertThatExceptionOfType(MalformedValueException.class).isThrownBy(() -> parser.parseParameter(map));
    }
}

