/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.DecodeException;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.validation.BodyProcessorException;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.builder.Bodies;
import io.vertx.ext.web.validation.impl.body.BodyProcessor;
import io.vertx.ext.web.validation.testutils.TestSchemas;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.dsl.SchemaBuilder;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.json.schema.draft7.dsl.Schemas;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Extensions(value={@ExtendWith(value={VertxExtension.class}), @ExtendWith(value={MockitoExtension.class})})
class JsonBodyProcessorImplTest {
    SchemaRouter router;
    SchemaParser parser;
    @Mock
    RoutingContext mockedContext;
    @Mock
    HttpServerRequest mockerServerRequest;

    JsonBodyProcessorImplTest() {
    }

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testContentTypeCheck() {
        BodyProcessor processor = Bodies.json((SchemaBuilder)TestSchemas.SAMPLE_OBJECT_SCHEMA_BUILDER).create(this.parser);
        Assertions.assertThat((boolean)processor.canProcess("application/json")).isTrue();
        Assertions.assertThat((boolean)processor.canProcess("application/json; charset=utf-8")).isTrue();
        Assertions.assertThat((boolean)processor.canProcess("application/superapplication+json")).isTrue();
    }

    @Test
    public void testJsonObject(VertxTestContext testContext) {
        Mockito.when((Object)this.mockedContext.getBody()).thenReturn((Object)TestSchemas.VALID_OBJECT.toBuffer());
        BodyProcessor processor = Bodies.json((SchemaBuilder)TestSchemas.SAMPLE_OBJECT_SCHEMA_BUILDER).create(this.parser);
        processor.process(this.mockedContext).onComplete(testContext.succeeding(rp -> {
            testContext.verify(() -> {
                Assertions.assertThat((boolean)rp.isJsonObject()).isTrue();
                Assertions.assertThat((Iterable)rp.getJsonObject()).isEqualTo((Object)TestSchemas.VALID_OBJECT);
            });
            testContext.completeNow();
        }));
    }

    @Test
    public void testInvalidJsonObject(VertxTestContext testContext) {
        Mockito.when((Object)this.mockerServerRequest.getHeader(HttpHeaders.CONTENT_TYPE)).thenReturn((Object)"application/json");
        Mockito.when((Object)this.mockedContext.request()).thenReturn((Object)this.mockerServerRequest);
        Mockito.when((Object)this.mockedContext.getBody()).thenReturn((Object)TestSchemas.INVALID_OBJECT.toBuffer());
        BodyProcessor processor = Bodies.json((SchemaBuilder)TestSchemas.SAMPLE_OBJECT_SCHEMA_BUILDER).create(this.parser);
        processor.process(this.mockedContext).onComplete(testContext.failing(err -> {
            testContext.verify(() -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)err).isInstanceOf(BodyProcessorException.class)).hasFieldOrPropertyWithValue("actualContentType", (Object)"application/json")).hasCauseInstanceOf(ValidationException.class));
            testContext.completeNow();
        }));
    }

    @Test
    public void testJsonArray(VertxTestContext testContext) {
        Mockito.when((Object)this.mockedContext.getBody()).thenReturn((Object)TestSchemas.VALID_ARRAY.toBuffer());
        BodyProcessor processor = Bodies.json((SchemaBuilder)TestSchemas.SAMPLE_ARRAY_SCHEMA_BUILDER).create(this.parser);
        processor.process(this.mockedContext).onComplete(testContext.succeeding(rp -> {
            testContext.verify(() -> {
                Assertions.assertThat((boolean)rp.isJsonArray()).isTrue();
                Assertions.assertThat((Iterable)rp.getJsonArray()).isEqualTo((Object)TestSchemas.VALID_ARRAY);
            });
            testContext.completeNow();
        }));
    }

    @Test
    public void testInvalidJsonArray(VertxTestContext testContext) {
        Mockito.when((Object)this.mockerServerRequest.getHeader(HttpHeaders.CONTENT_TYPE)).thenReturn((Object)"application/json");
        Mockito.when((Object)this.mockedContext.request()).thenReturn((Object)this.mockerServerRequest);
        Mockito.when((Object)this.mockedContext.getBody()).thenReturn((Object)TestSchemas.INVALID_ARRAY.toBuffer());
        BodyProcessor processor = Bodies.json((SchemaBuilder)TestSchemas.SAMPLE_ARRAY_SCHEMA_BUILDER).create(this.parser);
        processor.process(this.mockedContext).onComplete(testContext.failing(err -> {
            testContext.verify(() -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)err).isInstanceOf(BodyProcessorException.class)).hasFieldOrPropertyWithValue("actualContentType", (Object)"application/json")).hasCauseInstanceOf(ValidationException.class));
            testContext.completeNow();
        }));
    }

    @Test
    public void testMalformedJson() {
        Mockito.when((Object)this.mockerServerRequest.getHeader(HttpHeaders.CONTENT_TYPE)).thenReturn((Object)"application/json");
        Mockito.when((Object)this.mockedContext.request()).thenReturn((Object)this.mockerServerRequest);
        Mockito.when((Object)this.mockedContext.getBody()).thenReturn((Object)Buffer.buffer((String)"{\"a"));
        BodyProcessor processor = Bodies.json((SchemaBuilder)TestSchemas.SAMPLE_ARRAY_SCHEMA_BUILDER).create(this.parser);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatCode(() -> processor.process(this.mockedContext)).isInstanceOf(BodyProcessorException.class)).hasFieldOrPropertyWithValue("actualContentType", (Object)"application/json")).hasCauseInstanceOf(DecodeException.class);
    }

    @Test
    public void testNull(VertxTestContext testContext) {
        Mockito.when((Object)this.mockedContext.getBody()).thenReturn((Object)Buffer.buffer((String)"null"));
        BodyProcessor processor = Bodies.json((SchemaBuilder)Schemas.schema().withKeyword("type", (Object)"null")).create(this.parser);
        processor.process(this.mockedContext).onComplete(testContext.succeeding(rp -> {
            testContext.verify(() -> Assertions.assertThat((boolean)rp.isNull()).isTrue());
            testContext.completeNow();
        }));
    }

    @Test
    public void testNullBody() {
        Mockito.when((Object)this.mockerServerRequest.getHeader(HttpHeaders.CONTENT_TYPE)).thenReturn((Object)"application/json");
        Mockito.when((Object)this.mockedContext.request()).thenReturn((Object)this.mockerServerRequest);
        Mockito.when((Object)this.mockedContext.getBody()).thenReturn(null);
        BodyProcessor processor = Bodies.json((SchemaBuilder)Schemas.schema().withKeyword("type", (Object)"null")).create(this.parser);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatCode(() -> processor.process(this.mockedContext)).isInstanceOf(BodyProcessorException.class)).hasFieldOrPropertyWithValue("actualContentType", (Object)"application/json")).hasCauseInstanceOf(MalformedValueException.class);
    }
}

