/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.ParameterProcessorException;
import io.vertx.ext.web.validation.RequestParameter;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.parameter.ParameterParser;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessorImpl;
import io.vertx.ext.web.validation.impl.validator.ValueValidator;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Extensions(value={@ExtendWith(value={VertxExtension.class}), @ExtendWith(value={MockitoExtension.class})})
public class ParameterProcessorUnitTest {
    SchemaRouter router;
    SchemaParser parser;
    @Mock
    ParameterParser mockedParser;
    @Mock
    ValueValidator mockedValidator;

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testRequiredParam() {
        ParameterProcessorImpl processor = new ParameterProcessorImpl("myParam", ParameterLocation.QUERY, false, this.mockedParser, this.mockedValidator);
        Mockito.when((Object)this.mockedParser.parseParameter((Map)ArgumentMatchers.any())).thenReturn(null);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatCode(() -> ParameterProcessorUnitTest.lambda$testRequiredParam$0((ParameterProcessor)processor)).isInstanceOf(ParameterProcessorException.class)).hasFieldOrPropertyWithValue("errorType", (Object)ParameterProcessorException.ParameterProcessorErrorType.MISSING_PARAMETER_WHEN_REQUIRED_ERROR)).hasFieldOrPropertyWithValue("location", (Object)ParameterLocation.QUERY)).hasFieldOrPropertyWithValue("parameterName", (Object)"myParam")).hasNoCause();
    }

    @Test
    public void testOptionalParam(VertxTestContext testContext) {
        ParameterProcessorImpl processor = new ParameterProcessorImpl("myParam", ParameterLocation.QUERY, true, this.mockedParser, this.mockedValidator);
        Mockito.when((Object)this.mockedParser.parseParameter((Map)ArgumentMatchers.any())).thenReturn(null);
        processor.process(new HashMap()).onComplete(testContext.succeeding(value -> {
            testContext.verify(() -> Assertions.assertThat((Object)value).isNull());
            testContext.completeNow();
        }));
    }

    @Test
    public void testOptionalParamWithDefault(VertxTestContext testContext) {
        ParameterProcessorImpl processor = new ParameterProcessorImpl("myParam", ParameterLocation.QUERY, true, this.mockedParser, this.mockedValidator);
        Mockito.when((Object)this.mockedParser.parseParameter((Map)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.mockedValidator.getDefault()).thenReturn((Object)"bla");
        processor.process(new HashMap()).onComplete(testContext.succeeding(value -> {
            testContext.verify(() -> Assertions.assertThat((String)value.getString()).isEqualTo("bla"));
            testContext.completeNow();
        }));
    }

    @Test
    public void testParsingFailure() {
        ParameterProcessorImpl processor = new ParameterProcessorImpl("myParam", ParameterLocation.QUERY, false, this.mockedParser, this.mockedValidator);
        Mockito.when((Object)this.mockedParser.parseParameter((Map)ArgumentMatchers.any())).thenThrow(new Throwable[]{new MalformedValueException("bla")});
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatCode(() -> ParameterProcessorUnitTest.lambda$testParsingFailure$5((ParameterProcessor)processor)).isInstanceOf(ParameterProcessorException.class)).hasFieldOrPropertyWithValue("errorType", (Object)ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR)).hasFieldOrPropertyWithValue("location", (Object)ParameterLocation.QUERY)).hasFieldOrPropertyWithValue("parameterName", (Object)"myParam")).hasCauseInstanceOf(MalformedValueException.class);
    }

    @Test
    public void testValidation(VertxTestContext testContext) {
        ParameterProcessorImpl processor = new ParameterProcessorImpl("myParam", ParameterLocation.QUERY, true, this.mockedParser, this.mockedValidator);
        Mockito.when((Object)this.mockedParser.parseParameter((Map)ArgumentMatchers.any())).thenReturn((Object)"aaa");
        Mockito.when((Object)this.mockedValidator.validate(ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture((Object)RequestParameter.create((Object)"aaa")));
        processor.process(new HashMap()).onComplete(testContext.succeeding(rp -> {
            testContext.verify(() -> {
                Assertions.assertThat((boolean)rp.isString()).isTrue();
                Assertions.assertThat((String)rp.getString()).isEqualTo("aaa");
            });
            testContext.completeNow();
        }));
    }

    @Test
    public void testValidationFailure(VertxTestContext testContext) {
        ParameterProcessorImpl processor = new ParameterProcessorImpl("myParam", ParameterLocation.QUERY, true, this.mockedParser, this.mockedValidator);
        Mockito.when((Object)this.mockedParser.parseParameter((Map)ArgumentMatchers.any())).thenReturn((Object)"aaa");
        Mockito.when((Object)this.mockedValidator.validate(ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)ValidationException.createException((String)"aaa", (String)"aaa", (Object)"aaa")));
        processor.process(new HashMap()).onComplete(testContext.failing(throwable -> {
            testContext.verify(() -> ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isInstanceOf(ParameterProcessorException.class)).hasFieldOrPropertyWithValue("errorType", (Object)ParameterProcessorException.ParameterProcessorErrorType.VALIDATION_ERROR)).hasFieldOrPropertyWithValue("location", (Object)ParameterLocation.QUERY)).hasFieldOrPropertyWithValue("parameterName", (Object)"myParam")).hasCauseInstanceOf(ValidationException.class));
            testContext.completeNow();
        }));
    }

    private static /* synthetic */ void lambda$testParsingFailure$5(ParameterProcessor processor) throws Throwable {
        processor.process(new HashMap());
    }

    private static /* synthetic */ void lambda$testRequiredParam$0(ParameterProcessor processor) throws Throwable {
        processor.process(new HashMap());
    }
}

