/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation;

import io.netty.handler.codec.http.QueryStringEncoder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.multipart.MultipartForm;
import io.vertx.ext.web.validation.BaseValidationHandlerTest;
import io.vertx.ext.web.validation.BodyProcessorException;
import io.vertx.ext.web.validation.ParameterProcessorException;
import io.vertx.ext.web.validation.RequestParameters;
import io.vertx.ext.web.validation.ValidationHandler;
import io.vertx.ext.web.validation.builder.ArrayParserFactory;
import io.vertx.ext.web.validation.builder.Bodies;
import io.vertx.ext.web.validation.builder.Parameters;
import io.vertx.ext.web.validation.builder.Parsers;
import io.vertx.ext.web.validation.builder.ValidationHandlerBuilder;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.testutils.TestRequest;
import io.vertx.ext.web.validation.testutils.ValidationTestUtils;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.common.dsl.ArraySchemaBuilder;
import io.vertx.json.schema.common.dsl.BooleanSchemaBuilder;
import io.vertx.json.schema.common.dsl.Keyword;
import io.vertx.json.schema.common.dsl.NumberSchemaBuilder;
import io.vertx.json.schema.common.dsl.ObjectSchemaBuilder;
import io.vertx.json.schema.common.dsl.SchemaBuilder;
import io.vertx.json.schema.common.dsl.StringSchemaBuilder;
import io.vertx.json.schema.draft7.dsl.Keywords;
import io.vertx.json.schema.draft7.dsl.Schemas;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.net.URI;
import java.nio.file.Path;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={VertxExtension.class})
public class ValidationHandlerProcessorsIntegrationTest
extends BaseValidationHandlerTest {
    @Test
    public void testPathParamsSimpleTypes(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).pathParameter(Parameters.param((String)"a", (StringSchemaBuilder)Schemas.stringSchema())).pathParameter(Parameters.param((String)"b", (BooleanSchemaBuilder)Schemas.booleanSchema())).pathParameter(Parameters.param((String)"c", (NumberSchemaBuilder)Schemas.intSchema())).build();
        this.router.get("/testPathParams/:a/:b/:c").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.pathParameter("a").getString() + params.pathParameter("b").getBoolean() + params.pathParameter("c").getInteger()).end();
        });
        String a = "hello";
        String b = "true";
        String c = "10";
        TestRequest.testRequest(this.client, HttpMethod.GET, String.format("/testPathParams/%s/%s/%s", a, b, c)).expect(TestRequest.statusCode(200), TestRequest.statusMessage(a + b + c)).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testPathParams/hello/bla/10").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "b", ParameterLocation.PATH)).send(testContext, checkpoint);
    }

    @Test
    public void testQueryParamsSimpleTypes(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).queryParameter(Parameters.param((String)"param1", (BooleanSchemaBuilder)Schemas.booleanSchema())).queryParameter(Parameters.param((String)"param2", (NumberSchemaBuilder)Schemas.intSchema())).build();
        this.router.get("/testQueryParams").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("param1").getBoolean().toString() + params.queryParameter("param2").getInteger().toString()).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testQueryParams?param1=true&param2=10").expect(TestRequest.statusCode(200), TestRequest.statusMessage("true10")).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testQueryParams?param1=true&param2=bla").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "param2", ParameterLocation.QUERY)).send(testContext, checkpoint);
    }

    @Test
    public void testQueryJsonObjectAsyncParam(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).queryParameter(Parameters.jsonParam((String)"myTree", (SchemaBuilder)Schemas.ref((JsonPointer)JsonPointer.fromURI((URI)URI.create("tree_schema.json"))))).build();
        this.router.get("/test").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().putHeader("content-type", "application/json").end(params.queryParameter("myTree").getJsonObject().toBuffer());
        });
        JsonObject testSuccessObj = new JsonObject().put("value", (Object)"aaa").put("childs", (Object)new JsonArray().add((Object)new JsonObject().put("value", (Object)"bbb")));
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?myTree=" + TestRequest.urlEncode(testSuccessObj.encode())).expect(TestRequest.statusCode(200), TestRequest.jsonBodyResponse(testSuccessObj)).send(testContext, checkpoint);
        JsonObject testFailureObj = testSuccessObj.copy();
        testFailureObj.remove("value");
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?myTree=" + TestRequest.urlEncode(testFailureObj.encode())).expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.VALIDATION_ERROR, "myTree", ParameterLocation.QUERY)).send(testContext, checkpoint);
    }

    @Test
    public void testQueryParamsAsyncValidation(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(4);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).queryParameter(Parameters.param((String)"param1", (BooleanSchemaBuilder)Schemas.booleanSchema())).queryParameter(Parameters.param((String)"param2", (SchemaBuilder)Schemas.ref((JsonPointer)JsonPointer.fromURI((URI)URI.create("int_schema.json"))), (ValueParser)ValueParser.LONG_PARSER)).build();
        this.router.get("/test").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("param1").getBoolean().toString() + params.queryParameter("param2").getInteger().toString()).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?param1=true&param2=5").expect(TestRequest.statusCode(200), TestRequest.statusMessage("true5")).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?param1=bla&param2=5").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "param1", ParameterLocation.QUERY)).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?param1=true&param2=bla").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "param2", ParameterLocation.QUERY)).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?param1=true&param2=15").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.VALIDATION_ERROR, "param2", ParameterLocation.QUERY)).send(testContext, checkpoint);
    }

    @Test
    public void testQueryParamOptional(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(3);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).queryParameter(Parameters.param((String)"param1", (BooleanSchemaBuilder)Schemas.booleanSchema())).queryParameter(Parameters.optionalParam((String)"param2", (NumberSchemaBuilder)Schemas.intSchema())).build();
        this.router.get("/testQueryParams").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage("" + params.queryParameter("param1") + params.queryParameter("param2")).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testQueryParams?param1=true&param2=10").expect(TestRequest.statusCode(200), TestRequest.statusMessage("true10")).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testQueryParams?param1=true").expect(TestRequest.statusCode(200), TestRequest.statusMessage("truenull")).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testQueryParams?param1=true&param2=bla").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "param2", ParameterLocation.QUERY)).send(testContext, checkpoint);
    }

    @Test
    public void testQueryParamArrayExploded(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(3);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).queryParameter(Parameters.explodedParam((String)"parameter", (ArraySchemaBuilder)Schemas.arraySchema().items(Schemas.intSchema().with((Keyword)Keywords.multipleOf((double)2.0))))).build();
        this.router.get("/test").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("parameter").getJsonArray().stream().map(Object::toString).collect(Collectors.joining(","))).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?parameter=2&parameter=4&parameter=6").expect(TestRequest.statusCode(200), TestRequest.statusMessage("2,4,6")).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?parameter=2&parameter=2&parameter=false").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "parameter", ParameterLocation.QUERY)).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?parameter=2&parameter=2&parameter=1").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.VALIDATION_ERROR, "parameter", ParameterLocation.QUERY)).send(testContext, checkpoint);
    }

    @Test
    public void testQueryParamArrayCommaSeparated(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(3);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).queryParameter(Parameters.serializedParam((String)"parameter", (ArrayParserFactory)Parsers.commaSeparatedArrayParser(), (ArraySchemaBuilder)Schemas.arraySchema().items(Schemas.intSchema().with((Keyword)Keywords.multipleOf((double)2.0))))).build();
        this.router.get("/test").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("parameter").getJsonArray().stream().map(Object::toString).collect(Collectors.joining(","))).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?parameter=" + TestRequest.urlEncode("2,4,6")).expect(TestRequest.statusCode(200), TestRequest.statusMessage("2,4,6")).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?parameter=" + TestRequest.urlEncode("1,false,3")).expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "parameter", ParameterLocation.QUERY)).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?parameter=" + TestRequest.urlEncode("6,2,1")).expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.VALIDATION_ERROR, "parameter", ParameterLocation.QUERY)).send(testContext, checkpoint);
    }

    @Test
    public void testQueryParamDefault(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(3);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).queryParameter(Parameters.optionalParam((String)"param1", (NumberSchemaBuilder)((NumberSchemaBuilder)Schemas.intSchema().defaultValue((Object)10)))).queryParameter(Parameters.param((String)"param2", (NumberSchemaBuilder)Schemas.intSchema())).build();
        this.router.get("/test").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage("" + params.queryParameter("param1") + params.queryParameter("param2")).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?param1=5&param2=10").expect(TestRequest.statusCode(200), TestRequest.statusMessage("510")).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?param2=10").expect(TestRequest.statusCode(200), TestRequest.statusMessage("1010")).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?param1=5").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.MISSING_PARAMETER_WHEN_REQUIRED_ERROR, "param2", ParameterLocation.QUERY)).send(testContext, checkpoint);
    }

    @Test
    public void testQueryArrayParamsArrayAndPathParam(VertxTestContext testContext) throws Exception {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).pathParameter(Parameters.param((String)"pathParam", (BooleanSchemaBuilder)Schemas.booleanSchema())).queryParameter(Parameters.explodedParam((String)"awesomeArray", (ArraySchemaBuilder)Schemas.arraySchema().items((SchemaBuilder)Schemas.intSchema()))).queryParameter(Parameters.param((String)"anotherParam", (NumberSchemaBuilder)Schemas.numberSchema())).build();
        this.router.get("/testQueryParams/:pathParam").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.pathParameter("pathParam").toString() + params.queryParameter("awesomeArray").toString() + params.queryParameter("anotherParam").toString()).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testQueryParams/true?awesomeArray=1&awesomeArray=2&awesomeArray=3&anotherParam=5.2").expect(TestRequest.statusCode(200), TestRequest.statusMessage("true" + new JsonArray().add((Object)1).add((Object)2).add((Object)3).toString() + "5.2")).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testQueryParams/true?awesomeArray=1&awesomeArray=bla&awesomeArray=3&anotherParam=5.2").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "awesomeArray", ParameterLocation.QUERY)).send(testContext, checkpoint);
    }

    @Test
    public void testHeaderParamsSimpleTypes(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).headerParameter(Parameters.param((String)"x-a", (StringSchemaBuilder)Schemas.stringSchema())).headerParameter(Parameters.param((String)"x-b", (BooleanSchemaBuilder)Schemas.booleanSchema())).headerParameter(Parameters.param((String)"x-c", (NumberSchemaBuilder)Schemas.intSchema())).build();
        this.router.get("/testHeaderParams").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(String.format("%s%s%s", params.headerParameter("x-a"), params.headerParameter("x-b"), params.headerParameter("x-c"))).end();
        });
        String a = "hello";
        String b = "false";
        String c = "10";
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testHeaderParams").with(TestRequest.requestHeader("x-a", a), TestRequest.requestHeader("x-b", b), TestRequest.requestHeader("x-c", c)).expect(TestRequest.statusCode(200), TestRequest.statusMessage(a + b + c)).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testHeaderParams").with(TestRequest.requestHeader("x-a", a), TestRequest.requestHeader("x-b", "bla"), TestRequest.requestHeader("x-c", c)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "x-b", ParameterLocation.HEADER)).send(testContext, checkpoint);
    }

    @Test
    public void testHeaderParamsAsync(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(4);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).headerParameter(Parameters.param((String)"x-a", (StringSchemaBuilder)Schemas.stringSchema())).headerParameter(Parameters.param((String)"x-b", (BooleanSchemaBuilder)Schemas.booleanSchema())).headerParameter(Parameters.param((String)"x-c", (SchemaBuilder)Schemas.ref((JsonPointer)JsonPointer.fromURI((URI)URI.create("int_schema.json"))), (ValueParser)ValueParser.LONG_PARSER)).build();
        this.router.get("/test").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(String.format("%s%s%s", params.headerParameter("x-a"), params.headerParameter("x-b"), params.headerParameter("x-c"))).end();
        });
        String a = "hello";
        String b = "false";
        String c = "10";
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test").with(TestRequest.requestHeader("x-a", a), TestRequest.requestHeader("x-b", b), TestRequest.requestHeader("x-c", c)).expect(TestRequest.statusCode(200), TestRequest.statusMessage(a + b + c)).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test").with(TestRequest.requestHeader("x-a", a), TestRequest.requestHeader("x-b", "bla"), TestRequest.requestHeader("x-c", c)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "x-b", ParameterLocation.HEADER)).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test").with(TestRequest.requestHeader("x-a", a), TestRequest.requestHeader("x-b", b), TestRequest.requestHeader("x-c", "bla")).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "x-c", ParameterLocation.HEADER)).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test").with(TestRequest.requestHeader("x-a", a), TestRequest.requestHeader("x-b", b), TestRequest.requestHeader("x-c", "15")).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.VALIDATION_ERROR, "x-c", ParameterLocation.HEADER)).send(testContext, checkpoint);
    }

    @Test
    public void testCookieParamsSimpleTypes(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).cookieParameter(Parameters.param((String)"param1", (BooleanSchemaBuilder)Schemas.booleanSchema())).cookieParameter(Parameters.param((String)"param2", (NumberSchemaBuilder)Schemas.intSchema())).build();
        this.router.get("/testCookieParams").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.cookieParameter("param1").toString() + params.cookieParameter("param2").toString()).end();
        });
        QueryStringEncoder successParams = new QueryStringEncoder("/");
        successParams.addParam("param1", "true");
        successParams.addParam("param2", "10");
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testCookieParams").with(TestRequest.cookie(successParams)).expect(TestRequest.statusCode(200), TestRequest.statusMessage("true10")).send(testContext, checkpoint);
        QueryStringEncoder failureParams = new QueryStringEncoder("/");
        failureParams.addParam("param1", "true");
        failureParams.addParam("param2", "bla");
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testCookieParams").with(TestRequest.cookie(failureParams)).expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "param2", ParameterLocation.COOKIE)).send(testContext, checkpoint);
    }

    @Test
    public void testCookieParamsAsync(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(3);
        ValidationHandler validationHandler = ValidationHandlerBuilder.create((SchemaParser)this.parser).cookieParameter(Parameters.param((String)"param1", (BooleanSchemaBuilder)Schemas.booleanSchema())).cookieParameter(Parameters.param((String)"param2", (SchemaBuilder)Schemas.ref((JsonPointer)JsonPointer.fromURI((URI)URI.create("int_schema.json"))), (ValueParser)ValueParser.LONG_PARSER)).build();
        this.router.get("/test").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.cookieParameter("param1").toString() + params.cookieParameter("param2").toString()).end();
        });
        QueryStringEncoder successParams = new QueryStringEncoder("/");
        successParams.addParam("param1", "true");
        successParams.addParam("param2", "10");
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test").with(TestRequest.cookie(successParams)).expect(TestRequest.statusCode(200), TestRequest.statusMessage("true10")).send(testContext, checkpoint);
        QueryStringEncoder failureParams1 = new QueryStringEncoder("/");
        failureParams1.addParam("param1", "true");
        failureParams1.addParam("param2", "bla");
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test").with(TestRequest.cookie(failureParams1)).expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "param2", ParameterLocation.COOKIE)).send(testContext, checkpoint);
        QueryStringEncoder failureParams2 = new QueryStringEncoder("/");
        failureParams2.addParam("param1", "true");
        failureParams2.addParam("param2", "15");
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test").with(TestRequest.cookie(failureParams2)).expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.VALIDATION_ERROR, "param2", ParameterLocation.COOKIE)).send(testContext, checkpoint);
    }

    @Test
    public void testFormURLEncoded(VertxTestContext testContext, @TempDir Path tempDir) throws Exception {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler = ValidationHandler.builder((SchemaParser)this.parser).body(Bodies.formUrlEncoded((ObjectSchemaBuilder)Schemas.objectSchema().requiredProperty("parameter", (SchemaBuilder)Schemas.intSchema()))).build();
        this.router.route().handler((Handler)BodyHandler.create((String)tempDir.toAbsolutePath().toString()));
        this.router.post("/testFormParam").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.body().getJsonObject().getInteger("parameter").toString()).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(200), TestRequest.statusMessage("5")).sendURLEncodedForm(MultiMap.caseInsensitiveMultiMap().add("parameter", "5"), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badBodyResponse(BodyProcessorException.BodyProcessorErrorType.PARSING_ERROR)).sendURLEncodedForm(MultiMap.caseInsensitiveMultiMap().add("parameter", "bla"), testContext, checkpoint);
    }

    @Test
    public void testMultipartForm(VertxTestContext testContext, @TempDir Path tempDir) throws Exception {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler = ValidationHandler.builder((SchemaParser)this.parser).body(Bodies.multipartFormData((ObjectSchemaBuilder)Schemas.objectSchema().requiredProperty("parameter", (SchemaBuilder)Schemas.intSchema()))).build();
        this.router.route().handler((Handler)BodyHandler.create((String)tempDir.toAbsolutePath().toString()));
        this.router.post("/testFormParam").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.body().getJsonObject().getInteger("parameter").toString()).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(200), TestRequest.statusMessage("5")).sendMultipartForm(MultipartForm.create().attribute("parameter", "5"), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badBodyResponse(BodyProcessorException.BodyProcessorErrorType.PARSING_ERROR)).sendMultipartForm(MultipartForm.create().attribute("parameter", "bla"), testContext, checkpoint);
    }

    @Test
    public void testBothFormTypes(VertxTestContext testContext, @TempDir Path tempDir) throws Exception {
        Checkpoint checkpoint = testContext.checkpoint(6);
        ObjectSchemaBuilder bodySchema = Schemas.objectSchema().requiredProperty("parameter", (SchemaBuilder)Schemas.intSchema());
        ValidationHandler validationHandler = ValidationHandler.builder((SchemaParser)this.parser).body(Bodies.multipartFormData((ObjectSchemaBuilder)bodySchema)).body(Bodies.formUrlEncoded((ObjectSchemaBuilder)bodySchema)).build();
        this.router.route().handler((Handler)BodyHandler.create((String)tempDir.toAbsolutePath().toString()));
        this.router.post("/testFormParam").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            if (params.body() != null) {
                routingContext.response().setStatusMessage(params.body().getJsonObject().getInteger("parameter").toString()).end();
            } else {
                routingContext.response().setStatusMessage("No body").end();
            }
        });
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(200), TestRequest.statusMessage("5")).sendURLEncodedForm(MultiMap.caseInsensitiveMultiMap().add("parameter", "5"), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badBodyResponse(BodyProcessorException.BodyProcessorErrorType.PARSING_ERROR)).sendURLEncodedForm(MultiMap.caseInsensitiveMultiMap().add("parameter", "bla"), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(200), TestRequest.statusMessage("5")).sendMultipartForm(MultipartForm.create().attribute("parameter", "5"), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badBodyResponse(BodyProcessorException.BodyProcessorErrorType.PARSING_ERROR)).sendMultipartForm(MultipartForm.create().attribute("parameter", "bla"), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(200), TestRequest.statusMessage("No body")).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badBodyResponse(BodyProcessorException.BodyProcessorErrorType.MISSING_MATCHING_BODY_PROCESSOR)).sendJson((Object)new JsonObject(), testContext, checkpoint);
    }

    @Test
    public void testSameResultWithDifferentBodyTypes(VertxTestContext testContext, @TempDir Path tempDir) throws Exception {
        Checkpoint checkpoint = testContext.checkpoint(3);
        JsonObject expectedResult = new JsonObject().put("int", (Object)10).put("string", (Object)"hello").put("array", (Object)new JsonArray().add((Object)1).add((Object)1.1));
        ObjectSchemaBuilder bodySchema = Schemas.objectSchema().requiredProperty("int", (SchemaBuilder)Schemas.intSchema()).requiredProperty("string", (SchemaBuilder)Schemas.stringSchema()).property("array", (SchemaBuilder)Schemas.arraySchema().items((SchemaBuilder)Schemas.numberSchema()));
        ValidationHandler validationHandler = ValidationHandler.builder((SchemaParser)this.parser).body(Bodies.json((SchemaBuilder)bodySchema)).body(Bodies.multipartFormData((ObjectSchemaBuilder)bodySchema)).body(Bodies.formUrlEncoded((ObjectSchemaBuilder)bodySchema)).build();
        this.router.route().handler((Handler)BodyHandler.create((String)tempDir.toAbsolutePath().toString()));
        this.router.post("/testFormParam").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            if (params.body().getJsonObject().equals((Object)expectedResult)) {
                routingContext.response().setStatusCode(200).end();
            } else {
                routingContext.response().setStatusCode(500).end();
            }
        });
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(200)).sendURLEncodedForm(MultiMap.caseInsensitiveMultiMap().add("int", "10").add("string", "hello").add("array", "1").add("array", "1.1"), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(200)).sendMultipartForm(MultipartForm.create().attribute("int", "10").attribute("string", "hello").attribute("array", "1").attribute("array", "1.1"), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/testFormParam").expect(TestRequest.statusCode(200)).sendJson((Object)expectedResult, testContext, checkpoint);
    }

    @Test
    public void testValidationHandlerChaining(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(1);
        ValidationHandler validationHandler1 = ValidationHandler.builder((SchemaParser)this.parser).queryParameter(Parameters.param((String)"param1", (NumberSchemaBuilder)Schemas.intSchema())).build();
        ValidationHandler validationHandler2 = ValidationHandler.builder((SchemaParser)this.parser).queryParameter(Parameters.param((String)"param2", (BooleanSchemaBuilder)Schemas.booleanSchema())).build();
        this.router.get("/testHandlersChaining").handler((Handler)validationHandler1).handler((Handler)validationHandler2).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("param1").toString() + params.queryParameter("param2").toString()).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.GET, "/testHandlersChaining?param1=10&param2=true").expect(TestRequest.statusCode(200), TestRequest.statusMessage("10true")).send(testContext, checkpoint);
    }

    @Test
    public void testJsonBody(VertxTestContext testContext, @TempDir Path tempDir) {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler = ValidationHandler.builder((SchemaParser)this.parser).body(Bodies.json((SchemaBuilder)Schemas.objectSchema())).build();
        this.router.post("/test").handler((Handler)BodyHandler.create((String)tempDir.toAbsolutePath().toString())).handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.body().getJsonObject().toString()).end();
        });
        TestRequest.testRequest(this.client, HttpMethod.POST, "/test").expect(TestRequest.statusCode(200), TestRequest.statusMessage("{}")).sendJson((Object)new JsonObject(), testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/test").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badBodyResponse(BodyProcessorException.BodyProcessorErrorType.VALIDATION_ERROR)).sendJson((Object)"aaa", testContext, checkpoint);
    }

    @Test
    public void testJsonBodyAsyncCircular(VertxTestContext testContext, @TempDir Path tempDir) {
        Checkpoint checkpoint = testContext.checkpoint(2);
        ValidationHandler validationHandler1 = ValidationHandler.builder((SchemaParser)this.parser).body(Bodies.json((SchemaBuilder)Schemas.ref((JsonPointer)JsonPointer.fromURI((URI)URI.create("tree_schema.json"))))).build();
        JsonObject testObj = new JsonObject().put("value", (Object)"aaa").put("childs", (Object)new JsonArray().add((Object)new JsonObject().put("value", (Object)"bbb")));
        this.router.post("/test").handler((Handler)BodyHandler.create((String)tempDir.toAbsolutePath().toString())).handler((Handler)validationHandler1).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().putHeader("content-type", "application/json").end(params.body().getJsonObject().toBuffer());
        });
        TestRequest.testRequest(this.client, HttpMethod.POST, "/test").expect(TestRequest.statusCode(200), TestRequest.jsonBodyResponse(testObj)).sendJson((Object)testObj, testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.POST, "/test").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badBodyResponse(BodyProcessorException.BodyProcessorErrorType.VALIDATION_ERROR)).sendJson((Object)"aaa", testContext, checkpoint);
    }

    @Test
    public void testQueryExpandedObjectAdditionalPropertiesAndDefault(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(4);
        ValidationHandler validationHandler = ValidationHandler.builder((SchemaParser)this.parser).queryParameter(Parameters.optionalExplodedParam((String)"explodedObject", (ObjectSchemaBuilder)((ObjectSchemaBuilder)Schemas.objectSchema().property("wellKnownProperty", (SchemaBuilder)Schemas.intSchema()).additionalProperties((SchemaBuilder)Schemas.booleanSchema()).defaultValue((Object)new JsonObject())))).build();
        this.router.get("/test").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().putHeader("content-type", "application/json").end(params.queryParameter("explodedObject").getJsonObject().toBuffer());
        });
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test").expect(TestRequest.statusCode(200), TestRequest.jsonBodyResponse(new JsonObject())).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?wellKnownProperty=10").expect(TestRequest.statusCode(200), TestRequest.jsonBodyResponse(new JsonObject().put("wellKnownProperty", (Object)10))).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?wellKnownProperty=10&myFlag=false").expect(TestRequest.statusCode(200), TestRequest.jsonBodyResponse(new JsonObject().put("wellKnownProperty", (Object)10).put("myFlag", (Object)false))).send(testContext, checkpoint);
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test?wellKnownProperty=10&myFlag=bla").expect(TestRequest.statusCode(400)).expect(ValidationTestUtils.badParameterResponse(ParameterProcessorException.ParameterProcessorErrorType.PARSING_ERROR, "explodedObject", ParameterLocation.QUERY)).send(testContext, checkpoint);
    }

    @Test
    public void testSimpleHeaderCaseInsensitivity(VertxTestContext testContext) {
        ValidationHandler validationHandler = ValidationHandler.builder((SchemaParser)this.parser).headerParameter(Parameters.param((String)"AnHeader", (NumberSchemaBuilder)Schemas.intSchema())).build();
        this.router.get("/test").handler((Handler)validationHandler).handler(routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().putHeader("content-type", "application/json").end(params.headerParameter("anHeader").getInteger().toString());
        });
        TestRequest.testRequest(this.client, HttpMethod.GET, "/test").with(TestRequest.requestHeader("anheader", "10")).expect(TestRequest.statusCode(200), TestRequest.jsonBodyResponse(10)).send(testContext);
    }
}

