/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.impl.parameter.ExplodedObjectValueParameterParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.testutils.TestParsers;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
public class ExplodedObjectValueParameterParserTest {
    SchemaRouter router;
    SchemaParser parser;

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testValid() {
        ExplodedObjectValueParameterParser parser = new ExplodedObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("prop1", Collections.singletonList("1"));
        map.put("prop2", Collections.singletonList("2.1"));
        map.put("prop3", Collections.singletonList("aaa"));
        map.put("prop4", Collections.singletonList("true"));
        map.put("other", Collections.singletonList("hello"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT.copy().put("other", (Object)"hello"));
        });
        Assertions.assertThat(map).isEmpty();
    }

    @Test
    public void testNoAdditionalProperties() {
        ExplodedObjectValueParameterParser parser = new ExplodedObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, null);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("prop1", Collections.singletonList("1"));
        map.put("prop2", Collections.singletonList("2.1"));
        map.put("prop3", Collections.singletonList("aaa"));
        map.put("prop4", Collections.singletonList("true"));
        map.put("other", Collections.singletonList("hello"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT);
        });
        Assertions.assertThat(map).containsKey((Object)"other");
    }

    @Test
    public void testNull() {
        ExplodedObjectValueParameterParser parser = new ExplodedObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("prop1", Collections.singletonList("1"));
        map.put("prop2", Collections.singletonList(""));
        map.put("prop3", Collections.singletonList(null));
        map.put("prop4", Collections.singletonList("true"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT.copy().putNull("prop2").putNull("prop3"));
        });
        Assertions.assertThat(map).isEmpty();
    }

    @Test
    public void testEmptyString() {
        ExplodedObjectValueParameterParser parser = new ExplodedObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("prop1", Collections.singletonList("1"));
        map.put("prop2", Collections.singletonList(""));
        map.put("prop3", Collections.singletonList(""));
        map.put("prop4", Collections.singletonList("true"));
        map.put("other", Collections.singletonList("hello"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT.copy().putNull("prop2").put("prop3", (Object)"").put("other", (Object)"hello"));
        });
        Assertions.assertThat(map).isEmpty();
    }

    @Test
    public void testMissingProp() {
        ExplodedObjectValueParameterParser parser = new ExplodedObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("prop1", Collections.singletonList("1"));
        map.put("prop3", Collections.singletonList("aaa"));
        map.put("other", Collections.singletonList("hello"));
        Object result = parser.parseParameter(map);
        JsonObject expected = TestParsers.SAMPLE_OBJECT.copy();
        expected.remove("prop2");
        expected.remove("prop4");
        expected.put("other", (Object)"hello");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)expected);
        });
        Assertions.assertThat(map).isEmpty();
    }

    @Test
    public void testInvalid() {
        ExplodedObjectValueParameterParser parser = new ExplodedObjectValueParameterParser("bla", TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("prop1", Collections.singletonList("1"));
        map.put("prop2", Collections.singletonList("2.1"));
        map.put("prop3", Collections.singletonList("aaa"));
        map.put("prop4", Collections.singletonList("hello"));
        map.put("other", Collections.singletonList("hello"));
        Assertions.assertThatExceptionOfType(MalformedValueException.class).isThrownBy(() -> parser.parseParameter(map));
    }
}

