/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.testutils;

import io.netty.handler.codec.http.QueryStringEncoder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.Json;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.multipart.MultipartForm;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.VertxTestContext;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;

public class TestRequest {
    HttpRequest<Buffer> req;
    List<Consumer<HttpRequest<Buffer>>> requestTranformations;
    List<Consumer<HttpResponse<Buffer>>> responseAsserts;

    private TestRequest(HttpRequest<Buffer> req) {
        this.req = req;
        this.requestTranformations = new ArrayList<Consumer<HttpRequest<Buffer>>>();
        this.responseAsserts = new ArrayList<Consumer<HttpResponse<Buffer>>>();
    }

    @SafeVarargs
    public final TestRequest with(Consumer<HttpRequest<Buffer>> ... transformations) {
        this.requestTranformations.addAll(Arrays.asList(transformations));
        return this;
    }

    @SafeVarargs
    public final TestRequest expect(Consumer<HttpResponse<Buffer>> ... asserts) {
        this.responseAsserts.addAll(Arrays.asList(asserts));
        return this;
    }

    public Future<HttpResponse<Buffer>> send(VertxTestContext testContext, Checkpoint checkpoint) {
        return this.internalSend(testContext, h -> this.req.send(h), () -> ((Checkpoint)checkpoint).flag());
    }

    public Future<HttpResponse<Buffer>> send(VertxTestContext testContext) {
        return this.internalSend(testContext, h -> this.req.send(h), () -> ((VertxTestContext)testContext).completeNow());
    }

    public Future<HttpResponse<Buffer>> send(VertxTestContext testContext, VertxTestContext.ExecutionBlock onEnd) {
        return this.internalSend(testContext, h -> this.req.send(h), onEnd);
    }

    public Future<HttpResponse<Buffer>> sendJson(Object json, VertxTestContext testContext, Checkpoint checkpoint) {
        return this.internalSend(testContext, h -> this.req.sendJson(json, h), () -> ((Checkpoint)checkpoint).flag());
    }

    public Future<HttpResponse<Buffer>> sendJson(Object json, VertxTestContext testContext) {
        return this.internalSend(testContext, h -> this.req.sendJson(json, h), () -> ((VertxTestContext)testContext).completeNow());
    }

    public Future<HttpResponse<Buffer>> sendJson(Object json, VertxTestContext testContext, VertxTestContext.ExecutionBlock onEnd) {
        return this.internalSend(testContext, h -> this.req.sendJson(json, h), onEnd);
    }

    public Future<HttpResponse<Buffer>> sendBuffer(Buffer buf, VertxTestContext testContext, Checkpoint checkpoint) {
        return this.internalSend(testContext, h -> this.req.sendBuffer(buf, h), () -> ((Checkpoint)checkpoint).flag());
    }

    public Future<HttpResponse<Buffer>> sendBuffer(Buffer buf, VertxTestContext testContext) {
        return this.internalSend(testContext, h -> this.req.sendBuffer(buf, h), () -> ((VertxTestContext)testContext).completeNow());
    }

    public Future<HttpResponse<Buffer>> sendBuffer(Buffer buf, VertxTestContext testContext, VertxTestContext.ExecutionBlock onEnd) {
        return this.internalSend(testContext, h -> this.req.sendBuffer(buf, h), onEnd);
    }

    public Future<HttpResponse<Buffer>> sendURLEncodedForm(MultiMap form, VertxTestContext testContext, Checkpoint checkpoint) {
        return this.internalSend(testContext, h -> this.req.sendForm(form, h), () -> ((Checkpoint)checkpoint).flag());
    }

    public Future<HttpResponse<Buffer>> sendURLEncodedForm(MultiMap form, VertxTestContext testContext) {
        return this.internalSend(testContext, h -> this.req.sendForm(form, h), () -> ((VertxTestContext)testContext).completeNow());
    }

    public Future<HttpResponse<Buffer>> sendURLEncodedForm(MultiMap form, VertxTestContext testContext, VertxTestContext.ExecutionBlock onEnd) {
        return this.internalSend(testContext, h -> this.req.sendForm(form, h), onEnd);
    }

    public Future<HttpResponse<Buffer>> sendMultipartForm(MultipartForm form, VertxTestContext testContext, Checkpoint checkpoint) {
        return this.internalSend(testContext, h -> this.req.sendMultipartForm(form, h), () -> ((Checkpoint)checkpoint).flag());
    }

    public Future<HttpResponse<Buffer>> sendMultipartForm(MultipartForm form, VertxTestContext testContext) {
        return this.internalSend(testContext, h -> this.req.sendMultipartForm(form, h), () -> ((VertxTestContext)testContext).completeNow());
    }

    public Future<HttpResponse<Buffer>> sendMultipartForm(MultipartForm form, VertxTestContext testContext, VertxTestContext.ExecutionBlock onEnd) {
        return this.internalSend(testContext, h -> this.req.sendMultipartForm(form, h), onEnd);
    }

    private Handler<AsyncResult<HttpResponse<Buffer>>> generateHandleResponse(VertxTestContext testContext, VertxTestContext.ExecutionBlock onEnd, Promise<HttpResponse<Buffer>> fut, StackTraceElement[] stackTrace) {
        return ar -> {
            if (ar.failed()) {
                testContext.failNow(ar.cause());
            } else {
                testContext.verify(() -> {
                    try {
                        this.responseAsserts.forEach(c -> c.accept(ar.result()));
                    }
                    catch (AssertionError e) {
                        AssertionError newE = new AssertionError("Assertion error in response: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
                        ((Throwable)((Object)newE)).setStackTrace(stackTrace);
                        throw newE;
                    }
                    onEnd.apply();
                });
                fut.complete(ar.result());
            }
        };
    }

    private Future<HttpResponse<Buffer>> internalSend(VertxTestContext testContext, Consumer<Handler<AsyncResult<HttpResponse<Buffer>>>> reqSendFunction, VertxTestContext.ExecutionBlock onEnd) {
        Promise promise = Promise.promise();
        this.requestTranformations.forEach(c -> c.accept(this.req));
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        reqSendFunction.accept(this.generateHandleResponse(testContext, onEnd, (Promise<HttpResponse<Buffer>>)promise, Arrays.copyOfRange(stackTrace, 3, stackTrace.length)));
        return promise.future();
    }

    public static TestRequest testRequest(WebClient client, HttpMethod method, String path) {
        return new TestRequest((HttpRequest<Buffer>)client.request(method, path));
    }

    public static TestRequest testRequest(HttpRequest<Buffer> request) {
        return new TestRequest(request);
    }

    public static Consumer<HttpRequest<Buffer>> requestHeader(String key, String value) {
        return req -> req.putHeader(key, value);
    }

    public static Consumer<HttpRequest<Buffer>> cookie(QueryStringEncoder encoder) {
        return req -> {
            try {
                String rawQuery = encoder.toUri().getRawQuery();
                if (rawQuery != null && !rawQuery.isEmpty()) {
                    req.putHeader("cookie", encoder.toUri().getRawQuery());
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        };
    }

    public static Consumer<HttpRequest<Buffer>> queryParam(String key, String value) {
        return req -> req.addQueryParam(key, value);
    }

    public static Consumer<HttpResponse<Buffer>> statusCode(int statusCode) {
        return res -> Assertions.assertEquals((int)statusCode, (int)res.statusCode());
    }

    public static Consumer<HttpResponse<Buffer>> statusMessage(String statusMessage) {
        return res -> Assertions.assertEquals((Object)statusMessage, (Object)res.statusMessage());
    }

    public static Consumer<HttpResponse<Buffer>> jsonBodyResponse(Object expected) {
        return res -> {
            String ctHeader = res.getHeader("content-type");
            Assertions.assertNotNull((Object)ctHeader, (String)"Content-type must not be null");
            Assertions.assertTrue((boolean)ctHeader.contains("application/json"), (String)("Expected application/json Content-type, Actual: " + ctHeader));
            Object json = Json.decodeValue((Buffer)res.bodyAsBuffer());
            Assertions.assertEquals((Object)expected, (Object)json);
        };
    }

    public static Consumer<HttpResponse<Buffer>> bodyResponse(Buffer expected, String expectedContentType) {
        return res -> {
            Assertions.assertEquals((Object)expectedContentType, (Object)res.getHeader("content-type"));
            Assertions.assertEquals((Object)expected, (Object)res.bodyAsBuffer());
        };
    }

    public static Consumer<HttpResponse<Buffer>> responseHeader(String headerName, String headerValue) {
        return res -> Assertions.assertEquals((Object)headerValue, (Object)res.getHeader(headerName));
    }

    public static Consumer<HttpResponse<Buffer>> stringBody(Consumer<String> assertBody) {
        return res -> assertBody.accept(res.bodyAsString());
    }

    public static Consumer<HttpResponse<Buffer>> emptyResponse() {
        return res -> Assertions.assertNull((Object)res.body());
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

