/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.validation.BodyProcessorException;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.builder.Bodies;
import io.vertx.ext.web.validation.impl.body.BodyProcessor;
import io.vertx.ext.web.validation.testutils.TestSchemas;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.common.dsl.ObjectSchemaBuilder;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Extensions(value={@ExtendWith(value={VertxExtension.class}), @ExtendWith(value={MockitoExtension.class})})
class FormBodyProcessorImplTest {
    SchemaRouter router;
    SchemaParser parser;
    @Mock
    RoutingContext mockedContext;
    @Mock
    HttpServerRequest mockedServerRequest;

    FormBodyProcessorImplTest() {
    }

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testFormBodyProcessor(VertxTestContext testContext) {
        ObjectSchemaBuilder schemaBuilder = TestSchemas.SAMPLE_OBJECT_SCHEMA_BUILDER;
        MultiMap map = MultiMap.caseInsensitiveMultiMap();
        map.add("someNumbers", "1.1");
        map.add("someNumbers", "2.2");
        map.add("oneNumber", "3.3");
        map.add("someIntegers", "1");
        map.add("someIntegers", "2");
        map.add("oneInteger", "3");
        map.add("aBoolean", "true");
        Mockito.when((Object)this.mockedServerRequest.formAttributes()).thenReturn((Object)map);
        Mockito.when((Object)this.mockedContext.request()).thenReturn((Object)this.mockedServerRequest);
        BodyProcessor processor = Bodies.formUrlEncoded((ObjectSchemaBuilder)schemaBuilder).create(this.parser);
        Assertions.assertThat((boolean)processor.canProcess("application/x-www-form-urlencoded")).isTrue();
        processor.process(this.mockedContext).onComplete(testContext.succeeding(rp -> {
            testContext.verify(() -> {
                Assertions.assertThat((boolean)rp.isJsonObject()).isTrue();
                Assertions.assertThat((Iterable)rp.getJsonObject()).isEqualTo((Object)new JsonObject().put("someNumbers", (Object)new JsonArray().add((Object)1.1).add((Object)2.2)).put("oneNumber", (Object)3.3).put("someIntegers", (Object)new JsonArray().add((Object)1L).add((Object)2L)).put("oneInteger", (Object)3L).put("aBoolean", (Object)true));
            });
            testContext.completeNow();
        }));
    }

    @Test
    public void testFormBodyProcessorParsingFailure(VertxTestContext testContext) {
        ObjectSchemaBuilder schemaBuilder = TestSchemas.SAMPLE_OBJECT_SCHEMA_BUILDER;
        MultiMap map = MultiMap.caseInsensitiveMultiMap();
        map.add("someNumbers", "1.1");
        map.add("someNumbers", "2.2");
        map.add("oneNumber", "3.3");
        map.add("someIntegers", "1");
        map.add("someIntegers", "hello");
        map.add("oneInteger", "3");
        map.add("aBoolean", "true");
        Mockito.when((Object)this.mockedServerRequest.getHeader(HttpHeaders.CONTENT_TYPE)).thenReturn((Object)"application/x-www-form-urlencoded");
        Mockito.when((Object)this.mockedServerRequest.formAttributes()).thenReturn((Object)map);
        Mockito.when((Object)this.mockedContext.request()).thenReturn((Object)this.mockedServerRequest);
        BodyProcessor processor = Bodies.formUrlEncoded((ObjectSchemaBuilder)schemaBuilder).create(this.parser);
        Assertions.assertThat((boolean)processor.canProcess("application/x-www-form-urlencoded")).isTrue();
        processor.process(this.mockedContext).onComplete(testContext.failing(err -> {
            testContext.verify(() -> ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)err).isInstanceOf(BodyProcessorException.class)).hasFieldOrPropertyWithValue("actualContentType", (Object)"application/x-www-form-urlencoded")).hasCauseInstanceOf(MalformedValueException.class));
            testContext.completeNow();
        }));
    }
}

