/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Vertx;
import io.vertx.ext.web.validation.ParameterProcessorException;
import io.vertx.ext.web.validation.builder.Parameters;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import io.vertx.ext.web.validation.testutils.TestSchemas;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.dsl.SchemaBuilder;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.mockito.junit.jupiter.MockitoExtension;

@Extensions(value={@ExtendWith(value={VertxExtension.class}), @ExtendWith(value={MockitoExtension.class})})
public class ParameterProcessorIntegrationTest {
    SchemaRouter router;
    SchemaParser parser;

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testJsonParam(VertxTestContext testContext) {
        ParameterProcessor processor = Parameters.jsonParam((String)"myParam", (SchemaBuilder)TestSchemas.SAMPLE_OBJECT_SCHEMA_BUILDER).create(ParameterLocation.QUERY, this.parser);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("myParam", Collections.singletonList(TestSchemas.VALID_OBJECT.encode()));
        processor.process(map).onComplete(testContext.succeeding(rp -> {
            testContext.verify(() -> {
                Assertions.assertThat((boolean)rp.isJsonObject()).isTrue();
                Assertions.assertThat((Iterable)rp.getJsonObject()).isEqualTo((Object)TestSchemas.VALID_OBJECT);
            });
            testContext.completeNow();
        }));
    }

    @Test
    public void testInvalidJsonParam(VertxTestContext testContext) {
        ParameterProcessor processor = Parameters.jsonParam((String)"myParam", (SchemaBuilder)TestSchemas.SAMPLE_OBJECT_SCHEMA_BUILDER).create(ParameterLocation.QUERY, this.parser);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("myParam", Collections.singletonList(TestSchemas.INVALID_OBJECT.encode()));
        processor.process(map).onComplete(testContext.failing(throwable -> {
            testContext.verify(() -> ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isInstanceOf(ParameterProcessorException.class)).hasFieldOrPropertyWithValue("errorType", (Object)ParameterProcessorException.ParameterProcessorErrorType.VALIDATION_ERROR)).hasFieldOrPropertyWithValue("location", (Object)ParameterLocation.QUERY)).hasFieldOrPropertyWithValue("parameterName", (Object)"myParam")).hasCauseInstanceOf(ValidationException.class));
            testContext.completeNow();
        }));
    }
}

