/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.validation.BodyProcessorException;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.builder.Bodies;
import io.vertx.ext.web.validation.impl.body.BodyProcessor;
import io.vertx.ext.web.validation.testutils.TestSchemas;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.common.dsl.StringSchemaBuilder;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Extensions(value={@ExtendWith(value={VertxExtension.class}), @ExtendWith(value={MockitoExtension.class})})
public class TextPlainBodyProcessorTest {
    SchemaRouter router;
    SchemaParser parser;
    @Mock
    RoutingContext mockedContext;
    @Mock
    HttpServerRequest mockerServerRequest;

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testString(VertxTestContext testContext) {
        Mockito.when((Object)this.mockedContext.getBodyAsString()).thenReturn((Object)TestSchemas.VALID_STRING);
        BodyProcessor processor = Bodies.textPlain((StringSchemaBuilder)TestSchemas.SAMPLE_STRING_SCHEMA_BUILDER).create(this.parser);
        processor.process(this.mockedContext).onComplete(testContext.succeeding(rp -> {
            testContext.verify(() -> {
                Assertions.assertThat((boolean)rp.isString()).isTrue();
                Assertions.assertThat((String)rp.getString()).isEqualTo(TestSchemas.VALID_STRING);
            });
            testContext.completeNow();
        }));
    }

    @Test
    public void testNullBody() {
        Mockito.when((Object)this.mockerServerRequest.getHeader(HttpHeaders.CONTENT_TYPE)).thenReturn((Object)"text/plain");
        Mockito.when((Object)this.mockedContext.request()).thenReturn((Object)this.mockerServerRequest);
        Mockito.when((Object)this.mockedContext.getBodyAsString()).thenReturn(null);
        BodyProcessor processor = Bodies.textPlain((StringSchemaBuilder)TestSchemas.SAMPLE_STRING_SCHEMA_BUILDER).create(this.parser);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatCode(() -> processor.process(this.mockedContext)).isInstanceOf(BodyProcessorException.class)).hasFieldOrPropertyWithValue("actualContentType", (Object)"text/plain")).hasCauseInstanceOf(MalformedValueException.class);
    }
}

